/*
 * Decompiled with CFR 0.152.
 */
package br.gov.serpro.rtc.api.controller;

import br.gov.serpro.rtc.api.model.input.OperacaoInput;
import br.gov.serpro.rtc.api.model.roc.ROC;
import br.gov.serpro.rtc.api.openapi.controller.CalculadoraTributoControllerOpenApi;
import br.gov.serpro.rtc.domain.service.CalculadoraService;
import br.gov.serpro.rtc.domain.service.VersaoBaseDadosService;
import br.gov.serpro.rtc.domain.service.xml.XmlService;
import jakarta.validation.Valid;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.HttpHeaders;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"calculadora"})
public class CalculadoraTributoController
implements CalculadoraTributoControllerOpenApi {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(CalculadoraTributoController.class);
    @Value(value="${info.app.version:unknown}")
    private String versaoAplicacao;
    private final VersaoBaseDadosService versaoBaseDadosService;
    private final CalculadoraService calculadoraService;
    private final XmlService xmlService;

    @PostMapping(value={"regime-geral"})
    public ResponseEntity<ROC> calcularTributos(@RequestBody @Valid OperacaoInput operacao) {
        log.debug("ROC ID {}", (Object)operacao.getId());
        return ((ResponseEntity.BodyBuilder)ResponseEntity.ok().headers(this.getHeaders())).body((Object)this.calculadoraService.calcularTributos(operacao));
    }

    @PostMapping(value={"gerar-xml"}, produces={"application/xml"})
    public ResponseEntity<ROC> gerarXml(@RequestBody ROC roc) {
        log.debug("Gerando xml...");
        return ((ResponseEntity.BodyBuilder)ResponseEntity.ok().headers(this.getHeaders())).body((Object)roc);
    }

    @PostMapping(value={"validar-xml"}, consumes={"application/xml"})
    public ResponseEntity<Boolean> validarXml(@RequestBody String xml, @RequestParam(required=true) String tipo, @RequestParam(required=true) String subtipo) {
        boolean valido = this.xmlService.validarXml(xml, tipo, subtipo);
        return ResponseEntity.ok((Object)valido);
    }

    private HttpHeaders getHeaders() {
        HttpHeaders headers = new HttpHeaders();
        headers.add("X-CALC-APP-VERSION", this.versaoAplicacao);
        headers.add("X-CALC-DB-VERSION", this.versaoBaseDadosService.getUltimaVersao().getNumeroVersao());
        return headers;
    }

    @Generated
    public CalculadoraTributoController(VersaoBaseDadosService versaoBaseDadosService, CalculadoraService calculadoraService, XmlService xmlService) {
        this.versaoBaseDadosService = versaoBaseDadosService;
        this.calculadoraService = calculadoraService;
        this.xmlService = xmlService;
    }
}

