/*
 * Decompiled with CFR 0.152.
 */
package br.gov.serpro.rtc.api.controller;

import br.gov.serpro.rtc.api.model.output.dadosabertos.AliquotaDadosAbertosOutput;
import br.gov.serpro.rtc.api.model.output.dadosabertos.ClassificacaoTributariaDadosAbertosOutput;
import br.gov.serpro.rtc.api.model.output.dadosabertos.FundamentacaoClassificacaoDadosAbertosOutput;
import br.gov.serpro.rtc.api.model.output.dadosabertos.MunicipioDadosAbertosOutput;
import br.gov.serpro.rtc.api.model.output.dadosabertos.NbsDadosAbertosOutput;
import br.gov.serpro.rtc.api.model.output.dadosabertos.NcmDadosAbertosOutput;
import br.gov.serpro.rtc.api.model.output.dadosabertos.SituacaoTributariaDadosAbertosOutput;
import br.gov.serpro.rtc.api.model.output.dadosabertos.UfDadosAbertosOutput;
import br.gov.serpro.rtc.api.openapi.controller.DadosAbertosControllerOpenApi;
import br.gov.serpro.rtc.domain.service.dadosabertos.DadosAbertosService;
import java.time.LocalDate;
import java.util.List;
import lombok.Generated;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"calculadora/dados-abertos"})
public class DadosAbertosController
implements DadosAbertosControllerOpenApi {
    private final DadosAbertosService dadosAbertosService;

    @GetMapping(value={"/ufs"})
    public ResponseEntity<List<UfDadosAbertosOutput>> consultarUfs() {
        return ((ResponseEntity.BodyBuilder)ResponseEntity.ok().header("Cache-Control", new String[]{"public, max-age=3600"})).body((Object)this.dadosAbertosService.consultarUfs());
    }

    @GetMapping(value={"/ufs/municipios"})
    public ResponseEntity<List<MunicipioDadosAbertosOutput>> consultarMunicipiosPorSiglaUf(@RequestParam String siglaUf) {
        return ((ResponseEntity.BodyBuilder)ResponseEntity.ok().header("Cache-Control", new String[]{"public, max-age=3600"})).body((Object)this.dadosAbertosService.consultarMunicipiosPorSiglaUf(siglaUf));
    }

    @GetMapping(value={"/situacoes-tributarias/cbs-ibs"})
    public ResponseEntity<List<SituacaoTributariaDadosAbertosOutput>> consultarSituacoesTributariasCbsIbs(@RequestParam LocalDate data) {
        return ResponseEntity.ok((Object)this.dadosAbertosService.consultarSituacoesTributarias(Long.valueOf(2L), data));
    }

    @GetMapping(value={"/classificacoes-tributarias/{idSituacaoTributaria}"})
    public ResponseEntity<List<ClassificacaoTributariaDadosAbertosOutput>> consultarClassificacoesTributariasPorIdSituacaoTributaria(@PathVariable Long idSituacaoTributaria, @RequestParam LocalDate data) {
        return ResponseEntity.ok((Object)this.dadosAbertosService.consultarClassificacoesTributariasPorIdSituacaoTributaria(idSituacaoTributaria, data));
    }

    @GetMapping(value={"/classificacoes-tributarias/cbs-ibs"})
    public ResponseEntity<List<ClassificacaoTributariaDadosAbertosOutput>> consultarClassificacoesTributariasCbsIbs(@RequestParam LocalDate data) {
        return ResponseEntity.ok((Object)this.dadosAbertosService.consultarClassificacoesTributariasCbsIbs(data));
    }

    @GetMapping(value={"/classificacoes-tributarias/imposto-seletivo"})
    public ResponseEntity<List<ClassificacaoTributariaDadosAbertosOutput>> consultarClassificacoesTributariasImpostoSeletivo(@RequestParam LocalDate data) {
        return ResponseEntity.ok((Object)this.dadosAbertosService.consultarClassificacoesTributariasImpostoSeletivo(data));
    }

    @GetMapping(value={"/situacoes-tributarias/imposto-seletivo"})
    public ResponseEntity<List<SituacaoTributariaDadosAbertosOutput>> consultarSituacoesTributariasImpostoSeletivo(@RequestParam LocalDate data) {
        return ResponseEntity.ok((Object)this.dadosAbertosService.consultarSituacoesTributarias(Long.valueOf(1L), data));
    }

    @GetMapping(value={"/ncm"})
    public ResponseEntity<NcmDadosAbertosOutput> consultarNcm(@RequestParam String ncm, @RequestParam LocalDate data) {
        return ResponseEntity.ok((Object)this.dadosAbertosService.consultarNcm(ncm, data));
    }

    @GetMapping(value={"/nbs"})
    public ResponseEntity<NbsDadosAbertosOutput> consultarNbs(@RequestParam String nbs, @RequestParam LocalDate data) {
        return ResponseEntity.ok((Object)this.dadosAbertosService.consultarNbs(nbs, data));
    }

    @GetMapping(value={"/fundamentacoes-legais"})
    public ResponseEntity<List<FundamentacaoClassificacaoDadosAbertosOutput>> consultarFundamentacoesLegais(@RequestParam LocalDate data) {
        return ResponseEntity.ok((Object)this.dadosAbertosService.consultarFundamentacoesLegais(data));
    }

    @GetMapping(value={"/aliquota-uniao"})
    public ResponseEntity<AliquotaDadosAbertosOutput> consultarAliquotaUniao(@RequestParam LocalDate data) {
        return ResponseEntity.ok((Object)this.dadosAbertosService.consultarAliquota(Long.valueOf(2L), null, null, data));
    }

    @GetMapping(value={"/aliquota-uf"})
    public ResponseEntity<AliquotaDadosAbertosOutput> consultarAliquotaUf(@RequestParam Long codigoUf, @RequestParam LocalDate data) {
        return ResponseEntity.ok((Object)this.dadosAbertosService.consultarAliquota(Long.valueOf(3L), codigoUf, null, data));
    }

    @GetMapping(value={"/aliquota-municipio"})
    public ResponseEntity<AliquotaDadosAbertosOutput> consultarAliquotaMunicipio(@RequestParam Long codigoMunicipio, @RequestParam LocalDate data) {
        return ResponseEntity.ok((Object)this.dadosAbertosService.consultarAliquota(Long.valueOf(4L), null, codigoMunicipio, data));
    }

    @Generated
    public DadosAbertosController(DadosAbertosService dadosAbertosService) {
        this.dadosAbertosService = dadosAbertosService;
    }
}

