/*
 * Decompiled with CFR 0.152.
 */
package br.gov.serpro.rtc.api.controller;

import br.gov.serpro.rtc.api.model.output.DownloadUrlOutput;
import io.micrometer.core.instrument.Counter;
import io.micrometer.core.instrument.MeterRegistry;
import io.swagger.v3.oas.annotations.Hidden;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"calculadora/download"})
@Hidden
public class DownloadController {
    @Value(value="${application.downloadUrl.default:}")
    private String downloadUrlDefault;
    @Value(value="${application.downloadUrl.jar:}")
    private String downloadUrlJar;
    private final MeterRegistry meterRegistry;

    public DownloadController(MeterRegistry meterRegistry) {
        this.meterRegistry = meterRegistry;
    }

    @GetMapping(value={"/url"})
    public ResponseEntity<DownloadUrlOutput> getDownloadUrl(@RequestParam(value="platform") String platform) {
        try {
            String downloadUrl = this.getDownloadUrlByPlatform(platform);
            if (downloadUrl == null || downloadUrl.trim().isEmpty()) {
                return ResponseEntity.noContent().build();
            }
            Counter.builder((String)"api_calc_downloads_total").description("Total number of download URL requests").tag("endpoint", "download-url").tag("platform", platform.toLowerCase()).register(this.meterRegistry).increment();
            return ResponseEntity.ok((Object)new DownloadUrlOutput(downloadUrl));
        }
        catch (IllegalArgumentException e) {
            return ResponseEntity.badRequest().build();
        }
    }

    private String getDownloadUrlByPlatform(String platform) {
        if (platform == null || platform.trim().isEmpty()) {
            throw new IllegalArgumentException("Par\u00e2metro 'platform' n\u00e3o pode ser nulo ou vazio. Valores aceitos: 'default' ou 'jar'");
        }
        String platformLower = platform.toLowerCase().trim();
        if ("default".equals(platformLower)) {
            return this.downloadUrlDefault;
        }
        if ("jar".equals(platformLower)) {
            return this.downloadUrlJar;
        }
        throw new IllegalArgumentException("Par\u00e2metro 'platform' inv\u00e1lido. Valores aceitos: 'default' ou 'jar'");
    }
}

