/*
 * Decompiled with CFR 0.152.
 */
package br.gov.serpro.rtc.api.exceptionhandler;

import br.gov.serpro.rtc.api.exceptionhandler.ProblemType;
import br.gov.serpro.rtc.domain.service.exception.CampoInvalidoException;
import br.gov.serpro.rtc.domain.service.exception.EntidadeNaoEncontradaException;
import br.gov.serpro.rtc.domain.service.exception.ErroInternoSistemaException;
import br.gov.serpro.rtc.domain.service.exception.EstruturaInconsistenteException;
import br.gov.serpro.rtc.domain.service.exception.ValidacaoException;
import java.time.Instant;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ProblemDetail;
import org.springframework.http.ResponseEntity;
import org.springframework.lang.NonNull;
import org.springframework.lang.Nullable;
import org.springframework.web.bind.MethodArgumentNotValidException;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.RestControllerAdvice;
import org.springframework.web.context.request.WebRequest;
import org.springframework.web.servlet.mvc.method.annotation.ResponseEntityExceptionHandler;

/*
 * Exception performing whole class analysis ignored.
 */
@RestControllerAdvice
public class ApiExceptionHandler
extends ResponseEntityExceptionHandler {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ApiExceptionHandler.class);

    protected ResponseEntity<Object> handleExceptionInternal(@NonNull Exception ex, @Nullable Object body, @NonNull HttpHeaders headers, @NonNull HttpStatusCode statusCode, @NonNull WebRequest request) {
        log.error("Erro: ", (Throwable)ex);
        return super.handleExceptionInternal(ex, body, headers, statusCode, request);
    }

    protected ResponseEntity<Object> handleMethodArgumentNotValid(@NonNull MethodArgumentNotValidException ex, @NonNull HttpHeaders headers, @NonNull HttpStatusCode status, @NonNull WebRequest request) {
        HttpStatus httpStatus = HttpStatus.BAD_REQUEST;
        ProblemDetail problemDetail = ApiExceptionHandler.createProblem((Exception)ex, (HttpStatus)httpStatus);
        problemDetail.setTitle("Campos inv\u00e1lidos.");
        StringBuilder detailMessage = new StringBuilder("Um ou mais campos s\u00e3o inv\u00e1lidos - ");
        ex.getBindingResult().getFieldErrors().forEach(error -> detailMessage.append(String.format("[%s: %s] ", error.getField(), error.getDefaultMessage())));
        problemDetail.setDetail(detailMessage.toString());
        return this.handleExceptionInternal((Exception)ex, (Object)problemDetail, headers, (HttpStatusCode)httpStatus, request);
    }

    @ExceptionHandler(value={ValidacaoException.class})
    ResponseEntity<Object> handleNegocioException(ValidacaoException ex, WebRequest request) {
        HttpStatus status = HttpStatus.UNPROCESSABLE_ENTITY;
        ProblemDetail problemDetail = ApiExceptionHandler.createProblem((Exception)ex, (HttpStatus)status);
        return this.handleExceptionInternal((Exception)ex, (Object)problemDetail, new HttpHeaders(), (HttpStatusCode)status, request);
    }

    @ExceptionHandler(value={CampoInvalidoException.class})
    ResponseEntity<Object> handleCampoInvalidoException(CampoInvalidoException ex, WebRequest request) {
        HttpStatus status = HttpStatus.BAD_REQUEST;
        ProblemDetail problemDetail = ApiExceptionHandler.createProblem((Exception)ex, (HttpStatus)status);
        return this.handleExceptionInternal((Exception)ex, (Object)problemDetail, new HttpHeaders(), (HttpStatusCode)status, request);
    }

    @ExceptionHandler(value={EntidadeNaoEncontradaException.class})
    public ResponseEntity<Object> handleEntidadeNaoEncontradaException(EntidadeNaoEncontradaException ex, WebRequest request) {
        HttpStatus status = HttpStatus.NOT_FOUND;
        ProblemDetail problemDetail = ApiExceptionHandler.createProblem((Exception)ex, (HttpStatus)status);
        return this.handleExceptionInternal((Exception)ex, (Object)problemDetail, new HttpHeaders(), (HttpStatusCode)status, request);
    }

    @ExceptionHandler(value={EstruturaInconsistenteException.class})
    ResponseEntity<Object> handleEstruturaInconsistenteException(EstruturaInconsistenteException ex, WebRequest request) {
        HttpStatus status = HttpStatus.BAD_REQUEST;
        ProblemDetail problemDetail = ApiExceptionHandler.createProblem((Exception)ex, (HttpStatus)status);
        return this.handleExceptionInternal((Exception)ex, (Object)problemDetail, new HttpHeaders(), (HttpStatusCode)status, request);
    }

    @ExceptionHandler(value={ErroInternoSistemaException.class})
    ResponseEntity<Object> handleErroInternoSistemaException(ErroInternoSistemaException ex, WebRequest request) {
        return this.handleGenericException((Exception)ex, request);
    }

    @ExceptionHandler(value={Exception.class})
    ResponseEntity<Object> handleGenericException(Exception ex, WebRequest request) {
        HttpStatus status = HttpStatus.INTERNAL_SERVER_ERROR;
        ProblemDetail problemDetail = ApiExceptionHandler.createProblem((Exception)ex, (HttpStatus)status);
        return this.handleExceptionInternal(ex, (Object)problemDetail, new HttpHeaders(), (HttpStatusCode)status, request);
    }

    private static <E extends Exception> ProblemDetail createProblem(E ex, HttpStatus status) {
        ProblemType type = ProblemType.from(ex);
        ProblemDetail problemDetail = ProblemDetail.forStatusAndDetail((HttpStatusCode)status, (String)ex.getMessage());
        problemDetail.setType(type.getURI());
        problemDetail.setTitle(type.getTitulo());
        problemDetail.setProperty("timestamp", (Object)Instant.now());
        return problemDetail;
    }
}

