/*
 * Decompiled with CFR 0.152.
 */
package br.gov.serpro.rtc.api.exceptionhandler;

import br.gov.serpro.rtc.api.util.HttpUtils;
import br.gov.serpro.rtc.domain.service.exception.AliquotaAdRemNaoEncontradaException;
import br.gov.serpro.rtc.domain.service.exception.AliquotaReferenciaNaoEncontradaException;
import br.gov.serpro.rtc.domain.service.exception.CampoInvalidoException;
import br.gov.serpro.rtc.domain.service.exception.ClassificacaoTributariaNaoEncontradaException;
import br.gov.serpro.rtc.domain.service.exception.ClassificacaoTributariaNaoVinculadaSituacaoTributariaException;
import br.gov.serpro.rtc.domain.service.exception.DesoneracaoInformadaIndevidamenteException;
import br.gov.serpro.rtc.domain.service.exception.DesoneracaoNaoInformadaException;
import br.gov.serpro.rtc.domain.service.exception.ErroFaltaImplementacaoException;
import br.gov.serpro.rtc.domain.service.exception.ErroInternoSistemaException;
import br.gov.serpro.rtc.domain.service.exception.ErroXmlException;
import br.gov.serpro.rtc.domain.service.exception.FormaAplicacaoNaoDefinidaException;
import br.gov.serpro.rtc.domain.service.exception.ImpostoSeletivoInformadoIndevidamenteException;
import br.gov.serpro.rtc.domain.service.exception.ImpostoSeletivoNaoInformadoException;
import br.gov.serpro.rtc.domain.service.exception.IncompatibilidadeSuspensaoException;
import br.gov.serpro.rtc.domain.service.exception.ItemDuplicadoException;
import br.gov.serpro.rtc.domain.service.exception.MunicipioNaoEncontradoException;
import br.gov.serpro.rtc.domain.service.exception.MunicipioNaoPertencenteException;
import br.gov.serpro.rtc.domain.service.exception.NbsCompletoNaoInformadoException;
import br.gov.serpro.rtc.domain.service.exception.NbsNaoEncontradaException;
import br.gov.serpro.rtc.domain.service.exception.NbsNaoVinculadaException;
import br.gov.serpro.rtc.domain.service.exception.NcmCompletoNaoInformadoException;
import br.gov.serpro.rtc.domain.service.exception.NcmNaoEncontradaException;
import br.gov.serpro.rtc.domain.service.exception.NcmNaoVinculadaException;
import br.gov.serpro.rtc.domain.service.exception.NcmNbsSimultaneasException;
import br.gov.serpro.rtc.domain.service.exception.NegocioException;
import br.gov.serpro.rtc.domain.service.exception.NomenclaturaException;
import br.gov.serpro.rtc.domain.service.exception.SituacaoTributariaNaoEncontradaException;
import br.gov.serpro.rtc.domain.service.exception.UfNaoEncontradaException;
import java.net.URI;
import java.util.stream.Stream;
import lombok.Generated;
import lombok.NonNull;

/*
 * Exception performing whole class analysis ignored.
 */
public enum ProblemType {
    CAMPO_INVALIDO(CampoInvalidoException.class, "Campo inv\u00e1lido", "campo-invalido"),
    ALIQUOTA_REFERENCIA_NAO_ENCONTRADA(AliquotaReferenciaNaoEncontradaException.class, "Al\u00edquota de refer\u00eancia n\u00e3o encontrada", "aliquota-referencia-nao-encontrada"),
    ALIQUOTA_AD_REM_NAO_ENCONTRADA(AliquotaAdRemNaoEncontradaException.class, "Al\u00edquota ad rem n\u00e3o encontrada", "aliquota-ad-rem-nao-encontrada"),
    CLASSIFICACAO_TRIBUTARIA_NAO_ENCONTRADA(ClassificacaoTributariaNaoEncontradaException.class, "Classifica\u00e7\u00e3o tribut\u00e1ria n\u00e3o encontrada", "classificacao-tributaria-nao-encontrada"),
    CLASSIFICACAO_TRIBUTARIA_NAO_VINCULADA_SITUACAO_TRIBUTARIA(ClassificacaoTributariaNaoVinculadaSituacaoTributariaException.class, "Classifica\u00e7\u00e3o tribut\u00e1ria n\u00e3o vinculada \u00e0 situa\u00e7\u00e3o tribut\u00e1ria", "classificacao-tributaria-nao-vinculada-situacao-tributaria"),
    INCOMPATIBILIDADE_SUSPENSAO(IncompatibilidadeSuspensaoException.class, "Incompatibilidade com suspens\u00e3o", "incompatibilidade-suspensao"),
    GRUPO_DESONERACAO_NAO_INFORMADO(DesoneracaoNaoInformadaException.class, "Grupo de desonera\u00e7\u00e3o n\u00e3o informado", "grupo-desoneracao-nao-informado"),
    GRUPO_DESONERACAO_INFORMADO_INDEVIDAMENTE(DesoneracaoInformadaIndevidamenteException.class, "Grupo de desonera\u00e7\u00e3o informado indevidamente", "grupo-desoneracao-informado-indevidamente"),
    IMPOSTO_SELETIVO_NAO_INFORMADO(ImpostoSeletivoNaoInformadoException.class, "Dados do Imposto Seletivo n\u00e3o informados", "dados-imposto-seletivo-nao-informados"),
    IMPOSTO_SELETIVO_INFORMADO_INDEVIDAMENTE(ImpostoSeletivoInformadoIndevidamenteException.class, "Dados do Imposto Seletivo informados indevidamente", "dados-imposto-seletivo-informados-indevidamente"),
    ERRO_NOMENCLATURA(NomenclaturaException.class, "Erro de nomenclatura", "erro-nomenclatura"),
    ERRO_INTERNO_SISTEMA(ErroInternoSistemaException.class, "Erro interno do sistema", "erro-interno-de-sistema"),
    FORMA_APLICACAO_NAO_DEFINIDA(FormaAplicacaoNaoDefinidaException.class, "Forma de Aplica\u00e7\u00e3o de Percentual n\u00e3o definida", "forma-aplicacao-percentual-nao-definida"),
    NCM_E_NBS_SIMULTANEAS(NcmNbsSimultaneasException.class, "NCM e NBS informadas simultaneamente", "ncm-nbs-simultaneas"),
    NCM_COMPLETO_NAO_INFORMADO(NcmCompletoNaoInformadoException.class, "NCM completo n\u00e3o informado", "ncm-completo-nao-informado"),
    NBS_COMPLETO_NAO_INFORMADO(NbsCompletoNaoInformadoException.class, "NBS completo n\u00e3o informado", "nbs-completo-nao-informado"),
    NCM_NAO_ENCONTRADO(NcmNaoEncontradaException.class, "NCM n\u00e3o encontrada", "ncm-nao-encontrada"),
    NCM_NAO_VINCULADA(NcmNaoVinculadaException.class, "NCM n\u00e3o vinculada", "ncm-nao-vinculada"),
    NBS_NAO_VINCULADA(NbsNaoVinculadaException.class, "NBS n\u00e3o vinculada", "nbs-nao-vinculada"),
    NBS_NAO_ENCONTRADO(NbsNaoEncontradaException.class, "NBS n\u00e3o encontrada", "nbs-nao-encontrada"),
    ITEM_DUPLICADO(ItemDuplicadoException.class, "Item duplicado", "item-duplicado"),
    MUNICIPIO_NAO_ENCONTRADO(MunicipioNaoEncontradoException.class, "Munic\u00edpio n\u00e3o encontrado", "municipio-nao-encontrado"),
    MUNICIPIO_NAO_PERTENCE_UF(MunicipioNaoPertencenteException.class, "Munic\u00edpio n\u00e3o pertencente \u00e0 UF", "municipio-nao-pertencente-uf"),
    SITUACAO_TRIBUTARIA_NAO_ENCONTRADA(SituacaoTributariaNaoEncontradaException.class, "Situa\u00e7\u00e3o tribut\u00e1ria n\u00e3o encontrada", "situacao-tributaria-nao-encontrada"),
    UF_NAO_ENCONTRADA(UfNaoEncontradaException.class, "UF n\u00e3o encontrada", "uf-nao-encontrada"),
    ERRO_XML(ErroXmlException.class, "Erro de valida\u00e7\u00e3o de XML", "erro-xml"),
    ERRO_FALTA_IMPLEMENTACAO(ErroFaltaImplementacaoException.class, "Classifica\u00e7\u00e3o tribut\u00e1ria em desenvolvimento", "erro-falta-implementacao"),
    ERRO_NEGOCIO(NegocioException.class, "Viola\u00e7\u00e3o de regra de neg\u00f3cio", "erro-negocio"),
    ERRO_SISTEMA(Exception.class, "Erro de sistema n\u00e3o previsto", "erro-de-sistema-nao-previsto");

    private final Class<? extends Exception> classeErro;
    private final String titulo;
    private final String path;

    private ProblemType(Class<? extends Exception> classeErro, String titulo, String path) {
        this.classeErro = classeErro;
        this.titulo = titulo;
        this.path = path;
    }

    public URI getURI() {
        return URI.create(String.format("%s/errors/%s", HttpUtils.getBaseURL(), this.path));
    }

    public static <E extends Exception> ProblemType from(@NonNull E e) {
        if (e == null) {
            throw new NullPointerException("e is marked non-null but is null");
        }
        Class<?> classeErro = e.getClass();
        return Stream.of(ProblemType.values()).filter(t -> t.getClasseErro().equals(classeErro)).findFirst().orElse(ERRO_SISTEMA);
    }

    @Generated
    public Class<? extends Exception> getClasseErro() {
        return this.classeErro;
    }

    @Generated
    public String getTitulo() {
        return this.titulo;
    }

    @Generated
    public String getPath() {
        return this.path;
    }
}

