/*
 * Decompiled with CFR 0.152.
 */
package br.gov.serpro.rtc.api.model.input;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.constraints.NotEmpty;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.Pattern;
import jakarta.validation.constraints.PositiveOrZero;
import jakarta.validation.constraints.Size;
import java.math.BigDecimal;
import lombok.Generated;

public final class ImpostoSeletivoInput {
    @NotNull
    @Pattern(regexp="\\d+", message="Informar somente d\u00edgitos")
    @Size(min=3, max=3)
    @Schema(name="cst", description="C\u00f3digo da situa\u00e7\u00e3o tribut\u00e1ria", example="000")
    private @NotNull @Pattern(regexp="\\d+", message="Informar somente d\u00edgitos") @Size(min=3, max=3) String cst;
    @NotNull
    @Pattern(regexp="\\d+", message="Informar somente d\u00edgitos")
    @Size(min=6, max=6)
    @Schema(name="cClassTrib", description="C\u00f3digo da classifica\u00e7\u00e3o tribut\u00e1ria", example="000000")
    @JsonProperty(value="cClassTrib")
    private @NotNull @Pattern(regexp="\\d+", message="Informar somente d\u00edgitos") @Size(min=6, max=6) String cClassTrib;
    @NotNull
    @PositiveOrZero
    @Schema(name="baseCalculo", description="Base de c\u00e1lculo do imposto", example="200.00")
    private BigDecimal baseCalculo;
    @NotNull
    @PositiveOrZero
    @Schema(name="quantidade", description="Quantidade", example="1")
    private BigDecimal quantidade;
    @NotEmpty
    @Schema(name="unidade", description="Unidade de medida", example="LT")
    private String unidade;
    @NotNull
    @PositiveOrZero
    @Schema(name="impostoInformado", description="Imposto Seletivo informado pelo contribuinte", example="12.00")
    private BigDecimal impostoInformado;

    @JsonIgnore
    public BigDecimal getValorImpostoSeletivoInformado() {
        return this.impostoInformado != null ? this.impostoInformado : BigDecimal.ZERO;
    }

    @Generated
    public String toString() {
        return "ImpostoSeletivoInput(cst=" + this.getCst() + ", cClassTrib=" + this.getCClassTrib() + ", baseCalculo=" + String.valueOf(this.getBaseCalculo()) + ", quantidade=" + String.valueOf(this.getQuantidade()) + ", unidade=" + this.getUnidade() + ", impostoInformado=" + String.valueOf(this.getImpostoInformado()) + ")";
    }

    @Generated
    public String getCst() {
        return this.cst;
    }

    @Generated
    public String getCClassTrib() {
        return this.cClassTrib;
    }

    @Generated
    public BigDecimal getBaseCalculo() {
        return this.baseCalculo;
    }

    @Generated
    public BigDecimal getQuantidade() {
        return this.quantidade;
    }

    @Generated
    public String getUnidade() {
        return this.unidade;
    }

    @Generated
    public BigDecimal getImpostoInformado() {
        return this.impostoInformado;
    }

    @Generated
    public void setCst(String cst) {
        this.cst = cst;
    }

    @JsonProperty(value="cClassTrib")
    @Generated
    public void setCClassTrib(String cClassTrib) {
        this.cClassTrib = cClassTrib;
    }

    @Generated
    public void setBaseCalculo(BigDecimal baseCalculo) {
        this.baseCalculo = baseCalculo;
    }

    @Generated
    public void setQuantidade(BigDecimal quantidade) {
        this.quantidade = quantidade;
    }

    @Generated
    public void setUnidade(String unidade) {
        this.unidade = unidade;
    }

    @Generated
    public void setImpostoInformado(BigDecimal impostoInformado) {
        this.impostoInformado = impostoInformado;
    }

    @Generated
    public ImpostoSeletivoInput() {
    }
}

