/*
 * Decompiled with CFR 0.152.
 */
package br.gov.serpro.rtc.api.model.input;

import br.gov.serpro.rtc.api.model.input.ItemOperacaoInput;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.Valid;
import jakarta.validation.constraints.Max;
import jakarta.validation.constraints.Min;
import jakarta.validation.constraints.NotEmpty;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.Size;
import java.time.OffsetDateTime;
import java.util.List;
import lombok.Generated;

public final class OperacaoInput {
    @NotNull
    @Schema(name="id", description="Identificador do ROC", example="6194602ea71cbf9431c236de4409d920")
    private String id;
    @NotNull
    @Schema(name="versao", description="Vers\u00e3o do ROC", example="0.0.1")
    private String versao;
    @NotNull
    @Schema(name="dataHoraEmissao", description="Data e hora de emiss\u00e3o do documento no formato UTC", example="2026-01-01T09:50:05-03:00")
    private OffsetDateTime dataHoraEmissao;
    @NotNull
    @Min(value=0L)
    @Max(value=9999999L)
    @Schema(name="municipio", description="C\u00f3digo do Munic\u00edpio (tabela IBGE)", example="4314902")
    private @NotNull @Min(value=0L) @Max(value=9999999L) Long municipio;
    @NotNull
    @Size(min=2, max=2)
    @Schema(name="uf", description="Sigla da UF", example="RS")
    private @NotNull @Size(min=2, max=2) String uf;
    @Valid
    @NotEmpty
    @Schema(name="itens", description="Itens da Opera\u00e7\u00e3o")
    private List<ItemOperacaoInput> itens;

    @Generated
    public String getId() {
        return this.id;
    }

    @Generated
    public String getVersao() {
        return this.versao;
    }

    @Generated
    public OffsetDateTime getDataHoraEmissao() {
        return this.dataHoraEmissao;
    }

    @Generated
    public Long getMunicipio() {
        return this.municipio;
    }

    @Generated
    public String getUf() {
        return this.uf;
    }

    @Generated
    public List<ItemOperacaoInput> getItens() {
        return this.itens;
    }

    @Generated
    public void setId(String id) {
        this.id = id;
    }

    @Generated
    public void setVersao(String versao) {
        this.versao = versao;
    }

    @Generated
    public void setDataHoraEmissao(OffsetDateTime dataHoraEmissao) {
        this.dataHoraEmissao = dataHoraEmissao;
    }

    @Generated
    public void setMunicipio(Long municipio) {
        this.municipio = municipio;
    }

    @Generated
    public void setUf(String uf) {
        this.uf = uf;
    }

    @Generated
    public void setItens(List<ItemOperacaoInput> itens) {
        this.itens = itens;
    }

    @Generated
    public OperacaoInput() {
    }
}

