/*
 * Decompiled with CFR 0.152.
 */
package br.gov.serpro.rtc.api.model.input.pedagio;

import br.gov.serpro.rtc.api.model.input.pedagio.TrechoPedagioInput;
import br.gov.serpro.rtc.core.util.StreamUtils;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.Valid;
import jakarta.validation.constraints.Max;
import jakarta.validation.constraints.Min;
import jakarta.validation.constraints.NotEmpty;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.Size;
import java.math.BigDecimal;
import java.time.OffsetDateTime;
import java.util.List;
import java.util.Objects;
import lombok.Generated;

public final class PedagioInput {
    @NotNull
    @Schema(name="dataHoraEmissao", description="Data e hora de emiss\u00e3o do documento no formato UTC", example="2027-01-01T09:50:05-03:00")
    private OffsetDateTime dataHoraEmissao;
    @NotNull
    @Min(value=0L)
    @Max(value=9999999L)
    @Schema(name="codigoMunicipioOrigem", description="C\u00f3digo do Munic\u00edpio (tabela IBGE)", example="4314902")
    private @NotNull @Min(value=0L) @Max(value=9999999L) Long codigoMunicipioOrigem;
    @NotNull
    @Size(min=2, max=2)
    @Schema(name="ufMunicipioOrigem", description="Sigla da UF", example="RS")
    private @NotNull @Size(min=2, max=2) String ufMunicipioOrigem;
    @NotNull
    @Size(min=3, max=3)
    @Schema(name="cst", description="C\u00f3digo de situa\u00e7\u00e3o tribut\u00e1ria", example="000")
    private @NotNull @Size(min=3, max=3) String cst;
    @NotNull
    @Size(min=6, max=6)
    @Schema(name="cClassTrib", description="C\u00f3digo de classifica\u00e7\u00e3o tribut\u00e1ria", example="000002")
    @JsonProperty(value="cClassTrib")
    private @NotNull @Size(min=6, max=6) String cClassTrib;
    @NotNull
    @Schema(name="baseCalculo", description="Base de c\u00e1lculo do imposto", example="200.00")
    private BigDecimal baseCalculo;
    @Valid
    @NotEmpty
    @Schema(name="trechos", description="Trechos do ped\u00e1gio")
    private List<TrechoPedagioInput> trechos;

    @JsonIgnore
    public BigDecimal getExtensaoTotal() {
        return StreamUtils.nullSafe((List)this.trechos).map(TrechoPedagioInput::getExtensao).filter(Objects::nonNull).reduce(BigDecimal.ZERO, BigDecimal::add);
    }

    @Generated
    public OffsetDateTime getDataHoraEmissao() {
        return this.dataHoraEmissao;
    }

    @Generated
    public Long getCodigoMunicipioOrigem() {
        return this.codigoMunicipioOrigem;
    }

    @Generated
    public String getUfMunicipioOrigem() {
        return this.ufMunicipioOrigem;
    }

    @Generated
    public String getCst() {
        return this.cst;
    }

    @Generated
    public String getCClassTrib() {
        return this.cClassTrib;
    }

    @Generated
    public BigDecimal getBaseCalculo() {
        return this.baseCalculo;
    }

    @Generated
    public List<TrechoPedagioInput> getTrechos() {
        return this.trechos;
    }

    @Generated
    public void setDataHoraEmissao(OffsetDateTime dataHoraEmissao) {
        this.dataHoraEmissao = dataHoraEmissao;
    }

    @Generated
    public void setCodigoMunicipioOrigem(Long codigoMunicipioOrigem) {
        this.codigoMunicipioOrigem = codigoMunicipioOrigem;
    }

    @Generated
    public void setUfMunicipioOrigem(String ufMunicipioOrigem) {
        this.ufMunicipioOrigem = ufMunicipioOrigem;
    }

    @Generated
    public void setCst(String cst) {
        this.cst = cst;
    }

    @JsonProperty(value="cClassTrib")
    @Generated
    public void setCClassTrib(String cClassTrib) {
        this.cClassTrib = cClassTrib;
    }

    @Generated
    public void setBaseCalculo(BigDecimal baseCalculo) {
        this.baseCalculo = baseCalculo;
    }

    @Generated
    public void setTrechos(List<TrechoPedagioInput> trechos) {
        this.trechos = trechos;
    }

    @Generated
    public PedagioInput() {
    }
}

