/*
 * Decompiled with CFR 0.152.
 */
package br.gov.serpro.rtc.api.model.output.pedagio;

import br.gov.serpro.rtc.api.model.output.pedagio.TrechoPedagioOutput;
import br.gov.serpro.rtc.api.model.output.pedagio.TributoPedagioOutput;
import br.gov.serpro.rtc.api.model.output.pedagio.TributoTotalPedagioOutput;
import com.fasterxml.jackson.annotation.JsonInclude;
import io.swagger.v3.oas.annotations.media.Schema;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.List;
import java.util.function.Function;
import lombok.Generated;

/*
 * Exception performing whole class analysis ignored.
 */
@JsonInclude(value=JsonInclude.Include.NON_NULL)
public final class TributoTotalPedagioOutput {
    @Schema(name="baseCalculo", description="Base de c\u00e1lculo do imposto", example="200.00")
    private final BigDecimal baseCalculo;
    @Schema(name="valorApurado", description="Valor de imposto apurado", example="0.75")
    private final BigDecimal valorApurado;
    @Schema(name="valorDevido", description="Valor de imposto devido", example="0.75")
    private final BigDecimal valorDevido;
    @Schema(name="valorTributo", description="Valor do tributo", example="0.75")
    private final BigDecimal valorTributo;
    @Schema(name="totalMontanteDesonerado", description="Total do montante desonerado", example="10.22")
    private final BigDecimal valorMontanteDesonerado;

    public static TributoTotalPedagioOutput totalizaCbs(List<TrechoPedagioOutput> trechosPedagio, BigDecimal totalBaseCalculo) {
        return TributoTotalPedagioOutput.getValorTotalIVA(trechosPedagio, (BigDecimal)totalBaseCalculo, (Function)TributoTotalPedagioOutput.functionCbs(), (Function)TributoTotalPedagioOutput.functionTributoCalculado());
    }

    public static TributoTotalPedagioOutput totalizaIbsEstadual(List<TrechoPedagioOutput> trechosPedagio, BigDecimal totalBaseCalculo) {
        return TributoTotalPedagioOutput.getValorTotalIVA(trechosPedagio, (BigDecimal)totalBaseCalculo, (Function)TributoTotalPedagioOutput.functionIbsEstadual(), (Function)TributoTotalPedagioOutput.functionTributoCalculado());
    }

    public static TributoTotalPedagioOutput totalizaIbsMunicipal(List<TrechoPedagioOutput> trechosPedagio, BigDecimal totalBaseCalculo) {
        return TributoTotalPedagioOutput.getValorTotalIVA(trechosPedagio, (BigDecimal)totalBaseCalculo, (Function)TributoTotalPedagioOutput.functionIbsMunicipal(), (Function)TributoTotalPedagioOutput.functionTributoCalculado());
    }

    private static TributoTotalPedagioOutput getValorTotalIVA(List<TrechoPedagioOutput> trechosPedagio, BigDecimal totalBaseCalculo, Function<? super TrechoPedagioOutput, TributoPedagioOutput> functionTributoATotalizar, Function<? super TributoPedagioOutput, BigDecimal> functionTributoCalculado) {
        BigDecimal totalTributo = TributoTotalPedagioOutput.totalizaIVA(trechosPedagio, functionTributoATotalizar, functionTributoCalculado).setScale(2, RoundingMode.HALF_UP);
        return TributoTotalPedagioOutput.builder().baseCalculo(totalBaseCalculo).valorApurado(totalTributo).valorTributo(totalTributo).valorDevido(totalTributo).build();
    }

    private static BigDecimal totalizaIVA(List<TrechoPedagioOutput> trechosPedagio, Function<? super TrechoPedagioOutput, TributoPedagioOutput> functionTributoATotalizar, Function<? super TributoPedagioOutput, BigDecimal> functionAtributoATotalizar) {
        return trechosPedagio.stream().map(functionTributoATotalizar).map(functionAtributoATotalizar).reduce(BigDecimal.ZERO, BigDecimal::add);
    }

    private static Function<? super TrechoPedagioOutput, TributoPedagioOutput> functionCbs() {
        return TrechoPedagioOutput::getCbs;
    }

    private static Function<? super TrechoPedagioOutput, TributoPedagioOutput> functionIbsEstadual() {
        return TrechoPedagioOutput::getIbsEstadual;
    }

    private static Function<? super TrechoPedagioOutput, TributoPedagioOutput> functionIbsMunicipal() {
        return TrechoPedagioOutput::getIbsMunicipal;
    }

    private static Function<? super TributoPedagioOutput, BigDecimal> functionTributoCalculado() {
        return TributoPedagioOutput::getTributoCalculado;
    }

    @Generated
    TributoTotalPedagioOutput(BigDecimal baseCalculo, BigDecimal valorApurado, BigDecimal valorDevido, BigDecimal valorTributo, BigDecimal valorMontanteDesonerado) {
        this.baseCalculo = baseCalculo;
        this.valorApurado = valorApurado;
        this.valorDevido = valorDevido;
        this.valorTributo = valorTributo;
        this.valorMontanteDesonerado = valorMontanteDesonerado;
    }

    @Generated
    public static TributoTotalPedagioOutputBuilder builder() {
        return new TributoTotalPedagioOutputBuilder();
    }

    @Generated
    public BigDecimal getBaseCalculo() {
        return this.baseCalculo;
    }

    @Generated
    public BigDecimal getValorApurado() {
        return this.valorApurado;
    }

    @Generated
    public BigDecimal getValorDevido() {
        return this.valorDevido;
    }

    @Generated
    public BigDecimal getValorTributo() {
        return this.valorTributo;
    }

    @Generated
    public BigDecimal getValorMontanteDesonerado() {
        return this.valorMontanteDesonerado;
    }
}

