/*
 * Decompiled with CFR 0.152.
 */
package br.gov.serpro.rtc.api.model.roc;

import br.gov.serpro.rtc.api.model.roc.CBS;
import br.gov.serpro.rtc.api.model.roc.CreditoPresumido;
import br.gov.serpro.rtc.api.model.roc.Objeto;
import br.gov.serpro.rtc.api.model.roc.reduce.CBSTotalAccumulator;
import br.gov.serpro.rtc.config.serializer.BigDecimalTDec1302Serializer;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import io.swagger.v3.oas.annotations.media.Schema;
import java.math.BigDecimal;
import java.util.List;
import java.util.function.Predicate;
import lombok.Generated;

/*
 * Exception performing whole class analysis ignored.
 */
@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class CBSTotal {
    @JsonSerialize(using=BigDecimalTDec1302Serializer.class)
    @Schema(description="Valor total do diferimento")
    @JsonProperty(value="vDif", index=0)
    private BigDecimal vDif = BigDecimal.ZERO;
    @JsonSerialize(using=BigDecimalTDec1302Serializer.class)
    @Schema(description="Valor total de devolu\u00e7\u00e3o de tributos")
    @JsonProperty(value="vDevTrib", index=1)
    private BigDecimal vDevTrib = BigDecimal.ZERO;
    @JsonSerialize(using=BigDecimalTDec1302Serializer.class)
    @Schema(description="Valor total da CBS")
    @JsonProperty(value="vCBS", index=2)
    private BigDecimal vCBS = BigDecimal.ZERO;
    @JsonSerialize(using=BigDecimalTDec1302Serializer.class)
    @Schema(description="Valor total do cr\u00e9dito presumido")
    @JsonProperty(value="vCredPres", index=3)
    private BigDecimal vCredPres = BigDecimal.ZERO;
    @JsonSerialize(using=BigDecimalTDec1302Serializer.class)
    @Schema(description="Valor total do cr\u00e9dito presumido em condi\u00e7\u00e3o suspensiva")
    @JsonProperty(value="vCredPresCondSus", index=4)
    private BigDecimal vCredPresCondSus = BigDecimal.ZERO;

    public static CBSTotal create(List<Objeto> detalhes) {
        if (detalhes != null && !detalhes.isEmpty() && CBSTotal.possuiCbs(detalhes)) {
            return detalhes.parallelStream().filter(CBSTotal.condicaoPossuiCbs()).map(d -> d.getGrupoIBSCBS()).map(g -> CBSTotalAccumulator.from((CBS)g.getGCBS(), (CreditoPresumido)g.getGCBSCredPres())).reduce(new CBSTotalAccumulator(), CBSTotalAccumulator::add, CBSTotalAccumulator::add).toCBSTotal();
        }
        return null;
    }

    private static boolean possuiCbs(List<Objeto> detalhes) {
        return detalhes.parallelStream().anyMatch(CBSTotal.condicaoPossuiCbs());
    }

    private static Predicate<? super Objeto> condicaoPossuiCbs() {
        return d -> d.possuiCbs() || d.possuiCreditoPresumidoCbs();
    }

    @Generated
    public String toString() {
        return "CBSTotal(vDif=" + String.valueOf(this.getVDif()) + ", vDevTrib=" + String.valueOf(this.getVDevTrib()) + ", vCBS=" + String.valueOf(this.getVCBS()) + ", vCredPres=" + String.valueOf(this.getVCredPres()) + ", vCredPresCondSus=" + String.valueOf(this.getVCredPresCondSus()) + ")";
    }

    @Generated
    public BigDecimal getVDif() {
        return this.vDif;
    }

    @Generated
    public BigDecimal getVDevTrib() {
        return this.vDevTrib;
    }

    @Generated
    public BigDecimal getVCBS() {
        return this.vCBS;
    }

    @Generated
    public BigDecimal getVCredPres() {
        return this.vCredPres;
    }

    @Generated
    public BigDecimal getVCredPresCondSus() {
        return this.vCredPresCondSus;
    }

    @JsonProperty(value="vDif", index=0)
    @Generated
    public void setVDif(BigDecimal vDif) {
        this.vDif = vDif;
    }

    @JsonProperty(value="vDevTrib", index=1)
    @Generated
    public void setVDevTrib(BigDecimal vDevTrib) {
        this.vDevTrib = vDevTrib;
    }

    @JsonProperty(value="vCBS", index=2)
    @Generated
    public void setVCBS(BigDecimal vCBS) {
        this.vCBS = vCBS;
    }

    @JsonProperty(value="vCredPres", index=3)
    @Generated
    public void setVCredPres(BigDecimal vCredPres) {
        this.vCredPres = vCredPres;
    }

    @JsonProperty(value="vCredPresCondSus", index=4)
    @Generated
    public void setVCredPresCondSus(BigDecimal vCredPresCondSus) {
        this.vCredPresCondSus = vCredPresCondSus;
    }
}

