/*
 * Decompiled with CFR 0.152.
 */
package br.gov.serpro.rtc.api.model.roc;

import br.gov.serpro.rtc.api.model.roc.CBS;
import br.gov.serpro.rtc.api.model.roc.CreditoPresumido;
import br.gov.serpro.rtc.api.model.roc.GrupoIBSCBS;
import br.gov.serpro.rtc.api.model.roc.IBSMun;
import br.gov.serpro.rtc.api.model.roc.IBSUF;
import br.gov.serpro.rtc.api.model.roc.TributacaoCompraGovernamental;
import br.gov.serpro.rtc.api.model.roc.TributacaoRegular;
import br.gov.serpro.rtc.config.serializer.BigDecimalTDec1302Serializer;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import io.swagger.v3.oas.annotations.media.Schema;
import java.math.BigDecimal;
import lombok.Generated;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class GrupoIBSCBS {
    @JsonSerialize(using=BigDecimalTDec1302Serializer.class)
    @Schema(description="Base de c\u00e1lculo do IBS e CBS")
    @JsonProperty(value="vBC", index=0)
    private BigDecimal vBC;
    @Schema(description="Grupo de Informa\u00e7\u00f5es do IBS para a UF")
    @JsonProperty(value="gIBSUF", index=1)
    private IBSUF gIBSUF;
    @Schema(description="Grupo de Informa\u00e7\u00f5es do IBS para o munic\u00edpio")
    @JsonProperty(value="gIBSMun", index=2)
    private IBSMun gIBSMun;
    @Schema(description="Grupo de Informa\u00e7\u00f5es da CBS")
    @JsonProperty(value="gCBS", index=3)
    private CBS gCBS;
    @Schema(description="Grupo de Informa\u00e7\u00f5es da Tributa\u00e7\u00e3o Regular")
    @JsonProperty(value="gTribRegular", index=4)
    private TributacaoRegular gTribRegular;
    @Schema(description="Grupo de Informa\u00e7\u00f5es do Cr\u00e9dito Presumido referente ao IBS")
    @JsonProperty(value="gIBSCredPres", index=5)
    private CreditoPresumido gIBSCredPres;
    @Schema(description="Grupo de Informa\u00e7\u00f5es do Cr\u00e9dito Presumido referente a CBS")
    @JsonProperty(value="gCBSCredPres", index=6)
    private CreditoPresumido gCBSCredPres;
    @Schema(description="Grupo de informa\u00e7\u00f5es da composi\u00e7\u00e3o do valor do IBS e da CBS em compras governamentais")
    @JsonProperty(value="gTribCompraGov", index=7)
    private TributacaoCompraGovernamental gTribCompraGov;

    @JsonIgnore
    public boolean possuiBaseCalculoIBSCBS() {
        return this.vBC != null;
    }

    @JsonIgnore
    public BigDecimal getValorBaseCalculoIBSCBS() {
        return this.possuiBaseCalculoIBSCBS() ? this.vBC : BigDecimal.ZERO;
    }

    @JsonIgnore
    public boolean possuiCbs() {
        return this.gCBS != null;
    }

    @JsonIgnore
    public boolean possuiCreditoPresumidoCbs() {
        return this.gCBSCredPres != null;
    }

    @JsonIgnore
    public boolean possuiCredPresIbs() {
        return this.gIBSCredPres != null && this.gIBSCredPres.getVCredPres() != null;
    }

    @JsonIgnore
    public BigDecimal getVCredPresIbs() {
        return this.possuiCredPresIbs() ? this.gIBSCredPres.getVCredPres() : BigDecimal.ZERO;
    }

    @JsonIgnore
    public boolean possuiCredPresCondSusIbs() {
        return this.gIBSCredPres != null && this.gIBSCredPres.getVCredPresCondSus() != null;
    }

    @JsonIgnore
    public BigDecimal getVCredPresCondSusIbs() {
        return this.possuiCredPresCondSusIbs() ? this.gIBSCredPres.getVCredPresCondSus() : BigDecimal.ZERO;
    }

    @JsonIgnore
    public boolean possuiIBSUF() {
        return this.gIBSUF != null;
    }

    @JsonIgnore
    public boolean possuiIBSMun() {
        return this.gIBSMun != null;
    }

    @JsonIgnore
    public boolean possuiTributacaoRegular() {
        return this.gTribRegular != null;
    }

    @JsonIgnore
    public TributacaoRegular getTributacaoRegular() {
        return this.gTribRegular;
    }

    @Generated
    GrupoIBSCBS(BigDecimal vBC, IBSUF gIBSUF, IBSMun gIBSMun, CBS gCBS, TributacaoRegular gTribRegular, CreditoPresumido gIBSCredPres, CreditoPresumido gCBSCredPres, TributacaoCompraGovernamental gTribCompraGov) {
        this.vBC = vBC;
        this.gIBSUF = gIBSUF;
        this.gIBSMun = gIBSMun;
        this.gCBS = gCBS;
        this.gTribRegular = gTribRegular;
        this.gIBSCredPres = gIBSCredPres;
        this.gCBSCredPres = gCBSCredPres;
        this.gTribCompraGov = gTribCompraGov;
    }

    @Generated
    public static GrupoIBSCBSBuilder builder() {
        return new GrupoIBSCBSBuilder();
    }

    @Generated
    public String toString() {
        return "GrupoIBSCBS(vBC=" + String.valueOf(this.getVBC()) + ", gIBSUF=" + String.valueOf(this.getGIBSUF()) + ", gIBSMun=" + String.valueOf(this.getGIBSMun()) + ", gCBS=" + String.valueOf(this.getGCBS()) + ", gTribRegular=" + String.valueOf(this.getGTribRegular()) + ", gIBSCredPres=" + String.valueOf(this.getGIBSCredPres()) + ", gCBSCredPres=" + String.valueOf(this.getGCBSCredPres()) + ", gTribCompraGov=" + String.valueOf(this.getGTribCompraGov()) + ")";
    }

    @Generated
    public BigDecimal getVBC() {
        return this.vBC;
    }

    @Generated
    public IBSUF getGIBSUF() {
        return this.gIBSUF;
    }

    @Generated
    public IBSMun getGIBSMun() {
        return this.gIBSMun;
    }

    @Generated
    public CBS getGCBS() {
        return this.gCBS;
    }

    @Generated
    public TributacaoRegular getGTribRegular() {
        return this.gTribRegular;
    }

    @Generated
    public CreditoPresumido getGIBSCredPres() {
        return this.gIBSCredPres;
    }

    @Generated
    public CreditoPresumido getGCBSCredPres() {
        return this.gCBSCredPres;
    }

    @Generated
    public TributacaoCompraGovernamental getGTribCompraGov() {
        return this.gTribCompraGov;
    }

    @JsonProperty(value="vBC", index=0)
    @Generated
    public void setVBC(BigDecimal vBC) {
        this.vBC = vBC;
    }

    @JsonProperty(value="gIBSUF", index=1)
    @Generated
    public void setGIBSUF(IBSUF gIBSUF) {
        this.gIBSUF = gIBSUF;
    }

    @JsonProperty(value="gIBSMun", index=2)
    @Generated
    public void setGIBSMun(IBSMun gIBSMun) {
        this.gIBSMun = gIBSMun;
    }

    @JsonProperty(value="gCBS", index=3)
    @Generated
    public void setGCBS(CBS gCBS) {
        this.gCBS = gCBS;
    }

    @JsonProperty(value="gTribRegular", index=4)
    @Generated
    public void setGTribRegular(TributacaoRegular gTribRegular) {
        this.gTribRegular = gTribRegular;
    }

    @JsonProperty(value="gIBSCredPres", index=5)
    @Generated
    public void setGIBSCredPres(CreditoPresumido gIBSCredPres) {
        this.gIBSCredPres = gIBSCredPres;
    }

    @JsonProperty(value="gCBSCredPres", index=6)
    @Generated
    public void setGCBSCredPres(CreditoPresumido gCBSCredPres) {
        this.gCBSCredPres = gCBSCredPres;
    }

    @JsonProperty(value="gTribCompraGov", index=7)
    @Generated
    public void setGTribCompraGov(TributacaoCompraGovernamental gTribCompraGov) {
        this.gTribCompraGov = gTribCompraGov;
    }
}

