/*
 * Decompiled with CFR 0.152.
 */
package br.gov.serpro.rtc.api.model.roc;

import br.gov.serpro.rtc.api.model.roc.CBSTotal;
import br.gov.serpro.rtc.api.model.roc.IBSTotal;
import br.gov.serpro.rtc.api.model.roc.MonofasiaTotal;
import br.gov.serpro.rtc.api.model.roc.Objeto;
import br.gov.serpro.rtc.config.serializer.BigDecimalTDec1302Serializer;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import io.swagger.v3.oas.annotations.media.Schema;
import java.math.BigDecimal;
import java.util.List;
import lombok.Generated;

/*
 * Exception performing whole class analysis ignored.
 */
@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class IBSCBSTotal {
    @JsonSerialize(using=BigDecimalTDec1302Serializer.class)
    @Schema(description="Valor total da BC do IBS e da CBS")
    @JsonProperty(value="vBCIBSCBS", index=0)
    private BigDecimal vBCIBSCBS;
    @Schema(description="Grupo total do IBS")
    @JsonProperty(value="gIBS", index=1)
    private IBSTotal gIBS;
    @Schema(description="Grupo total da CBS")
    @JsonProperty(value="gCBS", index=2)
    private CBSTotal gCBS;
    @Schema(description="Grupo total da Monofasia")
    @JsonProperty(value="gMono", index=3)
    private MonofasiaTotal gMono;

    public static IBSCBSTotal create(List<Objeto> detalhes) {
        if (detalhes != null && !detalhes.isEmpty()) {
            IBSCBSTotal ibsCbsTotal = new IBSCBSTotal();
            ibsCbsTotal.setVBCIBSCBS(IBSCBSTotal.getBaseCalculoIbsCbsTotal(detalhes));
            ibsCbsTotal.setGIBS(IBSTotal.create(detalhes));
            ibsCbsTotal.setGCBS(CBSTotal.create(detalhes));
            ibsCbsTotal.setGMono(MonofasiaTotal.create(detalhes));
            return ibsCbsTotal;
        }
        return null;
    }

    private static BigDecimal getBaseCalculoIbsCbsTotal(List<Objeto> detalhes) {
        return detalhes.parallelStream().filter(d -> d.possuiBaseCalculoIBSCBS()).map(d -> d.getValorBaseCalculoIBSCBS()).reduce(BigDecimal.ZERO, BigDecimal::add);
    }

    @Generated
    public String toString() {
        return "IBSCBSTotal(vBCIBSCBS=" + String.valueOf(this.getVBCIBSCBS()) + ", gIBS=" + String.valueOf(this.getGIBS()) + ", gCBS=" + String.valueOf(this.getGCBS()) + ", gMono=" + String.valueOf(this.getGMono()) + ")";
    }

    @Generated
    public BigDecimal getVBCIBSCBS() {
        return this.vBCIBSCBS;
    }

    @Generated
    public IBSTotal getGIBS() {
        return this.gIBS;
    }

    @Generated
    public CBSTotal getGCBS() {
        return this.gCBS;
    }

    @Generated
    public MonofasiaTotal getGMono() {
        return this.gMono;
    }

    @JsonProperty(value="vBCIBSCBS", index=0)
    @Generated
    public void setVBCIBSCBS(BigDecimal vBCIBSCBS) {
        this.vBCIBSCBS = vBCIBSCBS;
    }

    @JsonProperty(value="gIBS", index=1)
    @Generated
    public void setGIBS(IBSTotal gIBS) {
        this.gIBS = gIBS;
    }

    @JsonProperty(value="gCBS", index=2)
    @Generated
    public void setGCBS(CBSTotal gCBS) {
        this.gCBS = gCBS;
    }

    @JsonProperty(value="gMono", index=3)
    @Generated
    public void setGMono(MonofasiaTotal gMono) {
        this.gMono = gMono;
    }
}

