/*
 * Decompiled with CFR 0.152.
 */
package br.gov.serpro.rtc.api.model.roc;

import br.gov.serpro.rtc.api.model.roc.IBSMun;
import br.gov.serpro.rtc.api.model.roc.Objeto;
import br.gov.serpro.rtc.api.model.roc.reduce.IBSMunTotalAccumulator;
import br.gov.serpro.rtc.config.serializer.BigDecimalTDec1302Serializer;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import io.swagger.v3.oas.annotations.media.Schema;
import java.math.BigDecimal;
import java.util.List;
import java.util.function.Predicate;
import lombok.Generated;

/*
 * Exception performing whole class analysis ignored.
 */
@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class IBSMunTotal {
    @JsonSerialize(using=BigDecimalTDec1302Serializer.class)
    @Schema(description="Valor total do diferimento")
    @JsonProperty(value="vDif", index=0)
    private BigDecimal vDif = BigDecimal.ZERO;
    @JsonSerialize(using=BigDecimalTDec1302Serializer.class)
    @Schema(description="Valor total de devolu\u00e7\u00e3o de tributos")
    @JsonProperty(value="vDevTrib", index=1)
    private BigDecimal vDevTrib = BigDecimal.ZERO;
    @JsonSerialize(using=BigDecimalTDec1302Serializer.class)
    @Schema(description="Valor total do IBS do Munic\u00edpio")
    @JsonProperty(value="vIBSMun", index=2)
    private BigDecimal vIBSMun = BigDecimal.ZERO;

    public static IBSMunTotal create(List<Objeto> detalhes) {
        if (detalhes != null && !detalhes.isEmpty() && IBSMunTotal.possuiIbsMunicipal(detalhes)) {
            return detalhes.parallelStream().filter(IBSMunTotal.condicaoPossuiIbsMunicipal()).map(d -> IBSMunTotalAccumulator.from((IBSMun)d.getGIBSMun())).reduce(new IBSMunTotalAccumulator(), IBSMunTotalAccumulator::add, IBSMunTotalAccumulator::add).toIBSMunTotal();
        }
        return null;
    }

    private static boolean possuiIbsMunicipal(List<Objeto> detalhes) {
        return detalhes.parallelStream().anyMatch(IBSMunTotal.condicaoPossuiIbsMunicipal());
    }

    private static Predicate<? super Objeto> condicaoPossuiIbsMunicipal() {
        return d -> d.possuiIBSMun();
    }

    @Generated
    public String toString() {
        return "IBSMunTotal(vDif=" + String.valueOf(this.getVDif()) + ", vDevTrib=" + String.valueOf(this.getVDevTrib()) + ", vIBSMun=" + String.valueOf(this.getVIBSMun()) + ")";
    }

    @Generated
    public BigDecimal getVDif() {
        return this.vDif;
    }

    @Generated
    public BigDecimal getVDevTrib() {
        return this.vDevTrib;
    }

    @Generated
    public BigDecimal getVIBSMun() {
        return this.vIBSMun;
    }

    @JsonProperty(value="vDif", index=0)
    @Generated
    public void setVDif(BigDecimal vDif) {
        this.vDif = vDif;
    }

    @JsonProperty(value="vDevTrib", index=1)
    @Generated
    public void setVDevTrib(BigDecimal vDevTrib) {
        this.vDevTrib = vDevTrib;
    }

    @JsonProperty(value="vIBSMun", index=2)
    @Generated
    public void setVIBSMun(BigDecimal vIBSMun) {
        this.vIBSMun = vIBSMun;
    }
}

