/*
 * Decompiled with CFR 0.152.
 */
package br.gov.serpro.rtc.api.model.roc;

import br.gov.serpro.rtc.api.model.roc.IBSMunTotal;
import br.gov.serpro.rtc.api.model.roc.IBSUFTotal;
import br.gov.serpro.rtc.api.model.roc.Objeto;
import br.gov.serpro.rtc.config.serializer.BigDecimalTDec1302Serializer;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import io.swagger.v3.oas.annotations.media.Schema;
import java.math.BigDecimal;
import java.util.List;
import java.util.function.Predicate;
import lombok.Generated;

/*
 * Exception performing whole class analysis ignored.
 */
@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class IBSTotal {
    @Schema(description="Grupo total do IBS da UF")
    @JsonProperty(value="gIBSUF", index=0)
    private IBSUFTotal gIBSUF;
    @Schema(description="Grupo total do IBS do Munic\u00edpio")
    @JsonProperty(value="gIBSMun", index=1)
    private IBSMunTotal gIBSMun;
    @JsonSerialize(using=BigDecimalTDec1302Serializer.class)
    @Schema(description="Valor total do IBS")
    @JsonProperty(value="vIBS", index=2)
    private BigDecimal vIBS;
    @JsonSerialize(using=BigDecimalTDec1302Serializer.class)
    @Schema(description="Valor total do cr\u00e9dito presumido")
    @JsonProperty(value="vCredPres", index=3)
    private BigDecimal vCredPres;
    @JsonSerialize(using=BigDecimalTDec1302Serializer.class)
    @Schema(description="Valor total do cr\u00e9dito presumido em condi\u00e7\u00e3o suspensiva")
    @JsonProperty(value="vCredPresCondSus", index=4)
    private BigDecimal vCredPresCondSus;

    public static IBSTotal create(List<Objeto> detalhes) {
        if (detalhes != null && !detalhes.isEmpty()) {
            IBSTotal ibsTotal = new IBSTotal();
            IBSUFTotal gIBSUF = IBSUFTotal.create(detalhes);
            IBSMunTotal gIBSMun = IBSMunTotal.create(detalhes);
            ibsTotal.setGIBSUF(gIBSUF);
            ibsTotal.setGIBSMun(gIBSMun);
            ibsTotal.setVIBS(IBSTotal.getValorIbsTotal((IBSUFTotal)gIBSUF, (IBSMunTotal)gIBSMun));
            ibsTotal.setVCredPres(IBSTotal.getValorCreditoPresumidoTotal(detalhes));
            ibsTotal.setVCredPresCondSus(IBSTotal.getValorCreditoPresumidoCondSusTotal(detalhes));
            return ibsTotal;
        }
        return null;
    }

    private static BigDecimal getValorIbsTotal(IBSUFTotal ibsUFTotal, IBSMunTotal ibsMunTotal) {
        BigDecimal vIBSUF = ibsUFTotal != null ? ibsUFTotal.getVIBSUF() : BigDecimal.ZERO;
        BigDecimal vIBSMun = ibsMunTotal != null ? ibsMunTotal.getVIBSMun() : BigDecimal.ZERO;
        return vIBSUF.add(vIBSMun);
    }

    private static BigDecimal getValorCreditoPresumidoTotal(List<Objeto> detalhes) {
        Predicate condicao = IBSTotal.condicaoPossuiCreditoPresumido();
        if (IBSTotal.possuiCondicao(detalhes, (Predicate)condicao)) {
            return detalhes.parallelStream().filter(condicao).map(d -> d.getVCredPresIbs()).reduce(BigDecimal.ZERO, BigDecimal::add);
        }
        return BigDecimal.ZERO;
    }

    private static BigDecimal getValorCreditoPresumidoCondSusTotal(List<Objeto> detalhes) {
        Predicate condicao = IBSTotal.condicaoPossuiCreditoPresumidoCondSus();
        if (IBSTotal.possuiCondicao(detalhes, (Predicate)condicao)) {
            return detalhes.parallelStream().filter(condicao).map(d -> d.getVCredPresCondSusIbs()).reduce(BigDecimal.ZERO, BigDecimal::add);
        }
        return BigDecimal.ZERO;
    }

    private static boolean possuiCondicao(List<Objeto> detalhes, Predicate<? super Objeto> condicao) {
        return detalhes.parallelStream().anyMatch(condicao);
    }

    private static Predicate<? super Objeto> condicaoPossuiCreditoPresumido() {
        return d -> d.possuiCredPresIbs();
    }

    private static Predicate<? super Objeto> condicaoPossuiCreditoPresumidoCondSus() {
        return d -> d.possuiCredPresCondSusIbs();
    }

    @Generated
    public String toString() {
        return "IBSTotal(gIBSUF=" + String.valueOf(this.getGIBSUF()) + ", gIBSMun=" + String.valueOf(this.getGIBSMun()) + ", vIBS=" + String.valueOf(this.getVIBS()) + ", vCredPres=" + String.valueOf(this.getVCredPres()) + ", vCredPresCondSus=" + String.valueOf(this.getVCredPresCondSus()) + ")";
    }

    @Generated
    public IBSUFTotal getGIBSUF() {
        return this.gIBSUF;
    }

    @Generated
    public IBSMunTotal getGIBSMun() {
        return this.gIBSMun;
    }

    @Generated
    public BigDecimal getVIBS() {
        return this.vIBS;
    }

    @Generated
    public BigDecimal getVCredPres() {
        return this.vCredPres;
    }

    @Generated
    public BigDecimal getVCredPresCondSus() {
        return this.vCredPresCondSus;
    }

    @JsonProperty(value="gIBSUF", index=0)
    @Generated
    public void setGIBSUF(IBSUFTotal gIBSUF) {
        this.gIBSUF = gIBSUF;
    }

    @JsonProperty(value="gIBSMun", index=1)
    @Generated
    public void setGIBSMun(IBSMunTotal gIBSMun) {
        this.gIBSMun = gIBSMun;
    }

    @JsonProperty(value="vIBS", index=2)
    @Generated
    public void setVIBS(BigDecimal vIBS) {
        this.vIBS = vIBS;
    }

    @JsonProperty(value="vCredPres", index=3)
    @Generated
    public void setVCredPres(BigDecimal vCredPres) {
        this.vCredPres = vCredPres;
    }

    @JsonProperty(value="vCredPresCondSus", index=4)
    @Generated
    public void setVCredPresCondSus(BigDecimal vCredPresCondSus) {
        this.vCredPresCondSus = vCredPresCondSus;
    }
}

