/*
 * Decompiled with CFR 0.152.
 */
package br.gov.serpro.rtc.api.model.roc;

import br.gov.serpro.rtc.api.model.roc.IBSUF;
import br.gov.serpro.rtc.api.model.roc.Objeto;
import br.gov.serpro.rtc.api.model.roc.reduce.IBSUFTotalAccumulator;
import br.gov.serpro.rtc.config.serializer.BigDecimalTDec1302Serializer;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import io.swagger.v3.oas.annotations.media.Schema;
import java.math.BigDecimal;
import java.util.List;
import java.util.function.Predicate;
import lombok.Generated;

/*
 * Exception performing whole class analysis ignored.
 */
@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class IBSUFTotal {
    @JsonSerialize(using=BigDecimalTDec1302Serializer.class)
    @Schema(description="Valor total do diferimento")
    @JsonProperty(value="vDif", index=0)
    private BigDecimal vDif = BigDecimal.ZERO;
    @JsonSerialize(using=BigDecimalTDec1302Serializer.class)
    @Schema(description="Valor total de devolu\u00e7\u00e3o de tributos")
    @JsonProperty(value="vDevTrib", index=1)
    private BigDecimal vDevTrib = BigDecimal.ZERO;
    @JsonSerialize(using=BigDecimalTDec1302Serializer.class)
    @Schema(description="Valor total do IBS da UF")
    @JsonProperty(value="vIBSUF", index=2)
    private BigDecimal vIBSUF = BigDecimal.ZERO;

    public static IBSUFTotal create(List<Objeto> detalhes) {
        if (detalhes != null && !detalhes.isEmpty() && IBSUFTotal.possuiIbsUF(detalhes)) {
            return detalhes.parallelStream().filter(IBSUFTotal.condicaoPossuiIbsUF()).map(d -> IBSUFTotalAccumulator.from((IBSUF)d.getGIBSUF())).reduce(new IBSUFTotalAccumulator(), IBSUFTotalAccumulator::add, IBSUFTotalAccumulator::add).toIBSUFTotal();
        }
        return null;
    }

    private static boolean possuiIbsUF(List<Objeto> detalhes) {
        return detalhes.parallelStream().anyMatch(IBSUFTotal.condicaoPossuiIbsUF());
    }

    private static Predicate<? super Objeto> condicaoPossuiIbsUF() {
        return d -> d.possuiIBSUF();
    }

    @Generated
    public String toString() {
        return "IBSUFTotal(vDif=" + String.valueOf(this.getVDif()) + ", vDevTrib=" + String.valueOf(this.getVDevTrib()) + ", vIBSUF=" + String.valueOf(this.getVIBSUF()) + ")";
    }

    @Generated
    public BigDecimal getVDif() {
        return this.vDif;
    }

    @Generated
    public BigDecimal getVDevTrib() {
        return this.vDevTrib;
    }

    @Generated
    public BigDecimal getVIBSUF() {
        return this.vIBSUF;
    }

    @JsonProperty(value="vDif", index=0)
    @Generated
    public void setVDif(BigDecimal vDif) {
        this.vDif = vDif;
    }

    @JsonProperty(value="vDevTrib", index=1)
    @Generated
    public void setVDevTrib(BigDecimal vDevTrib) {
        this.vDevTrib = vDevTrib;
    }

    @JsonProperty(value="vIBSUF", index=2)
    @Generated
    public void setVIBSUF(BigDecimal vIBSUF) {
        this.vIBSUF = vIBSUF;
    }
}

