/*
 * Decompiled with CFR 0.152.
 */
package br.gov.serpro.rtc.api.model.roc;

import br.gov.serpro.rtc.api.model.roc.Objeto;
import br.gov.serpro.rtc.config.serializer.BigDecimalTDec1302Serializer;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import io.swagger.v3.oas.annotations.media.Schema;
import java.math.BigDecimal;
import java.util.List;
import java.util.function.Predicate;
import lombok.Generated;

/*
 * Exception performing whole class analysis ignored.
 */
@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class ImpostoSeletivoTotal {
    @JsonSerialize(using=BigDecimalTDec1302Serializer.class)
    @Schema(description="Total do imposto seletivo")
    @JsonProperty(value="vIS", index=0)
    private BigDecimal vIS = BigDecimal.ZERO;

    public static ImpostoSeletivoTotal create(List<Objeto> detalhes) {
        if (detalhes != null && !detalhes.isEmpty() && ImpostoSeletivoTotal.possuiImpostoSeletivo(detalhes)) {
            ImpostoSeletivoTotal isTotal = new ImpostoSeletivoTotal();
            isTotal.setVIS(ImpostoSeletivoTotal.getValorTotalIS(detalhes));
            return isTotal;
        }
        return null;
    }

    private static boolean possuiImpostoSeletivo(List<Objeto> detalhes) {
        return detalhes.parallelStream().anyMatch(ImpostoSeletivoTotal.condicaoPossuiIS());
    }

    private static BigDecimal getValorTotalIS(List<Objeto> detalhes) {
        return detalhes.parallelStream().filter(ImpostoSeletivoTotal.condicaoPossuiIS()).map(d -> d.getValorImpostoSeletivo()).reduce(BigDecimal.ZERO, BigDecimal::add);
    }

    private static Predicate<? super Objeto> condicaoPossuiIS() {
        return d -> d.possuiImpostoSeletivo();
    }

    @Generated
    public String toString() {
        return "ImpostoSeletivoTotal(vIS=" + String.valueOf(this.getVIS()) + ")";
    }

    @Generated
    public BigDecimal getVIS() {
        return this.vIS;
    }

    @JsonProperty(value="vIS", index=0)
    @Generated
    public void setVIS(BigDecimal vIS) {
        this.vIS = vIS;
    }
}

