/*
 * Decompiled with CFR 0.152.
 */
package br.gov.serpro.rtc.api.model.roc;

import br.gov.serpro.rtc.api.model.roc.Monofasia;
import br.gov.serpro.rtc.api.model.roc.Objeto;
import br.gov.serpro.rtc.api.model.roc.reduce.MonofasiaTotalAccumulator;
import br.gov.serpro.rtc.config.serializer.BigDecimalTDec1302Serializer;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import io.swagger.v3.oas.annotations.media.Schema;
import java.math.BigDecimal;
import java.util.List;
import java.util.function.Predicate;
import lombok.Generated;

/*
 * Exception performing whole class analysis ignored.
 */
@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class MonofasiaTotal {
    @JsonSerialize(using=BigDecimalTDec1302Serializer.class)
    @Schema(description="Total do IBS monof\u00e1sico")
    @JsonProperty(value="vIBSMono", index=0)
    private BigDecimal vIBSMono = BigDecimal.ZERO;
    @JsonSerialize(using=BigDecimalTDec1302Serializer.class)
    @Schema(description="Total da CBS monof\u00e1sica")
    @JsonProperty(value="vCBSMono", index=1)
    private BigDecimal vCBSMono = BigDecimal.ZERO;
    @JsonSerialize(using=BigDecimalTDec1302Serializer.class)
    @Schema(description="Total do IBS monof\u00e1sico sujeito a reten\u00e7\u00e3o")
    @JsonProperty(value="vIBSMonoReten", index=2)
    private BigDecimal vIBSMonoReten = BigDecimal.ZERO;
    @JsonSerialize(using=BigDecimalTDec1302Serializer.class)
    @Schema(description="Total da CBS monof\u00e1sica sujeita a reten\u00e7\u00e3o")
    @JsonProperty(value="vCBSMonoReten", index=3)
    private BigDecimal vCBSMonoReten = BigDecimal.ZERO;
    @JsonSerialize(using=BigDecimalTDec1302Serializer.class)
    @Schema(description="Total do IBS monof\u00e1sico retido anteriormente")
    @JsonProperty(value="vIBSMonoRet", index=4)
    private BigDecimal vIBSMonoRet = BigDecimal.ZERO;
    @JsonSerialize(using=BigDecimalTDec1302Serializer.class)
    @Schema(description="Total da CBS monof\u00e1sica retida anteriormente")
    @JsonProperty(value="vCBSMonoRet", index=5)
    private BigDecimal vCBSMonoRet = BigDecimal.ZERO;

    public static MonofasiaTotal create(List<Objeto> detalhes) {
        if (detalhes != null && !detalhes.isEmpty() && MonofasiaTotal.possuiMonofasia(detalhes)) {
            return detalhes.parallelStream().filter(MonofasiaTotal.condicaoPossuiMonofasia()).map(d -> MonofasiaTotalAccumulator.from((Monofasia)d.getGIBSCBSMono())).reduce(new MonofasiaTotalAccumulator(), MonofasiaTotalAccumulator::add, MonofasiaTotalAccumulator::add).toMonofasiaTotal();
        }
        return null;
    }

    private static boolean possuiMonofasia(List<Objeto> detalhes) {
        return detalhes.parallelStream().anyMatch(MonofasiaTotal.condicaoPossuiMonofasia());
    }

    private static Predicate<? super Objeto> condicaoPossuiMonofasia() {
        return Objeto::possuiMonofasia;
    }

    @Generated
    public String toString() {
        return "MonofasiaTotal(vIBSMono=" + String.valueOf(this.getVIBSMono()) + ", vCBSMono=" + String.valueOf(this.getVCBSMono()) + ", vIBSMonoReten=" + String.valueOf(this.getVIBSMonoReten()) + ", vCBSMonoReten=" + String.valueOf(this.getVCBSMonoReten()) + ", vIBSMonoRet=" + String.valueOf(this.getVIBSMonoRet()) + ", vCBSMonoRet=" + String.valueOf(this.getVCBSMonoRet()) + ")";
    }

    @Generated
    public BigDecimal getVIBSMono() {
        return this.vIBSMono;
    }

    @Generated
    public BigDecimal getVCBSMono() {
        return this.vCBSMono;
    }

    @Generated
    public BigDecimal getVIBSMonoReten() {
        return this.vIBSMonoReten;
    }

    @Generated
    public BigDecimal getVCBSMonoReten() {
        return this.vCBSMonoReten;
    }

    @Generated
    public BigDecimal getVIBSMonoRet() {
        return this.vIBSMonoRet;
    }

    @Generated
    public BigDecimal getVCBSMonoRet() {
        return this.vCBSMonoRet;
    }

    @JsonProperty(value="vIBSMono", index=0)
    @Generated
    public void setVIBSMono(BigDecimal vIBSMono) {
        this.vIBSMono = vIBSMono;
    }

    @JsonProperty(value="vCBSMono", index=1)
    @Generated
    public void setVCBSMono(BigDecimal vCBSMono) {
        this.vCBSMono = vCBSMono;
    }

    @JsonProperty(value="vIBSMonoReten", index=2)
    @Generated
    public void setVIBSMonoReten(BigDecimal vIBSMonoReten) {
        this.vIBSMonoReten = vIBSMonoReten;
    }

    @JsonProperty(value="vCBSMonoReten", index=3)
    @Generated
    public void setVCBSMonoReten(BigDecimal vCBSMonoReten) {
        this.vCBSMonoReten = vCBSMonoReten;
    }

    @JsonProperty(value="vIBSMonoRet", index=4)
    @Generated
    public void setVIBSMonoRet(BigDecimal vIBSMonoRet) {
        this.vIBSMonoRet = vIBSMonoRet;
    }

    @JsonProperty(value="vCBSMonoRet", index=5)
    @Generated
    public void setVCBSMonoRet(BigDecimal vCBSMonoRet) {
        this.vCBSMonoRet = vCBSMonoRet;
    }
}

