/*
 * Decompiled with CFR 0.152.
 */
package br.gov.serpro.rtc.api.model.roc.reduce;

import br.gov.serpro.rtc.api.model.roc.CBS;
import br.gov.serpro.rtc.api.model.roc.CBSTotal;
import br.gov.serpro.rtc.api.model.roc.CreditoPresumido;
import java.math.BigDecimal;
import java.util.Objects;

public class CBSTotalAccumulator {
    private final BigDecimal vDif;
    private final BigDecimal vDevTrib;
    private final BigDecimal vCBS;
    private final BigDecimal vCredPres;
    private final BigDecimal vCredPresCondSus;

    public CBSTotalAccumulator() {
        this(BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO);
    }

    public CBSTotalAccumulator(BigDecimal vDif, BigDecimal vDevTrib, BigDecimal vCBS, BigDecimal vCredPres, BigDecimal vCredPresCondSus) {
        this.vDif = Objects.requireNonNullElse(vDif, BigDecimal.ZERO);
        this.vDevTrib = Objects.requireNonNullElse(vDevTrib, BigDecimal.ZERO);
        this.vCBS = Objects.requireNonNullElse(vCBS, BigDecimal.ZERO);
        this.vCredPres = Objects.requireNonNullElse(vCredPres, BigDecimal.ZERO);
        this.vCredPresCondSus = Objects.requireNonNullElse(vCredPresCondSus, BigDecimal.ZERO);
    }

    public static CBSTotalAccumulator from(CBS cbs, CreditoPresumido cbsCredPres) {
        return new CBSTotalAccumulator(cbs != null ? cbs.getVDif() : BigDecimal.ZERO, cbs != null ? cbs.getVDevTrib() : BigDecimal.ZERO, cbs != null ? Objects.requireNonNullElse(cbs.getValorImposto(), BigDecimal.ZERO) : BigDecimal.ZERO, cbsCredPres != null ? Objects.requireNonNullElse(cbsCredPres.getVCredPres(), BigDecimal.ZERO) : BigDecimal.ZERO, cbsCredPres != null ? Objects.requireNonNullElse(cbsCredPres.getVCredPresCondSus(), BigDecimal.ZERO) : BigDecimal.ZERO);
    }

    public CBSTotalAccumulator add(CBSTotalAccumulator other) {
        if (other == null) {
            return this;
        }
        return new CBSTotalAccumulator(this.vDif.add(other.vDif), this.vDevTrib.add(other.vDevTrib), this.vCBS.add(other.vCBS), this.vCredPres.add(other.vCredPres), this.vCredPresCondSus.add(other.vCredPresCondSus));
    }

    public CBSTotal toCBSTotal() {
        CBSTotal total = new CBSTotal();
        total.setVDif(this.vDif);
        total.setVDevTrib(this.vDevTrib);
        total.setVCBS(this.vCBS);
        total.setVCredPres(this.vCredPres);
        total.setVCredPresCondSus(this.vCredPresCondSus);
        return total;
    }
}

