/*
 * Decompiled with CFR 0.152.
 */
package br.gov.serpro.rtc.api.model.roc.reduce;

import br.gov.serpro.rtc.api.model.roc.IBSMun;
import br.gov.serpro.rtc.api.model.roc.IBSMunTotal;
import java.math.BigDecimal;
import java.util.Objects;

public class IBSMunTotalAccumulator {
    private final BigDecimal vDif;
    private final BigDecimal vDevTrib;
    private final BigDecimal vIBSMun;

    public IBSMunTotalAccumulator() {
        this(BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO);
    }

    public IBSMunTotalAccumulator(BigDecimal vDif, BigDecimal vDevTrib, BigDecimal vIBSMun) {
        this.vDif = Objects.requireNonNullElse(vDif, BigDecimal.ZERO);
        this.vDevTrib = Objects.requireNonNullElse(vDevTrib, BigDecimal.ZERO);
        this.vIBSMun = Objects.requireNonNullElse(vIBSMun, BigDecimal.ZERO);
    }

    public static IBSMunTotalAccumulator from(IBSMun ibsMun) {
        if (ibsMun == null) {
            return new IBSMunTotalAccumulator();
        }
        return new IBSMunTotalAccumulator(Objects.requireNonNullElse(ibsMun.getVDif(), BigDecimal.ZERO), Objects.requireNonNullElse(ibsMun.getVDevTrib(), BigDecimal.ZERO), Objects.requireNonNullElse(ibsMun.getValorImposto(), BigDecimal.ZERO));
    }

    public IBSMunTotalAccumulator add(IBSMunTotalAccumulator other) {
        if (other == null) {
            return this;
        }
        return new IBSMunTotalAccumulator(this.vDif.add(other.vDif), this.vDevTrib.add(other.vDevTrib), this.vIBSMun.add(other.vIBSMun));
    }

    public IBSMunTotal toIBSMunTotal() {
        IBSMunTotal total = new IBSMunTotal();
        total.setVDif(this.vDif);
        total.setVDevTrib(this.vDevTrib);
        total.setVIBSMun(this.vIBSMun);
        return total;
    }
}

