/*
 * Decompiled with CFR 0.152.
 */
package br.gov.serpro.rtc.api.model.roc.reduce;

import br.gov.serpro.rtc.api.model.roc.IBSUF;
import br.gov.serpro.rtc.api.model.roc.IBSUFTotal;
import java.math.BigDecimal;
import java.util.Objects;

public class IBSUFTotalAccumulator {
    private final BigDecimal vDif;
    private final BigDecimal vDevTrib;
    private final BigDecimal vIBSUF;

    public IBSUFTotalAccumulator() {
        this(BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO);
    }

    public IBSUFTotalAccumulator(BigDecimal vDif, BigDecimal vDevTrib, BigDecimal vIBSUF) {
        this.vDif = Objects.requireNonNullElse(vDif, BigDecimal.ZERO);
        this.vDevTrib = Objects.requireNonNullElse(vDevTrib, BigDecimal.ZERO);
        this.vIBSUF = Objects.requireNonNullElse(vIBSUF, BigDecimal.ZERO);
    }

    public static IBSUFTotalAccumulator from(IBSUF ibsUf) {
        if (ibsUf == null) {
            return new IBSUFTotalAccumulator();
        }
        return new IBSUFTotalAccumulator(ibsUf.getVDif(), ibsUf.getVDevTrib(), ibsUf.getValorImposto());
    }

    public IBSUFTotalAccumulator add(IBSUFTotalAccumulator other) {
        if (other == null) {
            return this;
        }
        return new IBSUFTotalAccumulator(this.vDif.add(other.vDif), this.vDevTrib.add(other.vDevTrib), this.vIBSUF.add(other.vIBSUF));
    }

    public IBSUFTotal toIBSUFTotal() {
        IBSUFTotal total = new IBSUFTotal();
        total.setVDif(this.vDif);
        total.setVDevTrib(this.vDevTrib);
        total.setVIBSUF(this.vIBSUF);
        return total;
    }
}

