/*
 * Decompiled with CFR 0.152.
 */
package br.gov.serpro.rtc.api.openapi.controller;

import br.gov.serpro.rtc.api.model.output.dadosabertos.AliquotaDadosAbertosOutput;
import br.gov.serpro.rtc.api.model.output.dadosabertos.ClassificacaoTributariaDadosAbertosOutput;
import br.gov.serpro.rtc.api.model.output.dadosabertos.FundamentacaoClassificacaoDadosAbertosOutput;
import br.gov.serpro.rtc.api.model.output.dadosabertos.MunicipioDadosAbertosOutput;
import br.gov.serpro.rtc.api.model.output.dadosabertos.NbsDadosAbertosOutput;
import br.gov.serpro.rtc.api.model.output.dadosabertos.NcmDadosAbertosOutput;
import br.gov.serpro.rtc.api.model.output.dadosabertos.SituacaoTributariaDadosAbertosOutput;
import br.gov.serpro.rtc.api.model.output.dadosabertos.UfDadosAbertosOutput;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.time.LocalDate;
import java.util.List;
import org.springframework.http.ProblemDetail;
import org.springframework.http.ResponseEntity;

@Tag(name="Dados Abertos - VERS\u00c3O BETA", description="Consultas para os Dados Abertos")
public interface DadosAbertosControllerOpenApi {
    @Operation(summary="Unidade Federativa", description="Obt\u00e9m a lista das unidades federativas cadastradas")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Consulta realizada com sucesso", content={@Content(mediaType="application/json", schema=@Schema(implementation=UfDadosAbertosOutput.class))}), @ApiResponse(responseCode="400", description="Requisi\u00e7\u00e3o com problema", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=ProblemDetail.class))}), @ApiResponse(responseCode="404", description="Erro na URL da requisi\u00e7\u00e3o", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=ProblemDetail.class))}), @ApiResponse(responseCode="422", description="Erro de valida\u00e7\u00e3o", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=ProblemDetail.class))}), @ApiResponse(responseCode="500", description="Erro interno na API", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=ProblemDetail.class))})})
    public ResponseEntity<List<UfDadosAbertosOutput>> consultarUfs();

    @Operation(summary="Munic\u00edpio", description="Obt\u00e9m a lista dos munic\u00edpios cadastrados com base na sigla de uma unidade federativa")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Consulta realizada com sucesso", content={@Content(mediaType="application/json", schema=@Schema(implementation=MunicipioDadosAbertosOutput.class))}), @ApiResponse(responseCode="400", description="Requisi\u00e7\u00e3o com problema", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=ProblemDetail.class))}), @ApiResponse(responseCode="404", description="Sigla da UF inexistente", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=ProblemDetail.class))}), @ApiResponse(responseCode="422", description="Erro de valida\u00e7\u00e3o", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=ProblemDetail.class))}), @ApiResponse(responseCode="500", description="Erro interno na API", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=ProblemDetail.class))})})
    public ResponseEntity<List<MunicipioDadosAbertosOutput>> consultarMunicipiosPorSiglaUf(@Parameter(description="Sigla da unidade federativa", example="RS", required=true) String var1);

    @Operation(summary="Situa\u00e7\u00e3o Tribut\u00e1ria (CST)", description="Obt\u00e9m a lista das situa\u00e7\u00f5es tribut\u00e1rias cadastradas vigentes em um determinada data")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Consulta realizada com sucesso", content={@Content(mediaType="application/json", schema=@Schema(implementation=SituacaoTributariaDadosAbertosOutput.class))}), @ApiResponse(responseCode="400", description="Requisi\u00e7\u00e3o com problema", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=ProblemDetail.class))}), @ApiResponse(responseCode="404", description="Erro na URL da requisi\u00e7\u00e3o", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=ProblemDetail.class))}), @ApiResponse(responseCode="422", description="Erro de valida\u00e7\u00e3o", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=ProblemDetail.class))}), @ApiResponse(responseCode="500", description="Erro interno na API", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=ProblemDetail.class))})})
    public ResponseEntity<List<SituacaoTributariaDadosAbertosOutput>> consultarSituacoesTributariasCbsIbs(@Parameter(description="Data no padr\u00e3o ISO 8601 (yyyy-MM-dd)", example="2026-01-01", required=true) LocalDate var1);

    @Operation(summary="Classifica\u00e7\u00e3o Tribut\u00e1ria (cClassTrib)", description="Obt\u00e9m a lista das classifica\u00e7\u00f5es tribut\u00e1rias (cClassTrib) cadastradas com base no c\u00f3digo CST")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Consulta realizada com sucesso", content={@Content(mediaType="application/json", schema=@Schema(implementation=ClassificacaoTributariaDadosAbertosOutput.class))}), @ApiResponse(responseCode="400", description="Requisi\u00e7\u00e3o com problema", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=ProblemDetail.class))}), @ApiResponse(responseCode="404", description="C\u00f3digo CST informado inexistente", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=ProblemDetail.class))}), @ApiResponse(responseCode="422", description="Erro de valida\u00e7\u00e3o", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=ProblemDetail.class))}), @ApiResponse(responseCode="500", description="Erro interno na API", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=ProblemDetail.class))})})
    public ResponseEntity<List<ClassificacaoTributariaDadosAbertosOutput>> consultarClassificacoesTributariasPorIdSituacaoTributaria(@Parameter(description="Id da Situa\u00e7\u00e3o Tribut\u00e1ria (CST)", example="1", required=true) Long var1, @Parameter(description="Data no padr\u00e3o ISO 8601 (yyyy-MM-dd)", example="2026-01-01", required=true) LocalDate var2);

    @Operation(summary="Situa\u00e7\u00e3o Tribut\u00e1ria (CST)", description="Obt\u00e9m a lista das situa\u00e7\u00f5es tribut\u00e1rias cadastradas")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Consulta realizada com sucesso", content={@Content(mediaType="application/json", schema=@Schema(implementation=SituacaoTributariaDadosAbertosOutput.class))}), @ApiResponse(responseCode="400", description="Requisi\u00e7\u00e3o com problema", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=ProblemDetail.class))}), @ApiResponse(responseCode="404", description="Erro na URL da requisi\u00e7\u00e3o", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=ProblemDetail.class))}), @ApiResponse(responseCode="422", description="Erro de valida\u00e7\u00e3o", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=ProblemDetail.class))}), @ApiResponse(responseCode="500", description="Erro interno na API", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=ProblemDetail.class))})})
    public ResponseEntity<List<SituacaoTributariaDadosAbertosOutput>> consultarSituacoesTributariasImpostoSeletivo(@Parameter(description="Data no padr\u00e3o ISO 8601 (yyyy-MM-dd)", example="2027-01-01", required=true) LocalDate var1);

    @Operation(summary="Nomenclatura Comum do Mercosul (NCM)", description="Obt\u00e9m informa\u00e7\u00f5es sobre a NCM em rela\u00e7\u00e3o ao Imposto Seletivo")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Consulta realizada com sucesso", content={@Content(mediaType="application/json", schema=@Schema(implementation=NcmDadosAbertosOutput.class))}), @ApiResponse(responseCode="400", description="Requisi\u00e7\u00e3o com problema", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=ProblemDetail.class))}), @ApiResponse(responseCode="404", description="Erro na URL da requisi\u00e7\u00e3o", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=ProblemDetail.class))}), @ApiResponse(responseCode="422", description="Erro de valida\u00e7\u00e3o", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=ProblemDetail.class))}), @ApiResponse(responseCode="500", description="Erro interno na API", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=ProblemDetail.class))})})
    public ResponseEntity<NcmDadosAbertosOutput> consultarNcm(@Parameter(description="C\u00f3digo NCM sem formata\u00e7\u00e3o", example="24021000", required=true) String var1, @Parameter(description="Data no padr\u00e3o ISO 8601 (yyyy-MM-dd)", example="2027-01-01", required=true) LocalDate var2);

    @Operation(summary="Nomenclatura Brasileira de Servi\u00e7os (NBS)", description="Obt\u00e9m informa\u00e7\u00f5es sobre a NBS em rela\u00e7\u00e3o ao Imposto Seletivo")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Consulta realizada com sucesso", content={@Content(mediaType="application/json", schema=@Schema(implementation=NbsDadosAbertosOutput.class))}), @ApiResponse(responseCode="400", description="Requisi\u00e7\u00e3o com problema", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=ProblemDetail.class))}), @ApiResponse(responseCode="404", description="Erro na URL da requisi\u00e7\u00e3o", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=ProblemDetail.class))}), @ApiResponse(responseCode="422", description="Erro de valida\u00e7\u00e3o", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=ProblemDetail.class))}), @ApiResponse(responseCode="500", description="Erro interno na API", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=ProblemDetail.class))})})
    public ResponseEntity<NbsDadosAbertosOutput> consultarNbs(@Parameter(description="C\u00f3digo NBS sem formata\u00e7\u00e3o", example="114052200", required=true) String var1, @Parameter(description="Data no padr\u00e3o ISO 8601 (yyyy-MM-dd)", example="2027-01-01", required=true) LocalDate var2);

    @Operation(summary="Fundamenta\u00e7\u00e3o Legal", description="Obt\u00e9m informa\u00e7\u00f5es sobre as fundamenta\u00e7\u00f5es legais")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Consulta realizada com sucesso", content={@Content(mediaType="application/json", schema=@Schema(implementation=FundamentacaoClassificacaoDadosAbertosOutput.class))}), @ApiResponse(responseCode="400", description="Requisi\u00e7\u00e3o com problema", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=ProblemDetail.class))}), @ApiResponse(responseCode="404", description="Erro na URL da requisi\u00e7\u00e3o", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=ProblemDetail.class))}), @ApiResponse(responseCode="422", description="Erro de valida\u00e7\u00e3o", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=ProblemDetail.class))}), @ApiResponse(responseCode="500", description="Erro interno na API", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=ProblemDetail.class))})})
    public ResponseEntity<List<FundamentacaoClassificacaoDadosAbertosOutput>> consultarFundamentacoesLegais(@Parameter(description="Data no padr\u00e3o ISO 8601 (yyyy-MM-dd)", example="2027-01-01", required=true) LocalDate var1);

    @Operation(summary="Classifica\u00e7\u00e3o Tribut\u00e1ria (cClassTrib)", description="Obt\u00e9m a lista das classifica\u00e7\u00f5es tribut\u00e1rias (cClassTrib) para CBS e IBS")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Consulta realizada com sucesso", content={@Content(mediaType="application/json", schema=@Schema(implementation=ClassificacaoTributariaDadosAbertosOutput.class))}), @ApiResponse(responseCode="400", description="Requisi\u00e7\u00e3o com problema", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=ProblemDetail.class))}), @ApiResponse(responseCode="404", description="C\u00f3digo CST informado inexistente", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=ProblemDetail.class))}), @ApiResponse(responseCode="422", description="Erro de valida\u00e7\u00e3o", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=ProblemDetail.class))}), @ApiResponse(responseCode="500", description="Erro interno na API", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=ProblemDetail.class))})})
    public ResponseEntity<List<ClassificacaoTributariaDadosAbertosOutput>> consultarClassificacoesTributariasCbsIbs(@Parameter(description="Data no padr\u00e3o ISO 8601 (yyyy-MM-dd)", example="2026-01-01", required=true) LocalDate var1);

    @Operation(summary="Classifica\u00e7\u00e3o Tribut\u00e1ria (cClassTrib)", description="Obt\u00e9m a lista das classifica\u00e7\u00f5es tribut\u00e1rias (cClassTrib) para Imposto Seletivo")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Consulta realizada com sucesso", content={@Content(mediaType="application/json", schema=@Schema(implementation=ClassificacaoTributariaDadosAbertosOutput.class))}), @ApiResponse(responseCode="400", description="Requisi\u00e7\u00e3o com problema", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=ProblemDetail.class))}), @ApiResponse(responseCode="404", description="C\u00f3digo CST informado inexistente", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=ProblemDetail.class))}), @ApiResponse(responseCode="422", description="Erro de valida\u00e7\u00e3o", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=ProblemDetail.class))}), @ApiResponse(responseCode="500", description="Erro interno na API", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=ProblemDetail.class))})})
    public ResponseEntity<List<ClassificacaoTributariaDadosAbertosOutput>> consultarClassificacoesTributariasImpostoSeletivo(@Parameter(description="Data no padr\u00e3o ISO 8601 (yyyy-MM-dd)", example="2026-01-01", required=true) LocalDate var1);

    @Operation(summary="Al\u00edquota Padr\u00e3o ou de Refer\u00eancia", description="Obt\u00e9m a al\u00edquota padr\u00e3o ou de refer\u00eancia para CBS")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Consulta realizada com sucesso", content={@Content(mediaType="application/json", schema=@Schema(implementation=AliquotaDadosAbertosOutput.class))}), @ApiResponse(responseCode="400", description="Requisi\u00e7\u00e3o com problema", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=ProblemDetail.class))}), @ApiResponse(responseCode="404", description="C\u00f3digo CST informado inexistente", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=ProblemDetail.class))}), @ApiResponse(responseCode="422", description="Erro de valida\u00e7\u00e3o", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=ProblemDetail.class))}), @ApiResponse(responseCode="500", description="Erro interno na API", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=ProblemDetail.class))})})
    public ResponseEntity<AliquotaDadosAbertosOutput> consultarAliquotaUniao(@Parameter(description="Data no padr\u00e3o ISO 8601 (yyyy-MM-dd)", example="2026-01-01", required=true) LocalDate var1);

    @Operation(summary="Al\u00edquota Padr\u00e3o ou de Refer\u00eancia", description="Obt\u00e9m a al\u00edquota padr\u00e3o ou de refer\u00eancia para IBS Estadual")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Consulta realizada com sucesso", content={@Content(mediaType="application/json", schema=@Schema(implementation=AliquotaDadosAbertosOutput.class))}), @ApiResponse(responseCode="400", description="Requisi\u00e7\u00e3o com problema", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=ProblemDetail.class))}), @ApiResponse(responseCode="404", description="C\u00f3digo CST informado inexistente", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=ProblemDetail.class))}), @ApiResponse(responseCode="422", description="Erro de valida\u00e7\u00e3o", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=ProblemDetail.class))}), @ApiResponse(responseCode="500", description="Erro interno na API", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=ProblemDetail.class))})})
    public ResponseEntity<AliquotaDadosAbertosOutput> consultarAliquotaUf(@Parameter(description="C\u00f3digo da UF", example="43", required=true) Long var1, @Parameter(description="Data no padr\u00e3o ISO 8601 (yyyy-MM-dd)", example="2026-01-01", required=true) LocalDate var2);

    @Operation(summary="Al\u00edquota Padr\u00e3o ou de Refer\u00eancia", description="Obt\u00e9m a al\u00edquota padr\u00e3o ou de refer\u00eancia para IBS Municipal")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Consulta realizada com sucesso", content={@Content(mediaType="application/json", schema=@Schema(implementation=AliquotaDadosAbertosOutput.class))}), @ApiResponse(responseCode="400", description="Requisi\u00e7\u00e3o com problema", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=ProblemDetail.class))}), @ApiResponse(responseCode="404", description="C\u00f3digo CST informado inexistente", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=ProblemDetail.class))}), @ApiResponse(responseCode="422", description="Erro de valida\u00e7\u00e3o", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=ProblemDetail.class))}), @ApiResponse(responseCode="500", description="Erro interno na API", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=ProblemDetail.class))})})
    public ResponseEntity<AliquotaDadosAbertosOutput> consultarAliquotaMunicipio(@Parameter(description="C\u00f3digo do Munic\u00edpio (Tabela IBGE)", example="4314902", required=true) Long var1, @Parameter(description="Data no padr\u00e3o ISO 8601 (yyyy-MM-dd)", example="2026-01-01", required=true) LocalDate var2);
}

