/*
 * Decompiled with CFR 0.152.
 */
package br.gov.serpro.rtc.config.serializer;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import java.io.IOException;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.Locale;

public class BigDecimalTDec0302_04Serializer
extends JsonSerializer<BigDecimal> {
    private static final DecimalFormat FORMAT = new DecimalFormat("0.00##");

    public void serialize(BigDecimal value, JsonGenerator gen, SerializerProvider serializers) throws IOException {
        if (value == null) {
            gen.writeNull();
        } else {
            if (value.signum() < 0) {
                throw new IllegalArgumentException("N\u00fameros negativos n\u00e3o s\u00e3o permitidos para TDec_0302_04");
            }
            BigDecimal scaled = value.setScale(Math.clamp((long)value.scale(), 2, 4), RoundingMode.HALF_UP);
            gen.writeString(FORMAT.format(scaled.stripTrailingZeros()));
        }
    }

    static {
        FORMAT.setDecimalFormatSymbols(DecimalFormatSymbols.getInstance(Locale.US));
    }
}

