/*
 * Decompiled with CFR 0.152.
 */
package br.gov.serpro.rtc.core.util;

import java.time.LocalDate;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;
import lombok.NonNull;

public final class DateTimeUtils {
    private static final DateTimeFormatter PT_BR_FORMATTER = DateTimeFormatter.ofPattern("dd/MM/yyyy");

    private DateTimeUtils() {
        throw new UnsupportedOperationException("Utility class");
    }

    public static final String toString(@NonNull LocalDate data) {
        if (data == null) {
            throw new NullPointerException("data is marked non-null but is null");
        }
        return PT_BR_FORMATTER.format(data);
    }

    public static final String toString(@NonNull OffsetDateTime data) {
        if (data == null) {
            throw new NullPointerException("data is marked non-null but is null");
        }
        return data.toString();
    }
}

