/*
 * Decompiled with CFR 0.152.
 */
package br.gov.serpro.rtc.domain.model.entity;

import br.gov.serpro.rtc.domain.model.entity.AliquotaPadrao;
import br.gov.serpro.rtc.domain.model.entity.AliquotaReferencia;
import br.gov.serpro.rtc.domain.model.entity.Municipio;
import br.gov.serpro.rtc.domain.model.entity.Uf;
import br.gov.serpro.rtc.domain.model.enumeration.FormaAplicacaoEnum;
import br.gov.serpro.rtc.domain.service.exception.FormaAplicacaoNaoDefinidaException;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.EnumType;
import jakarta.persistence.Enumerated;
import jakarta.persistence.Id;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.Table;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.Positive;
import java.math.BigDecimal;
import java.time.LocalDate;
import lombok.Generated;

@Entity
@Table(name="ALIQUOTA_PADRAO")
public class AliquotaPadrao {
    @Id
    @Column(name="ALPA_ID")
    private Long id;
    @NotNull
    @Column(name="ALPA_FORMA_APLICACAO")
    @Enumerated(value=EnumType.STRING)
    private FormaAplicacaoEnum formaAplicacao;
    @Positive
    @NotNull
    @Column(name="ALPA_VALOR")
    private BigDecimal valor;
    @NotNull
    @Column(name="ALPA_INICIO_VIGENCIA")
    private LocalDate inicioVigencia;
    @Column(name="ALPA_FIM_VIGENCIA")
    private LocalDate fimVigencia;
    @ManyToOne
    @NotNull
    @JoinColumn(name="ALPA_ALRE_ID")
    private AliquotaReferencia aliquotaReferencia;
    @ManyToOne
    @JoinColumn(name="ALPA_MUNI_CD")
    private Municipio municipio;
    @ManyToOne
    @JoinColumn(name="ALPA_UF_CD")
    private Uf uf;

    public BigDecimal getValorAplicavel() {
        switch (1.$SwitchMap$br$gov$serpro$rtc$domain$model$enumeration$FormaAplicacaoEnum[this.getFormaAplicacao().ordinal()]) {
            case 1: {
                return this.getValor();
            }
            case 2: {
                return this.aliquotaReferencia.getValor().add(this.getValor());
            }
            case 3: {
                return this.aliquotaReferencia.getValor().subtract(this.getValor());
            }
        }
        throw new FormaAplicacaoNaoDefinidaException();
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AliquotaPadrao)) {
            return false;
        }
        AliquotaPadrao other = (AliquotaPadrao)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Long this$id = this.getId();
        Long other$id = other.getId();
        return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof AliquotaPadrao;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        return result;
    }

    @Generated
    public AliquotaPadrao() {
    }

    @Generated
    public Long getId() {
        return this.id;
    }

    @Generated
    public FormaAplicacaoEnum getFormaAplicacao() {
        return this.formaAplicacao;
    }

    @Generated
    public BigDecimal getValor() {
        return this.valor;
    }

    @Generated
    public LocalDate getInicioVigencia() {
        return this.inicioVigencia;
    }

    @Generated
    public LocalDate getFimVigencia() {
        return this.fimVigencia;
    }

    @Generated
    public AliquotaReferencia getAliquotaReferencia() {
        return this.aliquotaReferencia;
    }

    @Generated
    public Municipio getMunicipio() {
        return this.municipio;
    }

    @Generated
    public Uf getUf() {
        return this.uf;
    }

    @Generated
    public void setId(Long id) {
        this.id = id;
    }

    @Generated
    public void setFormaAplicacao(FormaAplicacaoEnum formaAplicacao) {
        this.formaAplicacao = formaAplicacao;
    }

    @Generated
    public void setValor(BigDecimal valor) {
        this.valor = valor;
    }

    @Generated
    public void setInicioVigencia(LocalDate inicioVigencia) {
        this.inicioVigencia = inicioVigencia;
    }

    @Generated
    public void setFimVigencia(LocalDate fimVigencia) {
        this.fimVigencia = fimVigencia;
    }

    @Generated
    public void setAliquotaReferencia(AliquotaReferencia aliquotaReferencia) {
        this.aliquotaReferencia = aliquotaReferencia;
    }

    @Generated
    public void setMunicipio(Municipio municipio) {
        this.municipio = municipio;
    }

    @Generated
    public void setUf(Uf uf) {
        this.uf = uf;
    }

    @Generated
    public String toString() {
        return "AliquotaPadrao(id=" + this.getId() + ", formaAplicacao=" + String.valueOf(this.getFormaAplicacao()) + ", valor=" + String.valueOf(this.getValor()) + ", inicioVigencia=" + String.valueOf(this.getInicioVigencia()) + ", fimVigencia=" + String.valueOf(this.getFimVigencia()) + ", aliquotaReferencia=" + String.valueOf(this.getAliquotaReferencia()) + ", municipio=" + String.valueOf(this.getMunicipio()) + ", uf=" + String.valueOf(this.getUf()) + ")";
    }
}

