/*
 * Decompiled with CFR 0.152.
 */
package br.gov.serpro.rtc.domain.repository;

import br.gov.serpro.rtc.domain.model.entity.AliquotaAdRemProduto;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.Optional;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;
import org.springframework.stereotype.Repository;

@Repository
public interface AliquotaAdRemProdutoRepository
extends JpaRepository<AliquotaAdRemProduto, Long> {
    @Query(value="SELECT a.aliquotaAdRem.valor\nFROM AliquotaAdRemProduto a\nWHERE EXISTS (\n    SELECT 1\n    FROM Ncm n\n    WHERE n.codigo = :ncm\n)\nAND a.aliquotaAdRem.tributo.id = :idTributo\nAND a.ncm.codigo = SUBSTRING(:ncm, 1, LENGTH(a.ncm.codigo))\nAND :data BETWEEN a.inicioVigencia AND COALESCE(a.fimVigencia, :data)\nAND NOT EXISTS (\n    SELECT 1\n    FROM ExcecaoAdRemProduto e\n    WHERE e.ncm.codigo = SUBSTRING(:ncm, 1, LENGTH(e.ncm.codigo))\n    AND e.aliquotaAdRemProduto.id = a.id\n    AND :data BETWEEN e.inicioVigencia AND COALESCE(e.fimVigencia, :data)\n)\nAND NOT EXISTS (\n    SELECT 1\n    FROM ExcecaoAdRemProduto e\n    WHERE e.ncm.codigo = SUBSTRING(a.ncm.codigo, 1, LENGTH(e.ncm.codigo))\n    AND e.aliquotaAdRemProduto.id = a.id\n    AND :data BETWEEN e.inicioVigencia AND COALESCE(e.fimVigencia, :data)\n)\nORDER BY LENGTH(a.ncm.codigo) DESC\nLIMIT 1\n")
    @Cacheable(cacheNames={"AliquotaAdRemProdutoRepository.buscarAliquotaAdRem"})
    public Optional<BigDecimal> buscarAliquotaAdRem(@Param(value="ncm") String var1, @Param(value="idTributo") Long var2, @Param(value="data") LocalDate var3);
}

