/*
 * Decompiled with CFR 0.152.
 */
package br.gov.serpro.rtc.domain.repository;

import br.gov.serpro.rtc.domain.model.entity.AliquotaPadrao;
import br.gov.serpro.rtc.domain.model.entity.AliquotaReferencia;
import java.time.LocalDate;
import java.util.Optional;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;
import org.springframework.stereotype.Repository;

@Repository
public interface AliquotaPadraoRepository
extends JpaRepository<AliquotaPadrao, Long> {
    @Query(value="    FROM AliquotaPadrao ap\n    WHERE ap.aliquotaReferencia = :aliquotaReferencia\n      AND :data BETWEEN ap.inicioVigencia AND COALESCE(ap.fimVigencia, :data)\n      AND ap.municipio IS NULL\n      AND ap.uf IS NULL\n")
    @Cacheable(cacheNames={"AliquotaPadraoRepository.buscarAliquotaUniao"}, key="#aliquotaReferencia.getId() + ':' + #data")
    public Optional<AliquotaPadrao> buscarAliquotaUniao(@Param(value="aliquotaReferencia") AliquotaReferencia var1, @Param(value="data") LocalDate var2);

    @Query(value="    FROM AliquotaPadrao ap\n    WHERE ap.aliquotaReferencia = :aliquotaReferencia\n      AND :data BETWEEN ap.inicioVigencia AND COALESCE(ap.fimVigencia, :data)\n      AND ap.municipio IS NULL\n      AND ap.uf.codigo = :codigoUf\n")
    @Cacheable(cacheNames={"AliquotaPadraoRepository.buscarAliquotaUf"}, key="#aliquotaReferencia.getId() + ':'+ #codigoUf +':' + #data")
    public Optional<AliquotaPadrao> buscarAliquotaUf(@Param(value="aliquotaReferencia") AliquotaReferencia var1, @Param(value="codigoUf") Long var2, @Param(value="data") LocalDate var3);

    @Query(value="    FROM AliquotaPadrao ap\n    WHERE ap.aliquotaReferencia = :aliquotaReferencia\n      AND :data BETWEEN ap.inicioVigencia AND COALESCE(ap.fimVigencia, :data)\n      AND ap.municipio.codigo = :municipio\n      AND ap.uf IS NULL\n")
    @Cacheable(cacheNames={"AliquotaPadraoRepository.buscarAliquotaMunicipio"}, key="#aliquotaReferencia.getId() + ':'+ #municipio +':' + #data")
    public Optional<AliquotaPadrao> buscarAliquotaMunicipio(@Param(value="aliquotaReferencia") AliquotaReferencia var1, @Param(value="municipio") Long var2, @Param(value="data") LocalDate var3);
}

