/*
 * Decompiled with CFR 0.152.
 */
package br.gov.serpro.rtc.domain.repository;

import br.gov.serpro.rtc.domain.model.entity.ClassificacaoTributaria;
import java.time.LocalDate;
import java.util.Optional;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;
import org.springframework.stereotype.Repository;

@Repository
public interface ClassificacaoTributariaRepository
extends JpaRepository<ClassificacaoTributaria, Long> {
    @Query(value="SELECT *\nFROM CLASSIFICACAO_TRIBUTARIA ct\nJOIN SITUACAO_TRIBUTARIA st ON ct.CLTR_SITR_ID = st.SITR_ID\nJOIN TRIBUTO_SITUACAO_TRIBUTARIA tst ON tst.TRST_SITR_ID = st.SITR_ID\nJOIN TRIBUTO tb ON tst.TRST_TBTO_ID = tb.TBTO_ID\nWHERE ct.CLTR_CD = :codigo\nAND tb.TBTO_ID = 2\nAND :data BETWEEN ct.CLTR_INICIO_VIGENCIA AND COALESCE(ct.CLTR_FIM_VIGENCIA, :data)\nAND :data BETWEEN st.SITR_INICIO_VIGENCIA AND COALESCE(st.SITR_FIM_VIGENCIA, :data)\nAND :data BETWEEN tst.TRST_INICIO_VIGENCIA AND COALESCE(tst.TRST_FIM_VIGENCIA, :data)\nAND :data BETWEEN tb.TBTO_INICIO_VIGENCIA AND COALESCE(tb.TBTO_FIM_VIGENCIA, :data)\n", nativeQuery=true)
    @Cacheable(cacheNames={"ClassificacaoTributariaRepository.buscarClassificacaoTributariaCbsIbs"})
    public Optional<ClassificacaoTributaria> buscarClassificacaoTributariaCbsIbs(@Param(value="codigo") String var1, @Param(value="data") LocalDate var2);

    @Query(value="SELECT *\nFROM CLASSIFICACAO_TRIBUTARIA ct\nJOIN SITUACAO_TRIBUTARIA st ON ct.CLTR_SITR_ID = st.SITR_ID\nJOIN TRIBUTO_SITUACAO_TRIBUTARIA tst ON tst.TRST_SITR_ID = st.SITR_ID\nJOIN TRIBUTO tb ON tst.TRST_TBTO_ID = tb.TBTO_ID\nWHERE ct.CLTR_CD = :codigo\nAND tb.TBTO_ID = 1\nAND :data BETWEEN ct.CLTR_INICIO_VIGENCIA AND COALESCE(ct.CLTR_FIM_VIGENCIA, :data)\nAND :data BETWEEN st.SITR_INICIO_VIGENCIA AND COALESCE(st.SITR_FIM_VIGENCIA, :data)\nAND :data BETWEEN tst.TRST_INICIO_VIGENCIA AND COALESCE(tst.TRST_FIM_VIGENCIA, :data)\nAND :data BETWEEN tb.TBTO_INICIO_VIGENCIA AND COALESCE(tb.TBTO_FIM_VIGENCIA, :data)\n", nativeQuery=true)
    @Cacheable(cacheNames={"ClassificacaoTributariaRepository.buscarClassificacaoTributariaImpostoSeletivo"})
    public Optional<ClassificacaoTributaria> buscarClassificacaoTributariaImpostoSeletivo(@Param(value="codigo") String var1, @Param(value="data") LocalDate var2);
}

