/*
 * Decompiled with CFR 0.152.
 */
package br.gov.serpro.rtc.domain.repository;

import br.gov.serpro.rtc.domain.model.entity.NbsAplicavel;
import java.time.LocalDate;
import java.util.List;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;
import org.springframework.stereotype.Repository;

@Repository
public interface NbsAplicavelRepository
extends JpaRepository<NbsAplicavel, Long> {
    @Query(value="    SELECT n.nbs, n.classificacaoTributaria.id, n.id\n    FROM NbsAplicavel n\n    WHERE n.nbs = SUBSTRING(:nbs, 1, LENGTH(n.nbs))\n      AND n.classificacaoTributaria.id = :idClassificacaoTributaria\n      AND :data BETWEEN n.inicioVigencia AND COALESCE(n.fimVigencia, :data)\n")
    @Cacheable(cacheNames={"NbsAplicavelRepository.temNbsAplicavel"})
    public List<Object[]> temNbsAplicavel(@Param(value="nbs") String var1, @Param(value="idClassificacaoTributaria") Long var2, @Param(value="data") LocalDate var3);

    @Query(value="            SELECT e.nbs, n.classificacaoTributaria.id, e.nbsAplicavel.id\n            FROM ExcecaoNbsAplicavel e\n            JOIN e.nbsAplicavel n\n            WHERE n.nbs = SUBSTRING(:nbs, 1, LENGTH(n.nbs))\n            AND e.nbs = SUBSTRING(:nbs, 1, LENGTH(e.nbs))\n            AND n.classificacaoTributaria.id = :idClassificacaoTributaria\n            AND :data BETWEEN e.inicioVigencia AND COALESCE(e.fimVigencia, :data)\n")
    @Cacheable(cacheNames={"NbsAplicavelRepository.temExcecaoNbsAplicavel"})
    public List<Object[]> temExcecaoNbsAplicavel(@Param(value="nbs") String var1, @Param(value="idClassificacaoTributaria") Long var2, @Param(value="data") LocalDate var3);

    @Query(value="    SELECT n.nbs, n.classificacaoTributaria.id, n.id\n    FROM NbsAplicavel n\n    LEFT JOIN ExcecaoNbsAplicavel e ON e.nbsAplicavel.id = n.id\n    WHERE n.nbs = SUBSTRING(:nbs, 1, LENGTH(n.nbs))\n      AND n.classificacaoTributaria.id = :idClassificacaoTributaria\n      AND :data BETWEEN n.inicioVigencia AND COALESCE(n.fimVigencia, :data)\n      AND (e.id IS NULL OR :data NOT BETWEEN e.inicioVigencia AND COALESCE(e.fimVigencia, :data))\n")
    @Cacheable(cacheNames={"NbsAplicavelRepository.temNbsAplicavelSemExcecao"})
    public List<Object[]> temNbsAplicavelSemExcecao(@Param(value="nbs") String var1, @Param(value="idClassificacaoTributaria") Long var2, @Param(value="data") LocalDate var3);

    @Query(value="    SELECT CASE\n    WHEN NOT EXISTS (\n    SELECT 1\n    FROM NbsAplicavel n\n    WHERE n.classificacaoTributaria.id = :idClassificacaoTributaria\n    ) THEN 0\n    ELSE 1\n    END\n")
    @Cacheable(cacheNames={"NbsAplicavelRepository.tem"})
    public Integer tem(@Param(value="nbs") String var1, @Param(value="idClassificacaoTributaria") Long var2, @Param(value="data") LocalDate var3);
}

