/*
 * Decompiled with CFR 0.152.
 */
package br.gov.serpro.rtc.domain.repository;

import br.gov.serpro.rtc.domain.model.entity.NcmAplicavel;
import java.time.LocalDate;
import java.util.List;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;
import org.springframework.stereotype.Repository;

@Repository
public interface NcmAplicavelRepository
extends JpaRepository<NcmAplicavel, Long> {
    @Query(value="    SELECT n.ncm, n.classificacaoTributaria.id, n.id\n    FROM NcmAplicavel n\n    WHERE n.ncm = SUBSTRING(:ncm, 1, LENGTH(n.ncm))\n      AND n.classificacaoTributaria.id = :idClassificacaoTributaria\n      AND :data BETWEEN n.inicioVigencia AND COALESCE(n.fimVigencia, :data)\n")
    @Cacheable(cacheNames={"NcmAplicavelRepository.temNcmAplicavel"})
    public List<Object[]> temNcmAplicavel(@Param(value="ncm") String var1, @Param(value="idClassificacaoTributaria") Long var2, @Param(value="data") LocalDate var3);

    @Query(value="            SELECT e.ncm, n.classificacaoTributaria.id, e.ncmAplicavel.id\n            FROM ExcecaoNcmAplicavel e\n            JOIN e.ncmAplicavel n\n            WHERE n.ncm = SUBSTRING(:ncm, 1, LENGTH(n.ncm))\n            AND e.ncm = SUBSTRING(:ncm, 1, LENGTH(e.ncm))\n            AND n.classificacaoTributaria.id = :idClassificacaoTributaria\n            AND :data BETWEEN e.inicioVigencia AND COALESCE(e.fimVigencia, :data)\n")
    @Cacheable(cacheNames={"NcmAplicavelRepository.temExcecaoNcmAplicavel"})
    public List<Object[]> temExcecaoNcmAplicavel(@Param(value="ncm") String var1, @Param(value="idClassificacaoTributaria") Long var2, @Param(value="data") LocalDate var3);

    @Query(value="    SELECT n.ncm, n.classificacaoTributaria.id, n.id\n    FROM NcmAplicavel n\n    LEFT JOIN ExcecaoNcmAplicavel e ON e.ncmAplicavel.id = n.id\n    WHERE n.ncm = SUBSTRING(:ncm, 1, LENGTH(n.ncm))\n      AND n.classificacaoTributaria.id = :idClassificacaoTributaria\n      AND :data BETWEEN n.inicioVigencia AND COALESCE(n.fimVigencia, :data)\n      AND (e.id IS NULL OR :data NOT BETWEEN e.inicioVigencia AND COALESCE(e.fimVigencia, :data))\n")
    @Cacheable(cacheNames={"NcmAplicavelRepository.temNcmAplicavelSemExcecao"})
    public List<Object[]> temNcmAplicavelSemExcecao(@Param(value="ncm") String var1, @Param(value="idClassificacaoTributaria") Long var2, @Param(value="data") LocalDate var3);

    @Query(value="    SELECT CASE\n    WHEN NOT EXISTS (\n    SELECT 1\n    FROM NcmAplicavel n\n    WHERE n.classificacaoTributaria.id = :idClassificacaoTributaria\n    ) THEN 0\n    WHEN EXISTS (\n    SELECT 1\n    FROM NcmAplicavel n\n    LEFT JOIN ExcecaoNcmAplicavel e ON e.ncmAplicavel.id = n.id\n    WHERE n.ncm = SUBSTRING(:ncm, 1, LENGTH(n.ncm))\n      AND n.classificacaoTributaria.id = :idClassificacaoTributaria\n      AND :data BETWEEN n.inicioVigencia AND COALESCE(n.fimVigencia, :data)\n      AND (e.id IS NULL OR :data NOT BETWEEN e.inicioVigencia AND COALESCE(e.fimVigencia, :data))\n    ) THEN 0\n    ELSE 1\n    END\n")
    public Integer temRestricao(@Param(value="ncm") String var1, @Param(value="idClassificacaoTributaria") Long var2, @Param(value="data") LocalDate var3);

    @Query(value="    SELECT CASE\n    WHEN NOT EXISTS (\n    SELECT 1\n    FROM NcmAplicavel n\n    WHERE n.classificacaoTributaria.id = :idClassificacaoTributaria\n    ) THEN 0\n    ELSE 1\n    END\n")
    @Cacheable(cacheNames={"NcmAplicavelRepository.tem"})
    public Integer tem(@Param(value="ncm") String var1, @Param(value="idClassificacaoTributaria") Long var2, @Param(value="data") LocalDate var3);
}

