/*
 * Decompiled with CFR 0.152.
 */
package br.gov.serpro.rtc.domain.repository;

import br.gov.serpro.rtc.domain.model.entity.Ncm;
import java.time.LocalDate;
import java.util.Optional;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;
import org.springframework.stereotype.Repository;

@Repository
public interface NcmRepository
extends JpaRepository<Ncm, String> {
    @Query(value="SELECT n.descricao\nFROM Ncm n\nWHERE n.codigo = SUBSTRING(:codigo, 1, :limite)\nAND :data BETWEEN n.inicioVigencia AND COALESCE(n.fimVigencia, :data)\n")
    public Optional<String> buscarDescricaoNcm(@Param(value="codigo") String var1, @Param(value="limite") int var2, @Param(value="data") LocalDate var3);

    @Query(value="SELECT COUNT(n) > 0\nFROM Ncm n\nWHERE n.codigo = :codigo\nAND :data BETWEEN n.inicioVigencia AND COALESCE(n.fimVigencia, :data)\n")
    @Cacheable(cacheNames={"NcmRepository.existeNcm"})
    public boolean existeNcm(@Param(value="codigo") String var1, @Param(value="data") LocalDate var2);
}

