/*
 * Decompiled with CFR 0.152.
 */
package br.gov.serpro.rtc.domain.repository;

import br.gov.serpro.rtc.domain.model.entity.SituacaoTributaria;
import java.time.LocalDate;
import java.util.List;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;
import org.springframework.stereotype.Repository;

@Repository
public interface SituacaoTributariaRepository
extends JpaRepository<SituacaoTributaria, Long> {
    @Query(value="SELECT t.situacaoTributaria\nFROM TributoSituacaoTributaria t\nWHERE t.tributo.id = :idTributo\nAND t.inicioVigencia <= :data\nAND (t.fimVigencia IS NULL OR t.fimVigencia >= :data)\n")
    public List<SituacaoTributaria> consultarPorIdTributo(@Param(value="idTributo") Long var1, @Param(value="data") LocalDate var2);

    @Query(value="SELECT COUNT(t) > 0\nFROM TributoSituacaoTributaria t\nWHERE t.tributo.id = :idTributo\nAND t.situacaoTributaria.codigo = :cst\nAND :data BETWEEN t.inicioVigencia AND COALESCE(t.fimVigencia, :data)\nAND :data BETWEEN t.situacaoTributaria.inicioVigencia AND COALESCE(t.situacaoTributaria.fimVigencia, :data)\n")
    @Cacheable(cacheNames={"SituacaoTributariaRepository.existeCst"})
    public boolean existeCst(@Param(value="cst") String var1, @Param(value="idTributo") Long var2, @Param(value="data") LocalDate var3);
}

