/*
 * Decompiled with CFR 0.152.
 */
package br.gov.serpro.rtc.domain.repository;

import br.gov.serpro.rtc.domain.model.entity.TratamentoClassificacao;
import java.time.LocalDate;
import java.util.List;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Query;
import org.springframework.stereotype.Repository;

@Repository
public interface TratamentoClassificacaoRepository
extends JpaRepository<TratamentoClassificacao, Long> {
    @Query(value="FROM TratamentoClassificacao\nWHERE classificacaoTributaria.id = :idClassificacaoTributaria\n    AND (inicioVigencia <= :data AND (fimVigencia IS NULL OR fimVigencia >= :data))\n")
    @Cacheable(cacheNames={"TratamentoClassificacaoRepository.buscarTratamentoClassificacao"})
    public TratamentoClassificacao buscarTratamentoClassificacao(Long var1, LocalDate var2);

    @Query(value="SELECT\n    ct.CLTR_CD,\n    ct.CLTR_DESCRICAO,\n    ct.CLTR_TIPO_ALIQUOTA,\n    ct.CLTR_NOMENCLATURA,\n    tt.TRTR_DESCRICAO,\n    tt.TRTR_IN_INCOMPATIVEL_COM_SUSPENSAO,\n    tt.TRTR_IN_EXIGE_GRUPO_DESONERACAO,\n    tt.TRTR_IN_POSSUI_PERCENTUAL_REDUCAO\nFROM TRATAMENTO_CLASSIFICACAO tc\nJOIN CLASSIFICACAO_TRIBUTARIA ct ON tc.TRCL_CLTR_ID = ct.CLTR_ID\nJOIN TRATAMENTO_TRIBUTARIO tt ON tt.TRTR_ID = tc.TRCL_TRTR_ID\nWHERE ct.CLTR_SITR_ID = :idSituacaoTributaria\n    AND :data BETWEEN tc.TRCL_INICIO_VIGENCIA AND COALESCE(tc.TRCL_FIM_VIGENCIA, :data)\n    AND :data BETWEEN ct.CLTR_INICIO_VIGENCIA AND COALESCE(ct.CLTR_FIM_VIGENCIA, :data)\n    AND :data BETWEEN tt.TRTR_INICIO_VIGENCIA AND COALESCE(tt.TRTR_FIM_VIGENCIA, :data)\n", nativeQuery=true)
    public List<Object[]> consultarTratamentoClassificacaoPorIdSituacaoTributaria(Long var1, LocalDate var2);

    @Query(value="SELECT\n    ct.CLTR_CD,\n    ct.CLTR_DESCRICAO,\n    ct.CLTR_TIPO_ALIQUOTA,\n    ct.CLTR_NOMENCLATURA,\n    tt.TRTR_DESCRICAO,\n    tt.TRTR_IN_INCOMPATIVEL_COM_SUSPENSAO,\n    tt.TRTR_IN_EXIGE_GRUPO_DESONERACAO,\n    tt.TRTR_IN_POSSUI_PERCENTUAL_REDUCAO\nFROM TRATAMENTO_CLASSIFICACAO tc\nJOIN CLASSIFICACAO_TRIBUTARIA ct ON tc.TRCL_CLTR_ID = ct.CLTR_ID\nJOIN TRATAMENTO_TRIBUTARIO tt ON tt.TRTR_ID = tc.TRCL_TRTR_ID\nJOIN TRIBUTO_SITUACAO_TRIBUTARIA tst ON tst.TRST_SITR_ID = ct.CLTR_SITR_ID\nWHERE :data BETWEEN tc.TRCL_INICIO_VIGENCIA AND COALESCE(tc.TRCL_FIM_VIGENCIA, :data)\n  AND :data BETWEEN ct.CLTR_INICIO_VIGENCIA AND COALESCE(ct.CLTR_FIM_VIGENCIA, :data)\n  AND :data BETWEEN tt.TRTR_INICIO_VIGENCIA AND COALESCE(tt.TRTR_FIM_VIGENCIA, :data)\n  AND :data BETWEEN tst.TRST_INICIO_VIGENCIA AND COALESCE(tst.TRST_FIM_VIGENCIA, :data)\n  AND tst.TRST_TBTO_ID == 2\n", nativeQuery=true)
    public List<Object[]> consultarTratamentoClassificacaoCbsIbs(LocalDate var1);

    @Query(value="SELECT\n    ct.CLTR_CD,\n    ct.CLTR_DESCRICAO,\n    ct.CLTR_TIPO_ALIQUOTA,\n    ct.CLTR_NOMENCLATURA,\n    tt.TRTR_DESCRICAO,\n    tt.TRTR_IN_INCOMPATIVEL_COM_SUSPENSAO,\n    tt.TRTR_IN_EXIGE_GRUPO_DESONERACAO,\n    tt.TRTR_IN_POSSUI_PERCENTUAL_REDUCAO\nFROM TRATAMENTO_CLASSIFICACAO tc\nJOIN CLASSIFICACAO_TRIBUTARIA ct ON tc.TRCL_CLTR_ID = ct.CLTR_ID\nJOIN TRATAMENTO_TRIBUTARIO tt ON tt.TRTR_ID = tc.TRCL_TRTR_ID\nJOIN TRIBUTO_SITUACAO_TRIBUTARIA tst ON tst.TRST_SITR_ID = ct.CLTR_SITR_ID\nWHERE :data BETWEEN tc.TRCL_INICIO_VIGENCIA AND COALESCE(tc.TRCL_FIM_VIGENCIA, :data)\n  AND :data BETWEEN ct.CLTR_INICIO_VIGENCIA AND COALESCE(ct.CLTR_FIM_VIGENCIA, :data)\n  AND :data BETWEEN tt.TRTR_INICIO_VIGENCIA AND COALESCE(tt.TRTR_FIM_VIGENCIA, :data)\n  AND :data BETWEEN tst.TRST_INICIO_VIGENCIA AND COALESCE(tst.TRST_FIM_VIGENCIA, :data)\n  AND tst.TRST_TBTO_ID == 1\n", nativeQuery=true)
    public List<Object[]> consultarTratamentoClassificacaoImpostoSeletivo(LocalDate var1);
}

