/*
 * Decompiled with CFR 0.152.
 */
package br.gov.serpro.rtc.domain.service;

import br.gov.serpro.rtc.api.model.input.ItemOperacaoInput;
import br.gov.serpro.rtc.api.model.input.OperacaoInput;
import br.gov.serpro.rtc.api.model.roc.Objeto;
import br.gov.serpro.rtc.api.model.roc.ROC;
import br.gov.serpro.rtc.api.model.roc.Tributos;
import br.gov.serpro.rtc.api.model.roc.ValoresTotais;
import br.gov.serpro.rtc.domain.model.entity.ClassificacaoTributaria;
import br.gov.serpro.rtc.domain.model.entity.TratamentoClassificacao;
import br.gov.serpro.rtc.domain.service.AliquotaAdRemProdutoService;
import br.gov.serpro.rtc.domain.service.AliquotaAdValoremProdutoService;
import br.gov.serpro.rtc.domain.service.ClassificacaoTributariaService;
import br.gov.serpro.rtc.domain.service.MunicipioService;
import br.gov.serpro.rtc.domain.service.NbsAplicavelService;
import br.gov.serpro.rtc.domain.service.NbsService;
import br.gov.serpro.rtc.domain.service.NcmAplicavelService;
import br.gov.serpro.rtc.domain.service.NcmService;
import br.gov.serpro.rtc.domain.service.SituacaoTributariaService;
import br.gov.serpro.rtc.domain.service.TratamentoClassificacaoService;
import br.gov.serpro.rtc.domain.service.UfService;
import br.gov.serpro.rtc.domain.service.calculotributo.CalculoTributoService;
import br.gov.serpro.rtc.domain.service.calculotributo.model.AliquotaImpostoSeletivoModel;
import br.gov.serpro.rtc.domain.service.calculotributo.model.OperacaoModel;
import br.gov.serpro.rtc.domain.service.calculotributo.model.TratamentoClassificacaoModel;
import br.gov.serpro.rtc.domain.service.exception.ClassificacaoTributariaNaoVinculadaSituacaoTributariaException;
import br.gov.serpro.rtc.domain.service.exception.DesoneracaoNaoInformadaException;
import br.gov.serpro.rtc.domain.service.exception.ImpostoSeletivoNaoInformadoException;
import br.gov.serpro.rtc.domain.service.exception.IncompatibilidadeSuspensaoException;
import br.gov.serpro.rtc.domain.service.exception.ItemDuplicadoException;
import br.gov.serpro.rtc.domain.service.exception.NbsNaoEncontradaException;
import br.gov.serpro.rtc.domain.service.exception.NcmNaoEncontradaException;
import br.gov.serpro.rtc.domain.service.exception.NcmNbsSimultaneasException;
import br.gov.serpro.rtc.domain.service.exception.NomenclaturaException;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.HashSet;
import java.util.List;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;

/*
 * Exception performing whole class analysis ignored.
 */
@Service
public class CalculadoraService {
    private final CalculoTributoService calculadorService;
    private final TratamentoClassificacaoService tratamentoClassificacaoService;
    private final ClassificacaoTributariaService classificacaoTributariaService;
    private final UfService ufService;
    private final AliquotaAdValoremProdutoService aliquotaAdValoremProdutoService;
    private final AliquotaAdRemProdutoService aliquotaAdRemProdutoService;
    private final NcmAplicavelService ncmAplicavelService;
    private final NbsAplicavelService nbsAplicavelService;
    private final NcmService ncmService;
    private final NbsService nbsService;
    private final MunicipioService municipioService;
    private final SituacaoTributariaService situacaoTributariaService;

    public ROC calcularTributos(OperacaoInput operacao) {
        this.ufService.validarUf(operacao.getUf());
        this.municipioService.validarMunicipio(operacao.getMunicipio(), operacao.getUf());
        List detalhes = this.getDetalhesImposto(operacao);
        return ROC.builder().objetos(detalhes).total(ValoresTotais.create((List)detalhes)).build();
    }

    private List<Objeto> getDetalhesImposto(OperacaoInput operacao) {
        LocalDate data = operacao.getDataHoraEmissao().toLocalDate();
        HashSet<Integer> numerosSeen = new HashSet<Integer>();
        for (ItemOperacaoInput item2 : operacao.getItens()) {
            if (numerosSeen.add(item2.getNumero())) continue;
            throw new ItemDuplicadoException(item2.getNumero().toString());
        }
        return operacao.getItens().parallelStream().map(item -> Objeto.builder().nObj(item.getNumero()).tribCalc(this.getImposto(operacao, item, data)).build()).sorted().toList();
    }

    private Tributos getImposto(OperacaoInput operacao, ItemOperacaoInput item, LocalDate data) {
        if (item.getQuantidade() == null) {
            item.setQuantidade(BigDecimal.ONE);
        }
        if (item.getUnidade() == null) {
            item.setUnidade("UN");
        }
        this.validarNcmNbs(item.getNcm(), item.getNbs(), data);
        this.situacaoTributariaService.validarCst(item.getCst(), Long.valueOf(2L), data);
        TratamentoClassificacaoModel tratamentoClassificacao = this.obterTratamentoClassificacao(item, data);
        Long codigoUf = this.ufService.buscar(operacao.getUf()).getCodigo();
        OperacaoModel operacaoModel = OperacaoModel.builder().data(operacao.getDataHoraEmissao()).codigoMunicipio(operacao.getMunicipio()).codigoUf(codigoUf).ncm(item.getNcm()).nbs(item.getNbs()).item(item).tratamentoClassificacao(tratamentoClassificacao).build();
        return this.calculadorService.calcular(operacaoModel);
    }

    private TratamentoClassificacaoModel obterTratamentoClassificacao(ItemOperacaoInput item, LocalDate data) {
        AliquotaImpostoSeletivoModel aliquotaImpostoSeletivo;
        ClassificacaoTributaria classificacaoTributariaCbsIbs = null;
        ClassificacaoTributaria classificacaoTributariaImpostoSeletivo = null;
        TratamentoClassificacao tratamentoClassificacaoCbsIbs = null;
        TratamentoClassificacao tratamentoClassificacaoImpostoSeletivo = null;
        TratamentoClassificacao tratamentoClassificacaoCbsIbsDesoneracao = null;
        String cst = null;
        String cClassTrib = null;
        Boolean temDesoneracao = false;
        String ncm = item.getNcm();
        String nbs = item.getNbs();
        classificacaoTributariaCbsIbs = this.classificacaoTributariaService.buscarClassificacaoTributariaCbsIbs(item.getCClassTrib(), data);
        this.validarClassificacaoTributariaCbsIbs(classificacaoTributariaCbsIbs, item.getCst(), ncm, nbs);
        tratamentoClassificacaoCbsIbs = this.tratamentoClassificacaoService.buscarTratamentoClassificacao(classificacaoTributariaCbsIbs.getId(), data);
        cst = item.getCst();
        cClassTrib = item.getCClassTrib();
        if (tratamentoClassificacaoCbsIbs.getTratamentoTributario().isInExigeGrupoDesoneracao()) {
            if (item.getTributacaoRegular() == null) {
                throw new DesoneracaoNaoInformadaException(cClassTrib, cst);
            }
            cst = item.getTributacaoRegular().getCst();
            cClassTrib = item.getTributacaoRegular().getCClassTrib();
            tratamentoClassificacaoCbsIbsDesoneracao = tratamentoClassificacaoCbsIbs;
            classificacaoTributariaCbsIbs = this.classificacaoTributariaService.buscarClassificacaoTributariaCbsIbs(cClassTrib, data);
            this.validarClassificacaoTributariaCbsIbs(classificacaoTributariaCbsIbs, cst, ncm, nbs);
            tratamentoClassificacaoCbsIbs = this.tratamentoClassificacaoService.buscarTratamentoClassificacao(classificacaoTributariaCbsIbs.getId(), data);
            if (tratamentoClassificacaoCbsIbs.getTratamentoTributario().isInIncompativelComSuspensao()) {
                throw new IncompatibilidadeSuspensaoException(cClassTrib, cst);
            }
            temDesoneracao = true;
        } else if (item.getTributacaoRegular() != null) {
            // empty if block
        }
        if (CalculadoraService.isNullOrEmpty((String)ncm) && CalculadoraService.isNullOrEmpty((String)nbs)) {
            this.ncmAplicavelService.validarNcmAplicavel(ncm, classificacaoTributariaCbsIbs.getId(), classificacaoTributariaCbsIbs.getCodigo(), data);
            this.nbsAplicavelService.validarNbsAplicavel(nbs, classificacaoTributariaCbsIbs.getId(), classificacaoTributariaCbsIbs.getCodigo(), data);
        }
        if (!CalculadoraService.isNullOrEmpty((String)ncm) && CalculadoraService.isNullOrEmpty((String)nbs)) {
            this.ncmAplicavelService.validarNcmAplicavel(ncm, classificacaoTributariaCbsIbs.getId(), classificacaoTributariaCbsIbs.getCodigo(), data);
        }
        if (!CalculadoraService.isNullOrEmpty((String)nbs) && CalculadoraService.isNullOrEmpty((String)ncm)) {
            this.nbsAplicavelService.validarNbsAplicavel(nbs, classificacaoTributariaCbsIbs.getId(), classificacaoTributariaCbsIbs.getCodigo(), data);
        }
        if ((aliquotaImpostoSeletivo = this.analisarAliquotaImpostoSeletivo(item, data)) != null) {
            if (item.getImpostoSeletivo() == null) {
                throw new ImpostoSeletivoNaoInformadoException(ncm, data);
            }
            this.situacaoTributariaService.validarCst(item.getImpostoSeletivo().getCst(), Long.valueOf(1L), data);
            classificacaoTributariaImpostoSeletivo = this.classificacaoTributariaService.buscarClassificacaoTributariaImpostoSeletivo(item.getImpostoSeletivo().getCClassTrib(), data);
            this.validarClassificacaoTributariaImpostoSeletivo(classificacaoTributariaImpostoSeletivo, item.getImpostoSeletivo().getCst());
            tratamentoClassificacaoImpostoSeletivo = this.tratamentoClassificacaoService.buscarTratamentoClassificacao(classificacaoTributariaImpostoSeletivo.getId(), data);
        } else if (aliquotaImpostoSeletivo != null || item.getImpostoSeletivo() != null) {
            // empty if block
        }
        return TratamentoClassificacaoModel.builder().tratamentoClassificacaoCbsIbs(tratamentoClassificacaoCbsIbs).tratamentoClassificacaoImpostoSeletivo(tratamentoClassificacaoImpostoSeletivo).tratamentoClassificacaoCbsIbsDesoneracao(tratamentoClassificacaoCbsIbsDesoneracao).aliquotaImpostoSeletivo(aliquotaImpostoSeletivo).temDesoneracao(temDesoneracao).build();
    }

    private AliquotaImpostoSeletivoModel analisarAliquotaImpostoSeletivo(ItemOperacaoInput item, LocalDate data) {
        String ncm = item.getNcm();
        String nbs = item.getNbs();
        if (StringUtils.length((CharSequence)ncm) == 8) {
            BigDecimal aliquotaAdValorem = this.aliquotaAdValoremProdutoService.buscarAliquotaAdValorem(ncm, Long.valueOf(1L), data);
            BigDecimal aliquotaAdRem = this.aliquotaAdRemProdutoService.buscarAliquotaAdRem(ncm, Long.valueOf(1L), data);
            if (aliquotaAdValorem != null || aliquotaAdRem != null) {
                return AliquotaImpostoSeletivoModel.builder().aliquotaAdValorem(aliquotaAdValorem).aliquotaAdRem(aliquotaAdRem).build();
            }
        } else if (StringUtils.length((CharSequence)nbs) == 9) {
            // empty if block
        }
        return null;
    }

    private static boolean isNullOrEmpty(String str) {
        return str == null || str.trim().isEmpty();
    }

    private void validarClassificacaoTributariaCbsIbs(ClassificacaoTributaria classificacaoTributaria, String cst, String ncm, String nbs) {
        if (ncm == null && nbs == null) {
            return;
        }
        String nomenclatura = classificacaoTributaria.getNomenclatura();
        if ("NBS".equals(nomenclatura)) {
            if (CalculadoraService.isNullOrEmpty((String)nbs) || !CalculadoraService.isNullOrEmpty((String)ncm)) {
                throw new NomenclaturaException(classificacaoTributaria.getCodigo(), "NBS", "CBS e IBS");
            }
        } else if ("NCM".equals(nomenclatura)) {
            if (CalculadoraService.isNullOrEmpty((String)ncm) || !CalculadoraService.isNullOrEmpty((String)nbs)) {
                throw new NomenclaturaException(classificacaoTributaria.getCodigo(), "NCM", "CBS e IBS");
            }
        } else if ("NBS ou NCM".equals(nomenclatura) || CalculadoraService.isNullOrEmpty((String)nomenclatura) || "CIB".equals(nomenclatura)) {
            // empty if block
        }
        if (!classificacaoTributaria.getSituacaoTributaria().getCodigo().equals(cst)) {
            throw new ClassificacaoTributariaNaoVinculadaSituacaoTributariaException(classificacaoTributaria.getCodigo(), cst, "CBS e IBS");
        }
    }

    private void validarClassificacaoTributariaImpostoSeletivo(ClassificacaoTributaria classificacaoTributaria, String cst) {
        if (!classificacaoTributaria.getSituacaoTributaria().getCodigo().equals(cst)) {
            throw new ClassificacaoTributariaNaoVinculadaSituacaoTributariaException(classificacaoTributaria.getCodigo(), cst, "Imposto Seletivo");
        }
    }

    private void validarNcmNbs(String ncm, String nbs, LocalDate data) {
        if (!CalculadoraService.isNullOrEmpty((String)ncm) && !CalculadoraService.isNullOrEmpty((String)nbs)) {
            throw new NcmNbsSimultaneasException();
        }
        if (!CalculadoraService.isNullOrEmpty((String)ncm) && !this.ncmService.existeNcm(ncm, data)) {
            throw new NcmNaoEncontradaException(ncm, data);
        }
        if (!CalculadoraService.isNullOrEmpty((String)nbs) && !this.nbsService.existeNbs(nbs, data)) {
            throw new NbsNaoEncontradaException(nbs, data);
        }
    }

    @Generated
    public CalculadoraService(CalculoTributoService calculadorService, TratamentoClassificacaoService tratamentoClassificacaoService, ClassificacaoTributariaService classificacaoTributariaService, UfService ufService, AliquotaAdValoremProdutoService aliquotaAdValoremProdutoService, AliquotaAdRemProdutoService aliquotaAdRemProdutoService, NcmAplicavelService ncmAplicavelService, NbsAplicavelService nbsAplicavelService, NcmService ncmService, NbsService nbsService, MunicipioService municipioService, SituacaoTributariaService situacaoTributariaService) {
        this.calculadorService = calculadorService;
        this.tratamentoClassificacaoService = tratamentoClassificacaoService;
        this.classificacaoTributariaService = classificacaoTributariaService;
        this.ufService = ufService;
        this.aliquotaAdValoremProdutoService = aliquotaAdValoremProdutoService;
        this.aliquotaAdRemProdutoService = aliquotaAdRemProdutoService;
        this.ncmAplicavelService = ncmAplicavelService;
        this.nbsAplicavelService = nbsAplicavelService;
        this.ncmService = ncmService;
        this.nbsService = nbsService;
        this.municipioService = municipioService;
        this.situacaoTributariaService = situacaoTributariaService;
    }
}

