/*
 * Decompiled with CFR 0.152.
 */
package br.gov.serpro.rtc.domain.service;

import br.gov.serpro.rtc.domain.model.entity.ClassificacaoTributaria;
import br.gov.serpro.rtc.domain.repository.ClassificacaoTributariaRepository;
import br.gov.serpro.rtc.domain.service.exception.ClassificacaoTributariaNaoEncontradaException;
import java.time.LocalDate;
import lombok.Generated;
import org.springframework.stereotype.Service;

@Service
public class ClassificacaoTributariaService {
    private final ClassificacaoTributariaRepository repository;

    public ClassificacaoTributaria buscarClassificacaoTributariaCbsIbs(String codigo, LocalDate data) {
        return (ClassificacaoTributaria)this.repository.buscarClassificacaoTributariaCbsIbs(codigo, data).orElseThrow(() -> new ClassificacaoTributariaNaoEncontradaException(codigo, "CBS e IBS", data));
    }

    public ClassificacaoTributaria buscarClassificacaoTributariaImpostoSeletivo(String codigo, LocalDate data) {
        return (ClassificacaoTributaria)this.repository.buscarClassificacaoTributariaImpostoSeletivo(codigo, data).orElseThrow(() -> new ClassificacaoTributariaNaoEncontradaException(codigo, "Imposto Seletivo", data));
    }

    @Generated
    public ClassificacaoTributariaService(ClassificacaoTributariaRepository repository) {
        this.repository = repository;
    }
}

