/*
 * Decompiled with CFR 0.152.
 */
package br.gov.serpro.rtc.domain.service;

import br.gov.serpro.rtc.api.model.output.CbsIbsOutput;
import br.gov.serpro.rtc.api.model.roc.ImpostoSeletivo;
import br.gov.serpro.rtc.domain.model.entity.FundamentacaoClassificacao;
import br.gov.serpro.rtc.domain.model.entity.TratamentoClassificacao;
import br.gov.serpro.rtc.domain.service.FundamentacaoClassificacaoService;
import br.gov.serpro.rtc.domain.service.token.TokenizerService;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.Map;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;

@Service
public class MemoriaCalculoService {
    private final TokenizerService tokenizerService;
    private final FundamentacaoClassificacaoService fundamentacaoClassificacaoService;

    public String gerarMemoriaCalculoCbsIbs(TratamentoClassificacao tratamentoClassificacao, CbsIbsOutput tributo, BigDecimal quantidade, String unidade, LocalDate data) {
        FundamentacaoClassificacao fundamentacaoClassificacao = this.fundamentacaoClassificacaoService.buscar(tratamentoClassificacao.getClassificacaoTributaria().getId(), data);
        String norma = fundamentacaoClassificacao.getFundamentacaoLegal().getTextoCurto();
        String tratamento = tratamentoClassificacao.getTratamentoTributario().getDescricao();
        String baseCalculo = tributo.getBaseCalculo().toString();
        String aliquotaAdValorem = tributo.getAliquota().toString();
        String aliquotaAdRem = null;
        aliquotaAdRem = tributo.getGrupoMonofasia() != null && tributo.getGrupoMonofasia().getTributoMonofasico() != null && tributo.getGrupoMonofasia().getTributoMonofasico().getAliquotaAdRem() != null ? tributo.getGrupoMonofasia().getTributoMonofasico().getAliquotaAdRem().toString() : "0";
        String percentualReducao = null;
        percentualReducao = tributo.getGrupoReducao() != null && tributo.getGrupoReducao().getPRedAliq() != null ? tributo.getGrupoReducao().getPRedAliq().toString() : "0";
        String aliquotaDesoneracao = null;
        String montanteDesoneracao = null;
        String percentualDiferimento = null;
        String valorDiferimento = null;
        if (tributo.getGrupoDiferimento() != null && tributo.getGrupoDiferimento().getPDif() != null && tributo.getGrupoDiferimento().getVDif() != null) {
            percentualDiferimento = tributo.getGrupoDiferimento().getPDif().toString();
            valorDiferimento = tributo.getGrupoDiferimento().getVDif().toString();
        } else {
            percentualDiferimento = "0";
            valorDiferimento = "0";
        }
        Map valores = Map.ofEntries(Map.entry("norma", StringUtils.defaultString((String)norma)), Map.entry("tratamento", StringUtils.defaultString((String)tratamento)), Map.entry("base_calculo", StringUtils.defaultString((String)baseCalculo)), Map.entry("aliquota_ad_valorem", StringUtils.defaultString((String)aliquotaAdValorem)), Map.entry("aliquota_ad_rem", StringUtils.defaultString((String)aliquotaAdRem)), Map.entry("quantidade", StringUtils.defaultString((String)quantidade.toString())), Map.entry("unidade", StringUtils.defaultString((String)unidade)), Map.entry("percentual_reducao", StringUtils.defaultString((String)percentualReducao)), Map.entry("percentual_diferimento", StringUtils.defaultString((String)percentualDiferimento)), Map.entry("valor_diferimento", StringUtils.defaultString((String)valorDiferimento)), Map.entry("aliquota_desoneracao", StringUtils.defaultString(aliquotaDesoneracao)), Map.entry("montante_desoneracao", StringUtils.defaultString(montanteDesoneracao)));
        String texto = fundamentacaoClassificacao.getClassificacaoTributaria().getMemoriaCalculo();
        if (StringUtils.isBlank((CharSequence)texto)) {
            return "Texto de mem\u00f3ria de c\u00e1lculo n\u00e3o encontrado";
        }
        return this.tokenizerService.substituirPlaceholders(texto, valores);
    }

    public String gerarMemoriaCalculoImpostoSeletivo(TratamentoClassificacao tratamentoClassificacao, ImpostoSeletivo tributo, BigDecimal quantidade, String unidade, LocalDate data) {
        FundamentacaoClassificacao fundamentacaoClassificacao = this.fundamentacaoClassificacaoService.buscar(tratamentoClassificacao.getClassificacaoTributaria().getId(), data);
        String norma = fundamentacaoClassificacao.getFundamentacaoLegal().getTextoCurto();
        String tratamento = tratamentoClassificacao.getTratamentoTributario().getDescricao();
        String baseCalculo = tributo.getVBCIS().toString();
        String aliquotaAdValorem = tributo.getPIS() != null ? tributo.getPIS().toString() : null;
        String aliquotaAdRem = tributo.getPISEspec() != null ? tributo.getPISEspec().toString() : null;
        Map valores = Map.ofEntries(Map.entry("norma", StringUtils.defaultString((String)norma)), Map.entry("tratamento", StringUtils.defaultString((String)tratamento)), Map.entry("base_calculo", StringUtils.defaultString((String)baseCalculo)), Map.entry("aliquota_ad_valorem", StringUtils.defaultString((String)aliquotaAdValorem)), Map.entry("aliquota_ad_rem", StringUtils.defaultString((String)aliquotaAdRem)), Map.entry("quantidade", StringUtils.defaultString((String)quantidade.toString())), Map.entry("unidade", StringUtils.defaultString((String)unidade)));
        String texto = fundamentacaoClassificacao.getClassificacaoTributaria().getMemoriaCalculo();
        if (StringUtils.isBlank((CharSequence)texto)) {
            return "Texto de mem\u00f3ria de c\u00e1lculo n\u00e3o encontrado";
        }
        return this.tokenizerService.substituirPlaceholders(texto, valores);
    }

    @Generated
    public MemoriaCalculoService(TokenizerService tokenizerService, FundamentacaoClassificacaoService fundamentacaoClassificacaoService) {
        this.tokenizerService = tokenizerService;
        this.fundamentacaoClassificacaoService = fundamentacaoClassificacaoService;
    }
}

