/*
 * Decompiled with CFR 0.152.
 */
package br.gov.serpro.rtc.domain.service;

import br.gov.serpro.rtc.domain.model.entity.Municipio;
import br.gov.serpro.rtc.domain.repository.MunicipioRepository;
import br.gov.serpro.rtc.domain.service.exception.MunicipioNaoEncontradoException;
import br.gov.serpro.rtc.domain.service.exception.MunicipioNaoPertencenteException;
import java.util.List;
import lombok.Generated;
import org.springframework.stereotype.Service;

@Service
public class MunicipioService {
    private final MunicipioRepository repository;

    public List<Municipio> consultarTodosPorSiglaUf(String uf) {
        return this.repository.consultarTodosPorSiglaUf(uf);
    }

    public void validarMunicipio(Long codigoMunicipio, String siglaUf) {
        int resultado = this.repository.validarMunicipio(codigoMunicipio, siglaUf);
        if (resultado == 1) {
            throw new MunicipioNaoEncontradoException(codigoMunicipio);
        }
        if (resultado == 2) {
            throw new MunicipioNaoPertencenteException(codigoMunicipio, siglaUf);
        }
    }

    @Generated
    public MunicipioService(MunicipioRepository repository) {
        this.repository = repository;
    }
}

