/*
 * Decompiled with CFR 0.152.
 */
package br.gov.serpro.rtc.domain.service;

import br.gov.serpro.rtc.domain.repository.NbsAplicavelRepository;
import br.gov.serpro.rtc.domain.service.exception.NbsCompletoNaoInformadoException;
import br.gov.serpro.rtc.domain.service.exception.NbsNaoVinculadaException;
import java.time.LocalDate;
import java.util.List;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;

@Service
public class NbsAplicavelService {
    private final NbsAplicavelRepository repository;

    public List<Object[]> temNbsAplicavel(String nbs, Long idClassificacaoTributaria, LocalDate data) {
        return this.repository.temNbsAplicavel(nbs, idClassificacaoTributaria, data);
    }

    public List<Object[]> temExcecaoNbsAplicavel(String nbs, Long idClassificacaoTributaria, LocalDate data) {
        return this.repository.temExcecaoNbsAplicavel(nbs, idClassificacaoTributaria, data);
    }

    public List<Object[]> temNbsAplicavelSemExcecao(String nbs, Long idClassificacaoTributaria, LocalDate data) {
        return this.repository.temNbsAplicavelSemExcecao(nbs, idClassificacaoTributaria, data);
    }

    public Integer tem(String nbs, Long idClassificacaoTributaria, String codigoClassificacaoTributaria, LocalDate data) {
        return this.repository.tem(nbs, idClassificacaoTributaria, data);
    }

    public void validarNbsAplicavel(String nbs, Long idClassificacaoTributaria, String codigoClassificacaoTributaria, LocalDate data) {
        boolean temClassificacaoTributaria;
        boolean possuiNbsCompleto = StringUtils.length((CharSequence)nbs) == 9;
        boolean bl = temClassificacaoTributaria = this.tem(nbs, idClassificacaoTributaria, codigoClassificacaoTributaria, data) == 1;
        if (temClassificacaoTributaria && !possuiNbsCompleto) {
            throw new NbsCompletoNaoInformadoException();
        }
        if (possuiNbsCompleto) {
            List results = this.temNbsAplicavel(nbs, idClassificacaoTributaria, data);
            List results1 = this.temExcecaoNbsAplicavel(nbs, idClassificacaoTributaria, data);
            List results2 = this.temNbsAplicavelSemExcecao(nbs, idClassificacaoTributaria, data);
            if (!results.isEmpty() && !results1.isEmpty() && results2.isEmpty()) {
                throw new NbsNaoVinculadaException(nbs, codigoClassificacaoTributaria, "CBS e IBS");
            }
            if (temClassificacaoTributaria && results.isEmpty() && results1.isEmpty() && results2.isEmpty()) {
                throw new NbsNaoVinculadaException(nbs, codigoClassificacaoTributaria, "CBS e IBS");
            }
        }
    }

    @Generated
    public NbsAplicavelService(NbsAplicavelRepository repository) {
        this.repository = repository;
    }
}

