/*
 * Decompiled with CFR 0.152.
 */
package br.gov.serpro.rtc.domain.service;

import br.gov.serpro.rtc.domain.repository.NcmAplicavelRepository;
import br.gov.serpro.rtc.domain.service.exception.NcmCompletoNaoInformadoException;
import br.gov.serpro.rtc.domain.service.exception.NcmNaoVinculadaException;
import java.time.LocalDate;
import java.util.List;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;

@Service
public class NcmAplicavelService {
    private final NcmAplicavelRepository repository;

    public List<Object[]> temNcmAplicavel(String ncm, Long idClassificacaoTributaria, LocalDate data) {
        return this.repository.temNcmAplicavel(ncm, idClassificacaoTributaria, data);
    }

    public List<Object[]> temExcecaoNcmAplicavel(String ncm, Long idClassificacaoTributaria, LocalDate data) {
        return this.repository.temExcecaoNcmAplicavel(ncm, idClassificacaoTributaria, data);
    }

    public List<Object[]> temNcmAplicavelSemExcecao(String ncm, Long idClassificacaoTributaria, LocalDate data) {
        return this.repository.temNcmAplicavelSemExcecao(ncm, idClassificacaoTributaria, data);
    }

    public Integer tem(String ncm, Long idClassificacaoTributaria, String codigoClassificacaoTributaria, LocalDate data) {
        return this.repository.tem(ncm, idClassificacaoTributaria, data);
    }

    public void validarNcmAplicavel(String ncm, Long idClassificacaoTributaria, String codigoClassificacaoTributaria, LocalDate data) {
        boolean temClassificacaoTributaria;
        boolean possuiNcmCompleto = StringUtils.length((CharSequence)ncm) == 8;
        boolean bl = temClassificacaoTributaria = this.tem(ncm, idClassificacaoTributaria, codigoClassificacaoTributaria, data) == 1;
        if (temClassificacaoTributaria && !possuiNcmCompleto) {
            throw new NcmCompletoNaoInformadoException();
        }
        if (possuiNcmCompleto) {
            List results = this.temNcmAplicavel(ncm, idClassificacaoTributaria, data);
            List results1 = this.temExcecaoNcmAplicavel(ncm, idClassificacaoTributaria, data);
            List results2 = this.temNcmAplicavelSemExcecao(ncm, idClassificacaoTributaria, data);
            if (!results.isEmpty() && !results1.isEmpty() && results2.isEmpty()) {
                throw new NcmNaoVinculadaException(ncm, codigoClassificacaoTributaria, "CBS e IBS");
            }
            if (temClassificacaoTributaria && results.isEmpty() && results1.isEmpty() && results2.isEmpty()) {
                throw new NcmNaoVinculadaException(ncm, codigoClassificacaoTributaria, "CBS e IBS");
            }
        }
    }

    @Generated
    public NcmAplicavelService(NcmAplicavelRepository repository) {
        this.repository = repository;
    }
}

