/*
 * Decompiled with CFR 0.152.
 */
package br.gov.serpro.rtc.domain.service;

import br.gov.serpro.rtc.domain.model.entity.Uf;
import br.gov.serpro.rtc.domain.repository.UfRepository;
import br.gov.serpro.rtc.domain.service.exception.UfNaoEncontradaException;
import java.util.List;
import lombok.Generated;
import org.springframework.stereotype.Service;

@Service
public class UfService {
    private final UfRepository ufRepository;

    public Uf buscar(String sigla) {
        return (Uf)this.ufRepository.consultarPorSigla(sigla).orElseThrow(() -> new UfNaoEncontradaException(sigla));
    }

    public List<Uf> consultarTodos() {
        return this.ufRepository.findAll();
    }

    public void validarUf(String sigla) {
        if (!this.ufRepository.existeUf(sigla)) {
            throw new UfNaoEncontradaException(sigla);
        }
    }

    @Generated
    public UfService(UfRepository ufRepository) {
        this.ufRepository = ufRepository;
    }
}

