/*
 * Decompiled with CFR 0.152.
 */
package br.gov.serpro.rtc.domain.service.calculotributo;

import br.gov.serpro.rtc.domain.service.calculotributo.AvaliadorExpressaoAritmetica;
import jakarta.annotation.PostConstruct;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Map;
import org.apache.commons.jexl3.JexlBuilder;
import org.apache.commons.jexl3.JexlContext;
import org.apache.commons.jexl3.JexlEngine;
import org.apache.commons.jexl3.JexlExpression;
import org.apache.commons.jexl3.introspection.JexlSandbox;
import org.springframework.stereotype.Service;
import org.springframework.util.NumberUtils;

@Service
public class AvaliadorExpressaoAritmetica {
    private JexlEngine expressionEngine;

    @PostConstruct
    private void postConstruct() {
        this.expressionEngine = new JexlBuilder().sandbox(new JexlSandbox()).strict(true).cache(512).cacheThreshold(1024).create();
    }

    public BigDecimal evaluate(String expression, Map<String, BigDecimal> variables, int scale) {
        JexlExpression jexp = this.expressionEngine.createExpression(expression);
        Object evaluate = jexp.evaluate((JexlContext)new MapContextBigDecimal(this, variables));
        if (evaluate instanceof Number) {
            Number n = (Number)evaluate;
            BigDecimal result = (BigDecimal)NumberUtils.convertNumberToTargetClass((Number)n, BigDecimal.class);
            return result.setScale(scale, RoundingMode.HALF_UP);
        }
        throw new NumberFormatException("Erro ao avaliar express\u00e3o: " + String.valueOf(evaluate));
    }
}

