/*
 * Decompiled with CFR 0.152.
 */
package br.gov.serpro.rtc.domain.service.calculotributo;

import br.gov.serpro.rtc.api.model.input.ItemOperacaoInput;
import br.gov.serpro.rtc.api.model.output.CbsIbsOutput;
import br.gov.serpro.rtc.api.model.output.GrupoEtapaMonofasiaOutput;
import br.gov.serpro.rtc.api.model.output.GrupoMonofasiaOutput;
import br.gov.serpro.rtc.api.model.output.TributacaoRegularOutput;
import br.gov.serpro.rtc.api.model.roc.Diferimento;
import br.gov.serpro.rtc.api.model.roc.ReducaoAliquota;
import br.gov.serpro.rtc.core.util.CalculadoraUtils;
import br.gov.serpro.rtc.domain.model.entity.AliquotaPadrao;
import br.gov.serpro.rtc.domain.model.entity.AliquotaReferencia;
import br.gov.serpro.rtc.domain.model.entity.ClassificacaoTributaria;
import br.gov.serpro.rtc.domain.model.entity.PercentualReducao;
import br.gov.serpro.rtc.domain.model.entity.TratamentoClassificacao;
import br.gov.serpro.rtc.domain.model.entity.TratamentoTributario;
import br.gov.serpro.rtc.domain.service.AliquotaAdRemProdutoService;
import br.gov.serpro.rtc.domain.service.AliquotaPadraoService;
import br.gov.serpro.rtc.domain.service.AliquotaReferenciaService;
import br.gov.serpro.rtc.domain.service.PercentualReducaoService;
import br.gov.serpro.rtc.domain.service.calculotributo.AvaliadorExpressaoAritmetica;
import br.gov.serpro.rtc.domain.service.calculotributo.domain.VariavelExpressao;
import br.gov.serpro.rtc.domain.service.exception.AliquotaAdRemNaoEncontradaException;
import br.gov.serpro.rtc.domain.service.exception.ErroFaltaImplementacaoException;
import br.gov.serpro.rtc.domain.service.exception.TipoAliquotaDesconhecidoException;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.time.LocalDate;
import java.util.Map;
import java.util.Objects;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;

/*
 * Exception performing whole class analysis ignored.
 */
@Service
public class CalculoCbsIbsService {
    private final PercentualReducaoService percentualReducaoService;
    private final AliquotaReferenciaService aliquotaReferenciaService;
    private final AliquotaPadraoService aliquotaPadraoService;
    private final AliquotaAdRemProdutoService aliquotaAdRemProdutoService;
    private final AvaliadorExpressaoAritmetica avaliador;

    public CbsIbsOutput calcularCbsIbs(Long idTributo, Long codigoUf, Long codigoMunicipio, ItemOperacaoInput item, TratamentoClassificacao tratamentoClassificacao, BigDecimal impostoSeletivoCalculado, Boolean temDesoneracao, LocalDate data) {
        Map variaveis2;
        String cst = null;
        String cClassTrib = null;
        TratamentoTributario tratamentoTributario = tratamentoClassificacao.getTratamentoTributario();
        ClassificacaoTributaria classificacaoTributaria = tratamentoClassificacao.getClassificacaoTributaria();
        if (temDesoneracao.booleanValue()) {
            cst = item.getTributacaoRegular().getCst();
            cClassTrib = item.getTributacaoRegular().getCClassTrib();
        }
        String expressaoAliquota = tratamentoTributario.getExpressaoAliquota();
        String expressaoBaseCalculo = tratamentoTributario.getExpressaoBaseCalculo();
        String expressaoAliquotaEfetiva = tratamentoTributario.getExpressaoAliquotaEfetiva();
        String expressaoTributoCalculado = tratamentoTributario.getExpressaoTributoCalculado();
        String expressaoTributoDevido = tratamentoTributario.getExpressaoTributoDevido();
        String expressaoPercentualDiferimento = tratamentoTributario.getExpressaoPercentualDiferimento();
        String expressaoValorDiferimento = tratamentoTributario.getExpressaoValorDiferimento();
        boolean possuiAjuste = tratamentoTributario.isInPossuiAjuste();
        if (possuiAjuste) {
            throw new ErroFaltaImplementacaoException(tratamentoClassificacao.getClassificacaoTributaria().getCodigo());
        }
        boolean possuiPercentualReducao = tratamentoTributario.isInPossuiPercentualReducao();
        BigDecimal valorPercentualReducao = null;
        BigDecimal valorAjuste = null;
        BigDecimal valorRedutor = null;
        BigDecimal baseCalculoInformada = item.getBaseCalculo();
        BigDecimal quantidade = item.getQuantidade();
        BigDecimal impostoSeletivoInformado = null;
        if (item.getImpostoSeletivo() != null && impostoSeletivoCalculado.compareTo(BigDecimal.ZERO) != 0) {
            impostoSeletivoInformado = item.getImpostoSeletivo().getValorImpostoSeletivoInformado();
        }
        BigDecimal valorAliquotaPadraoOuReferencia = null;
        BigDecimal valorAliquotaReferencia = null;
        BigDecimal valorAliquotaAdValorem = null;
        BigDecimal valorAliquotaAdRem = null;
        BigDecimal valorAliquota = null;
        BigDecimal resultadoAliquota = null;
        BigDecimal resultadoAliquotaEfetiva = null;
        BigDecimal resultadoBaseCalculo = null;
        BigDecimal resultadoTributoCalculado = null;
        BigDecimal resultadoTributoDevido = null;
        BigDecimal resultadoPercentualDiferimento = null;
        BigDecimal resultadoValorDiferimento = null;
        if (possuiPercentualReducao) {
            PercentualReducao percentualReducao = this.percentualReducaoService.buscar(classificacaoTributaria.getId(), idTributo, data);
            valorPercentualReducao = percentualReducao.getValor().divide(CalculadoraUtils.CEM).setScale(8, RoundingMode.HALF_UP);
        }
        String tipoAliquota = classificacaoTributaria.getTipoAliquota();
        boolean aliquotaDivididaPorCem = false;
        switch (tipoAliquota) {
            case "Padr\u00e3o": {
                valorAliquota = this.buscarAliquotaPadrao(idTributo, codigoUf, codigoMunicipio, data);
                aliquotaDivididaPorCem = true;
                break;
            }
            case "Refer\u00eancia": {
                valorAliquota = this.buscarAliquotaReferencia(idTributo, data);
                aliquotaDivididaPorCem = true;
                break;
            }
            case "Ad Rem (por NCM)": {
                valorAliquotaAdRem = valorAliquota = this.buscarAliquotaAdRem(item.getNcm(), idTributo, data);
                break;
            }
            case "Ad Valorem (por NCM ou NBS)": {
                valorAliquota = valorAliquotaAdValorem;
                break;
            }
            case "Al\u00edquotas Combinadas (Ad Valorem e Ad Rem)": {
                break;
            }
            case "Al\u00edquota Zero": {
                valorAliquota = BigDecimal.ZERO;
                break;
            }
            default: {
                throw new TipoAliquotaDesconhecidoException(tipoAliquota, cClassTrib, cst);
            }
        }
        if (StringUtils.isNotBlank((CharSequence)expressaoAliquota)) {
            Map variaveis0 = Map.ofEntries(CalculoCbsIbsService.entry((VariavelExpressao)VariavelExpressao.ALIQUOTA, (BigDecimal)valorAliquota), CalculoCbsIbsService.entry((VariavelExpressao)VariavelExpressao.QUANTIDADE, (BigDecimal)quantidade), CalculoCbsIbsService.entry((VariavelExpressao)VariavelExpressao.PERCENTUAL_REDUCAO, (BigDecimal)valorPercentualReducao), CalculoCbsIbsService.entry((VariavelExpressao)VariavelExpressao.ALIQUOTA_PADRAO_OU_REFERENCIA, valorAliquotaPadraoOuReferencia), CalculoCbsIbsService.entry((VariavelExpressao)VariavelExpressao.ALIQUOTA_REFERENCIA, valorAliquotaReferencia), CalculoCbsIbsService.entry((VariavelExpressao)VariavelExpressao.ALIQUOTA_AD_VALOREM, (BigDecimal)valorAliquotaAdValorem), CalculoCbsIbsService.entry((VariavelExpressao)VariavelExpressao.ALIQUOTA_AD_REM, (BigDecimal)valorAliquotaAdRem), CalculoCbsIbsService.entry((VariavelExpressao)VariavelExpressao.AJUSTE, valorAjuste), CalculoCbsIbsService.entry((VariavelExpressao)VariavelExpressao.REDUTOR, valorRedutor));
            resultadoAliquota = this.avaliador.evaluate(expressaoAliquota, variaveis0, 4);
        }
        if (StringUtils.isNotBlank((CharSequence)expressaoAliquotaEfetiva)) {
            Map variaveis1 = Map.ofEntries(CalculoCbsIbsService.entry((VariavelExpressao)VariavelExpressao.QUANTIDADE, (BigDecimal)quantidade), CalculoCbsIbsService.entry((VariavelExpressao)VariavelExpressao.ALIQUOTA, resultadoAliquota), CalculoCbsIbsService.entry((VariavelExpressao)VariavelExpressao.PERCENTUAL_REDUCAO, (BigDecimal)valorPercentualReducao), CalculoCbsIbsService.entry((VariavelExpressao)VariavelExpressao.ALIQUOTA_PADRAO_OU_REFERENCIA, valorAliquotaPadraoOuReferencia), CalculoCbsIbsService.entry((VariavelExpressao)VariavelExpressao.ALIQUOTA_REFERENCIA, valorAliquotaReferencia), CalculoCbsIbsService.entry((VariavelExpressao)VariavelExpressao.ALIQUOTA_AD_VALOREM, (BigDecimal)valorAliquotaAdValorem), CalculoCbsIbsService.entry((VariavelExpressao)VariavelExpressao.ALIQUOTA_AD_REM, (BigDecimal)valorAliquotaAdRem), CalculoCbsIbsService.entry((VariavelExpressao)VariavelExpressao.AJUSTE, valorAjuste), CalculoCbsIbsService.entry((VariavelExpressao)VariavelExpressao.REDUTOR, valorRedutor));
            resultadoAliquotaEfetiva = this.avaliador.evaluate(expressaoAliquotaEfetiva, variaveis1, 4);
        }
        if ((resultadoBaseCalculo = this.avaliador.evaluate(expressaoBaseCalculo, variaveis2 = Map.ofEntries(CalculoCbsIbsService.entry((VariavelExpressao)VariavelExpressao.QUANTIDADE, (BigDecimal)quantidade), CalculoCbsIbsService.entry((VariavelExpressao)VariavelExpressao.ALIQUOTA, resultadoAliquota), CalculoCbsIbsService.entry((VariavelExpressao)VariavelExpressao.ALIQUOTA_EFETIVA, resultadoAliquotaEfetiva), CalculoCbsIbsService.entry((VariavelExpressao)VariavelExpressao.IMPOSTO_SELETIVO_INFORMADO, (BigDecimal)impostoSeletivoInformado), CalculoCbsIbsService.entry((VariavelExpressao)VariavelExpressao.BASE_CALCULO_INFORMADA, (BigDecimal)baseCalculoInformada), CalculoCbsIbsService.entry((VariavelExpressao)VariavelExpressao.IMPOSTO_SELETIVO_CALCULADO, (BigDecimal)impostoSeletivoCalculado), CalculoCbsIbsService.entry((VariavelExpressao)VariavelExpressao.PERCENTUAL_REDUCAO, (BigDecimal)valorPercentualReducao), CalculoCbsIbsService.entry((VariavelExpressao)VariavelExpressao.ALIQUOTA_PADRAO_OU_REFERENCIA, valorAliquotaPadraoOuReferencia), CalculoCbsIbsService.entry((VariavelExpressao)VariavelExpressao.ALIQUOTA_REFERENCIA, valorAliquotaReferencia), CalculoCbsIbsService.entry((VariavelExpressao)VariavelExpressao.ALIQUOTA_AD_VALOREM, (BigDecimal)valorAliquotaAdValorem), CalculoCbsIbsService.entry((VariavelExpressao)VariavelExpressao.ALIQUOTA_AD_REM, (BigDecimal)valorAliquotaAdRem), CalculoCbsIbsService.entry((VariavelExpressao)VariavelExpressao.AJUSTE, valorAjuste), CalculoCbsIbsService.entry((VariavelExpressao)VariavelExpressao.REDUTOR, valorRedutor)), 2)).compareTo(BigDecimal.ZERO) < 0) {
            resultadoBaseCalculo = BigDecimal.ZERO;
        }
        Map variaveis3 = Map.ofEntries(CalculoCbsIbsService.entry((VariavelExpressao)VariavelExpressao.QUANTIDADE, (BigDecimal)quantidade), CalculoCbsIbsService.entry((VariavelExpressao)VariavelExpressao.BASE_CALCULO, (BigDecimal)resultadoBaseCalculo), CalculoCbsIbsService.entry((VariavelExpressao)VariavelExpressao.ALIQUOTA, (BigDecimal)resultadoAliquota), CalculoCbsIbsService.entry((VariavelExpressao)VariavelExpressao.ALIQUOTA_EFETIVA, (BigDecimal)resultadoAliquotaEfetiva), CalculoCbsIbsService.entry((VariavelExpressao)VariavelExpressao.BASE_CALCULO_INFORMADA, (BigDecimal)baseCalculoInformada), CalculoCbsIbsService.entry((VariavelExpressao)VariavelExpressao.IMPOSTO_SELETIVO_INFORMADO, (BigDecimal)impostoSeletivoInformado), CalculoCbsIbsService.entry((VariavelExpressao)VariavelExpressao.IMPOSTO_SELETIVO_CALCULADO, (BigDecimal)impostoSeletivoCalculado), CalculoCbsIbsService.entry((VariavelExpressao)VariavelExpressao.PERCENTUAL_REDUCAO, (BigDecimal)valorPercentualReducao), CalculoCbsIbsService.entry((VariavelExpressao)VariavelExpressao.ALIQUOTA_PADRAO_OU_REFERENCIA, valorAliquotaPadraoOuReferencia), CalculoCbsIbsService.entry((VariavelExpressao)VariavelExpressao.ALIQUOTA_REFERENCIA, valorAliquotaReferencia), CalculoCbsIbsService.entry((VariavelExpressao)VariavelExpressao.ALIQUOTA_AD_VALOREM, (BigDecimal)valorAliquotaAdValorem), CalculoCbsIbsService.entry((VariavelExpressao)VariavelExpressao.ALIQUOTA_AD_REM, (BigDecimal)valorAliquotaAdRem), CalculoCbsIbsService.entry((VariavelExpressao)VariavelExpressao.AJUSTE, valorAjuste), CalculoCbsIbsService.entry((VariavelExpressao)VariavelExpressao.REDUTOR, valorRedutor));
        resultadoTributoCalculado = this.avaliador.evaluate(expressaoTributoCalculado, variaveis3, 2);
        if (StringUtils.isNotBlank((CharSequence)expressaoTributoDevido)) {
            Map variaveis4 = Map.ofEntries(CalculoCbsIbsService.entry((VariavelExpressao)VariavelExpressao.TRIBUTO_CALCULADO, (BigDecimal)resultadoTributoCalculado), CalculoCbsIbsService.entry((VariavelExpressao)VariavelExpressao.QUANTIDADE, (BigDecimal)quantidade), CalculoCbsIbsService.entry((VariavelExpressao)VariavelExpressao.BASE_CALCULO, (BigDecimal)resultadoBaseCalculo), CalculoCbsIbsService.entry((VariavelExpressao)VariavelExpressao.ALIQUOTA, (BigDecimal)resultadoAliquota), CalculoCbsIbsService.entry((VariavelExpressao)VariavelExpressao.ALIQUOTA_EFETIVA, (BigDecimal)resultadoAliquotaEfetiva), CalculoCbsIbsService.entry((VariavelExpressao)VariavelExpressao.BASE_CALCULO_INFORMADA, (BigDecimal)baseCalculoInformada), CalculoCbsIbsService.entry((VariavelExpressao)VariavelExpressao.IMPOSTO_SELETIVO_INFORMADO, (BigDecimal)impostoSeletivoInformado), CalculoCbsIbsService.entry((VariavelExpressao)VariavelExpressao.IMPOSTO_SELETIVO_CALCULADO, (BigDecimal)impostoSeletivoCalculado), CalculoCbsIbsService.entry((VariavelExpressao)VariavelExpressao.PERCENTUAL_REDUCAO, (BigDecimal)valorPercentualReducao), CalculoCbsIbsService.entry((VariavelExpressao)VariavelExpressao.ALIQUOTA_PADRAO_OU_REFERENCIA, valorAliquotaPadraoOuReferencia), CalculoCbsIbsService.entry((VariavelExpressao)VariavelExpressao.ALIQUOTA_REFERENCIA, valorAliquotaReferencia), CalculoCbsIbsService.entry((VariavelExpressao)VariavelExpressao.ALIQUOTA_AD_VALOREM, (BigDecimal)valorAliquotaAdValorem), CalculoCbsIbsService.entry((VariavelExpressao)VariavelExpressao.ALIQUOTA_AD_REM, (BigDecimal)valorAliquotaAdRem), CalculoCbsIbsService.entry((VariavelExpressao)VariavelExpressao.AJUSTE, valorAjuste), CalculoCbsIbsService.entry((VariavelExpressao)VariavelExpressao.REDUTOR, valorRedutor));
            resultadoTributoDevido = this.avaliador.evaluate(expressaoTributoDevido, variaveis4, 2);
        }
        if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{expressaoPercentualDiferimento, expressaoValorDiferimento})) {
            Map variaveis5 = Map.ofEntries(CalculoCbsIbsService.entry((VariavelExpressao)VariavelExpressao.TRIBUTO_CALCULADO, (BigDecimal)resultadoTributoCalculado), CalculoCbsIbsService.entry((VariavelExpressao)VariavelExpressao.QUANTIDADE, (BigDecimal)quantidade), CalculoCbsIbsService.entry((VariavelExpressao)VariavelExpressao.BASE_CALCULO, (BigDecimal)resultadoBaseCalculo), CalculoCbsIbsService.entry((VariavelExpressao)VariavelExpressao.ALIQUOTA, (BigDecimal)resultadoAliquota), CalculoCbsIbsService.entry((VariavelExpressao)VariavelExpressao.ALIQUOTA_EFETIVA, (BigDecimal)resultadoAliquotaEfetiva), CalculoCbsIbsService.entry((VariavelExpressao)VariavelExpressao.BASE_CALCULO_INFORMADA, (BigDecimal)baseCalculoInformada), CalculoCbsIbsService.entry((VariavelExpressao)VariavelExpressao.IMPOSTO_SELETIVO_INFORMADO, (BigDecimal)impostoSeletivoInformado), CalculoCbsIbsService.entry((VariavelExpressao)VariavelExpressao.IMPOSTO_SELETIVO_CALCULADO, (BigDecimal)impostoSeletivoCalculado), CalculoCbsIbsService.entry((VariavelExpressao)VariavelExpressao.PERCENTUAL_REDUCAO, (BigDecimal)valorPercentualReducao), CalculoCbsIbsService.entry((VariavelExpressao)VariavelExpressao.ALIQUOTA_PADRAO_OU_REFERENCIA, valorAliquotaPadraoOuReferencia), CalculoCbsIbsService.entry((VariavelExpressao)VariavelExpressao.ALIQUOTA_REFERENCIA, valorAliquotaReferencia), CalculoCbsIbsService.entry((VariavelExpressao)VariavelExpressao.ALIQUOTA_AD_VALOREM, (BigDecimal)valorAliquotaAdValorem), CalculoCbsIbsService.entry((VariavelExpressao)VariavelExpressao.ALIQUOTA_AD_REM, (BigDecimal)valorAliquotaAdRem), CalculoCbsIbsService.entry((VariavelExpressao)VariavelExpressao.AJUSTE, valorAjuste), CalculoCbsIbsService.entry((VariavelExpressao)VariavelExpressao.REDUTOR, valorRedutor));
            resultadoPercentualDiferimento = this.avaliador.evaluate(expressaoPercentualDiferimento, variaveis5, 4);
            Map variaveis6 = Map.ofEntries(CalculoCbsIbsService.entry((VariavelExpressao)VariavelExpressao.PERCENTUAL_DIFERIMENTO, (BigDecimal)resultadoPercentualDiferimento), CalculoCbsIbsService.entry((VariavelExpressao)VariavelExpressao.TRIBUTO_CALCULADO, (BigDecimal)resultadoTributoCalculado), CalculoCbsIbsService.entry((VariavelExpressao)VariavelExpressao.QUANTIDADE, (BigDecimal)quantidade), CalculoCbsIbsService.entry((VariavelExpressao)VariavelExpressao.BASE_CALCULO, (BigDecimal)resultadoBaseCalculo), CalculoCbsIbsService.entry((VariavelExpressao)VariavelExpressao.ALIQUOTA, (BigDecimal)resultadoAliquota), CalculoCbsIbsService.entry((VariavelExpressao)VariavelExpressao.ALIQUOTA_EFETIVA, (BigDecimal)resultadoAliquotaEfetiva), CalculoCbsIbsService.entry((VariavelExpressao)VariavelExpressao.BASE_CALCULO_INFORMADA, (BigDecimal)baseCalculoInformada), CalculoCbsIbsService.entry((VariavelExpressao)VariavelExpressao.IMPOSTO_SELETIVO_INFORMADO, (BigDecimal)impostoSeletivoInformado), CalculoCbsIbsService.entry((VariavelExpressao)VariavelExpressao.IMPOSTO_SELETIVO_CALCULADO, (BigDecimal)impostoSeletivoCalculado), CalculoCbsIbsService.entry((VariavelExpressao)VariavelExpressao.PERCENTUAL_REDUCAO, (BigDecimal)valorPercentualReducao), CalculoCbsIbsService.entry((VariavelExpressao)VariavelExpressao.ALIQUOTA_PADRAO_OU_REFERENCIA, valorAliquotaPadraoOuReferencia), CalculoCbsIbsService.entry((VariavelExpressao)VariavelExpressao.ALIQUOTA_REFERENCIA, valorAliquotaReferencia), CalculoCbsIbsService.entry((VariavelExpressao)VariavelExpressao.ALIQUOTA_AD_VALOREM, (BigDecimal)valorAliquotaAdValorem), CalculoCbsIbsService.entry((VariavelExpressao)VariavelExpressao.ALIQUOTA_AD_REM, (BigDecimal)valorAliquotaAdRem), CalculoCbsIbsService.entry((VariavelExpressao)VariavelExpressao.AJUSTE, valorAjuste), CalculoCbsIbsService.entry((VariavelExpressao)VariavelExpressao.REDUTOR, valorRedutor));
            resultadoValorDiferimento = this.avaliador.evaluate(expressaoValorDiferimento, variaveis6, 2);
        }
        return CbsIbsOutput.builder().grupoReducao(temDesoneracao != false ? null : CalculoCbsIbsService.obterGrupoReducao((BigDecimal)resultadoAliquotaEfetiva, (BigDecimal)valorPercentualReducao, (boolean)aliquotaDivididaPorCem)).tributacaoRegular(temDesoneracao != false ? CalculoCbsIbsService.obterGrupoDesoneracao((String)cst, (String)cClassTrib, (BigDecimal)resultadoBaseCalculo, (BigDecimal)resultadoAliquota, (BigDecimal)Objects.requireNonNullElse(valorPercentualReducao, BigDecimal.ZERO), (boolean)aliquotaDivididaPorCem, (boolean)possuiPercentualReducao) : null).grupoDiferimento(CalculoCbsIbsService.obterGrupoDiferimento(resultadoValorDiferimento, resultadoPercentualDiferimento)).grupoMonofasia(CalculoCbsIbsService.obterGrupoMonofasia((BigDecimal)quantidade, (BigDecimal)valorAliquotaAdRem, (BigDecimal)resultadoTributoCalculado)).tributoCalculado(temDesoneracao != false ? BigDecimal.ZERO : resultadoTributoCalculado).tributoDevido(temDesoneracao != false ? BigDecimal.ZERO : resultadoTributoDevido).aliquota(aliquotaDivididaPorCem && resultadoAliquota != null ? resultadoAliquota.movePointRight(2) : resultadoAliquota).baseCalculo(resultadoBaseCalculo).quantidade(quantidade).build();
    }

    private BigDecimal buscarAliquotaReferencia(Long idTributo, LocalDate data) {
        return this.aliquotaReferenciaService.buscar(idTributo, data).getValor().divide(CalculadoraUtils.CEM).setScale(8, RoundingMode.HALF_UP);
    }

    private BigDecimal buscarAliquotaPadrao(Long idTributo, Long codigoUf, Long codigoMunicipio, LocalDate data) {
        AliquotaReferencia aliquotaReferencia = this.aliquotaReferenciaService.buscar(idTributo, data);
        AliquotaPadrao aliquotaPadrao = null;
        if (idTributo == 2L) {
            aliquotaPadrao = this.aliquotaPadraoService.buscarAliquotaUniao(aliquotaReferencia, data);
        } else if (idTributo == 3L) {
            aliquotaPadrao = this.aliquotaPadraoService.buscarAliquotaUf(aliquotaReferencia, codigoUf, data);
        } else if (idTributo == 4L) {
            aliquotaPadrao = this.aliquotaPadraoService.buscarAliquotaMunicipio(aliquotaReferencia, codigoMunicipio, data);
        }
        if (aliquotaPadrao != null) {
            return aliquotaPadrao.getValorAplicavel().divide(CalculadoraUtils.CEM).setScale(8, RoundingMode.HALF_UP);
        }
        return aliquotaReferencia.getValor().divide(CalculadoraUtils.CEM).setScale(8, RoundingMode.HALF_UP);
    }

    private BigDecimal buscarAliquotaAdRem(String ncm, Long idTributo, LocalDate data) {
        BigDecimal aliquotaAdRem = this.aliquotaAdRemProdutoService.buscarAliquotaAdRem(ncm, idTributo, data);
        if (aliquotaAdRem == null) {
            throw new AliquotaAdRemNaoEncontradaException(ncm, idTributo, data);
        }
        return aliquotaAdRem;
    }

    private static ReducaoAliquota obterGrupoReducao(BigDecimal aliquotaEfetiva, BigDecimal percentualReducao, boolean aliquotaDivididaPorCem) {
        if (CalculoCbsIbsService.anyNull((Object[])new Object[]{percentualReducao, aliquotaEfetiva})) {
            return null;
        }
        return ReducaoAliquota.builder().pRedAliq(percentualReducao.movePointRight(2)).pAliqEfet(aliquotaDivididaPorCem ? aliquotaEfetiva.movePointRight(2) : aliquotaEfetiva).build();
    }

    private static TributacaoRegularOutput obterGrupoDesoneracao(String cst, String cClassTrib, BigDecimal baseCalculo, BigDecimal aliquota, BigDecimal percentualReducao, boolean aliquotaDivididaPorCem, boolean possuiPercentualReducao) {
        BigDecimal aliquotaEfetiva = aliquota;
        if (possuiPercentualReducao && percentualReducao != null) {
            BigDecimal redutor = BigDecimal.ONE.subtract(percentualReducao);
            aliquotaEfetiva = aliquota.multiply(redutor).setScale(4, RoundingMode.HALF_UP);
        }
        BigDecimal tributoDevido = baseCalculo.multiply(aliquotaEfetiva).setScale(2, RoundingMode.HALF_UP);
        return TributacaoRegularOutput.builder().cst(cst).cClassTrib(cClassTrib).baseCalculo(baseCalculo).aliquotaEfetiva(aliquotaDivididaPorCem ? aliquotaEfetiva.movePointRight(2) : aliquotaEfetiva).tributoDevido(tributoDevido).build();
    }

    private static Diferimento obterGrupoDiferimento(BigDecimal valorDiferimento, BigDecimal percentualDiferimento) {
        if (CalculoCbsIbsService.anyNull((Object[])new Object[]{valorDiferimento, percentualDiferimento})) {
            return null;
        }
        return Diferimento.builder().vDif(valorDiferimento).pDif(percentualDiferimento.movePointRight(2)).build();
    }

    private static GrupoMonofasiaOutput obterGrupoMonofasia(BigDecimal quantidade, BigDecimal aliquotaAdRem, BigDecimal valor) {
        if (CalculoCbsIbsService.anyNull((Object[])new Object[]{quantidade, aliquotaAdRem, valor})) {
            return null;
        }
        GrupoEtapaMonofasiaOutput grupoEtapaMonofasia = GrupoEtapaMonofasiaOutput.builder().quantidade(quantidade).aliquotaAdRem(aliquotaAdRem).valor(valor).build();
        return GrupoMonofasiaOutput.builder().tributoMonofasico(grupoEtapaMonofasia).build();
    }

    private static Map.Entry<String, BigDecimal> entry(VariavelExpressao c, BigDecimal v) {
        return Map.entry(c.getNome(), Objects.requireNonNullElse(v, BigDecimal.ZERO));
    }

    private static boolean anyNull(Object ... params) {
        if (params != null && params.length > 0) {
            for (Object param : params) {
                if (param != null) continue;
                return true;
            }
        }
        return false;
    }

    @Generated
    public CalculoCbsIbsService(PercentualReducaoService percentualReducaoService, AliquotaReferenciaService aliquotaReferenciaService, AliquotaPadraoService aliquotaPadraoService, AliquotaAdRemProdutoService aliquotaAdRemProdutoService, AvaliadorExpressaoAritmetica avaliador) {
        this.percentualReducaoService = percentualReducaoService;
        this.aliquotaReferenciaService = aliquotaReferenciaService;
        this.aliquotaPadraoService = aliquotaPadraoService;
        this.aliquotaAdRemProdutoService = aliquotaAdRemProdutoService;
        this.avaliador = avaliador;
    }
}

