/*
 * Decompiled with CFR 0.152.
 */
package br.gov.serpro.rtc.domain.service.calculotributo;

import br.gov.serpro.rtc.api.model.input.ItemOperacaoInput;
import br.gov.serpro.rtc.api.model.roc.ImpostoSeletivo;
import br.gov.serpro.rtc.core.util.CalculadoraUtils;
import br.gov.serpro.rtc.domain.model.entity.TratamentoClassificacao;
import br.gov.serpro.rtc.domain.model.entity.TratamentoTributario;
import br.gov.serpro.rtc.domain.service.calculotributo.AvaliadorExpressaoAritmetica;
import br.gov.serpro.rtc.domain.service.calculotributo.domain.VariavelExpressao;
import br.gov.serpro.rtc.domain.service.calculotributo.model.AliquotaImpostoSeletivoModel;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.time.LocalDate;
import java.util.Map;
import java.util.Objects;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;

/*
 * Exception performing whole class analysis ignored.
 */
@Service
public class CalculoImpostoSeletivoService {
    private final AvaliadorExpressaoAritmetica avaliador;

    public ImpostoSeletivo calcularImpostoSeletivo(Long idTributo, ItemOperacaoInput item, TratamentoClassificacao tratamentoClassificacao, AliquotaImpostoSeletivoModel aliquotaImpostoSeletivo, LocalDate data) {
        TratamentoTributario tratamentoTributario = tratamentoClassificacao.getTratamentoTributario();
        String expressaoAliquota = tratamentoTributario.getExpressaoAliquota();
        String expressaoBaseCalculo = tratamentoTributario.getExpressaoBaseCalculo();
        String expressaoAliquotaEfetiva = tratamentoTributario.getExpressaoAliquotaEfetiva();
        String expressaoTributoCalculado = tratamentoTributario.getExpressaoTributoCalculado();
        String expressaoTributoDevido = tratamentoTributario.getExpressaoTributoDevido();
        BigDecimal valorPercentualReducao = null;
        BigDecimal valorAjuste = null;
        BigDecimal valorRedutor = null;
        String cst = item.getImpostoSeletivo().getCst();
        String cClassTrib = item.getImpostoSeletivo().getCClassTrib();
        String unidade = item.getImpostoSeletivo().getUnidade();
        String memoriaCalculo = null;
        BigDecimal baseCalculoInformada = item.getImpostoSeletivo().getBaseCalculo();
        BigDecimal quantidade = item.getImpostoSeletivo().getQuantidade();
        BigDecimal impostoSeletivoInformado = item.getImpostoSeletivo().getValorImpostoSeletivoInformado();
        BigDecimal impostoSeletivoCalculado = BigDecimal.ZERO;
        BigDecimal valorAliquotaPadraoOuReferencia = null;
        BigDecimal valorAliquotaReferencia = null;
        BigDecimal valorAliquotaAdValorem = null;
        BigDecimal valorAliquotaAdRem = null;
        Object valorAliquota = null;
        valorAliquotaAdValorem = aliquotaImpostoSeletivo.getAliquotaAdValorem();
        if (valorAliquotaAdValorem != null) {
            valorAliquotaAdValorem = valorAliquotaAdValorem.divide(CalculadoraUtils.CEM).setScale(8, RoundingMode.HALF_UP);
        }
        valorAliquotaAdRem = aliquotaImpostoSeletivo.getAliquotaAdRem();
        BigDecimal resultadoAliquota = null;
        BigDecimal resultadoAliquotaEfetiva = null;
        BigDecimal resultadoBaseCalculo = null;
        BigDecimal resultadoTributoCalculado = null;
        BigDecimal resultadoTributoDevido = null;
        Map variaveis2 = Map.ofEntries(CalculoImpostoSeletivoService.entry((VariavelExpressao)VariavelExpressao.QUANTIDADE, (BigDecimal)quantidade), CalculoImpostoSeletivoService.entry((VariavelExpressao)VariavelExpressao.ALIQUOTA, resultadoAliquota), CalculoImpostoSeletivoService.entry((VariavelExpressao)VariavelExpressao.ALIQUOTA_EFETIVA, resultadoAliquotaEfetiva), CalculoImpostoSeletivoService.entry((VariavelExpressao)VariavelExpressao.BASE_CALCULO_INFORMADA, (BigDecimal)baseCalculoInformada), CalculoImpostoSeletivoService.entry((VariavelExpressao)VariavelExpressao.IMPOSTO_SELETIVO_INFORMADO, (BigDecimal)impostoSeletivoInformado), CalculoImpostoSeletivoService.entry((VariavelExpressao)VariavelExpressao.IMPOSTO_SELETIVO_CALCULADO, (BigDecimal)impostoSeletivoCalculado), CalculoImpostoSeletivoService.entry((VariavelExpressao)VariavelExpressao.PERCENTUAL_REDUCAO, valorPercentualReducao), CalculoImpostoSeletivoService.entry((VariavelExpressao)VariavelExpressao.ALIQUOTA_PADRAO_OU_REFERENCIA, valorAliquotaPadraoOuReferencia), CalculoImpostoSeletivoService.entry((VariavelExpressao)VariavelExpressao.ALIQUOTA_REFERENCIA, valorAliquotaReferencia), CalculoImpostoSeletivoService.entry((VariavelExpressao)VariavelExpressao.ALIQUOTA_AD_VALOREM, (BigDecimal)valorAliquotaAdValorem), CalculoImpostoSeletivoService.entry((VariavelExpressao)VariavelExpressao.ALIQUOTA_AD_REM, (BigDecimal)valorAliquotaAdRem), CalculoImpostoSeletivoService.entry((VariavelExpressao)VariavelExpressao.AJUSTE, valorAjuste), CalculoImpostoSeletivoService.entry((VariavelExpressao)VariavelExpressao.REDUTOR, valorRedutor));
        resultadoBaseCalculo = this.avaliador.evaluate(expressaoBaseCalculo, variaveis2, 2);
        Map variaveis3 = Map.ofEntries(CalculoImpostoSeletivoService.entry((VariavelExpressao)VariavelExpressao.QUANTIDADE, (BigDecimal)quantidade), CalculoImpostoSeletivoService.entry((VariavelExpressao)VariavelExpressao.BASE_CALCULO, (BigDecimal)resultadoBaseCalculo), CalculoImpostoSeletivoService.entry((VariavelExpressao)VariavelExpressao.ALIQUOTA, resultadoAliquota), CalculoImpostoSeletivoService.entry((VariavelExpressao)VariavelExpressao.ALIQUOTA_EFETIVA, resultadoAliquotaEfetiva), CalculoImpostoSeletivoService.entry((VariavelExpressao)VariavelExpressao.BASE_CALCULO_INFORMADA, (BigDecimal)baseCalculoInformada), CalculoImpostoSeletivoService.entry((VariavelExpressao)VariavelExpressao.IMPOSTO_SELETIVO_INFORMADO, (BigDecimal)impostoSeletivoInformado), CalculoImpostoSeletivoService.entry((VariavelExpressao)VariavelExpressao.IMPOSTO_SELETIVO_CALCULADO, (BigDecimal)impostoSeletivoCalculado), CalculoImpostoSeletivoService.entry((VariavelExpressao)VariavelExpressao.PERCENTUAL_REDUCAO, valorPercentualReducao), CalculoImpostoSeletivoService.entry((VariavelExpressao)VariavelExpressao.ALIQUOTA_PADRAO_OU_REFERENCIA, valorAliquotaPadraoOuReferencia), CalculoImpostoSeletivoService.entry((VariavelExpressao)VariavelExpressao.ALIQUOTA_REFERENCIA, valorAliquotaReferencia), CalculoImpostoSeletivoService.entry((VariavelExpressao)VariavelExpressao.ALIQUOTA_AD_VALOREM, (BigDecimal)valorAliquotaAdValorem), CalculoImpostoSeletivoService.entry((VariavelExpressao)VariavelExpressao.ALIQUOTA_AD_REM, (BigDecimal)valorAliquotaAdRem), CalculoImpostoSeletivoService.entry((VariavelExpressao)VariavelExpressao.AJUSTE, valorAjuste), CalculoImpostoSeletivoService.entry((VariavelExpressao)VariavelExpressao.REDUTOR, valorRedutor));
        resultadoTributoCalculado = this.avaliador.evaluate(expressaoTributoCalculado, variaveis3, 2);
        if (StringUtils.isNotBlank((CharSequence)expressaoTributoDevido)) {
            Map variaveis4 = Map.ofEntries(CalculoImpostoSeletivoService.entry((VariavelExpressao)VariavelExpressao.TRIBUTO_CALCULADO, (BigDecimal)resultadoTributoCalculado), CalculoImpostoSeletivoService.entry((VariavelExpressao)VariavelExpressao.QUANTIDADE, (BigDecimal)quantidade), CalculoImpostoSeletivoService.entry((VariavelExpressao)VariavelExpressao.BASE_CALCULO, (BigDecimal)resultadoBaseCalculo), CalculoImpostoSeletivoService.entry((VariavelExpressao)VariavelExpressao.ALIQUOTA, resultadoAliquota), CalculoImpostoSeletivoService.entry((VariavelExpressao)VariavelExpressao.ALIQUOTA_EFETIVA, resultadoAliquotaEfetiva), CalculoImpostoSeletivoService.entry((VariavelExpressao)VariavelExpressao.BASE_CALCULO_INFORMADA, (BigDecimal)baseCalculoInformada), CalculoImpostoSeletivoService.entry((VariavelExpressao)VariavelExpressao.IMPOSTO_SELETIVO_INFORMADO, (BigDecimal)impostoSeletivoInformado), CalculoImpostoSeletivoService.entry((VariavelExpressao)VariavelExpressao.IMPOSTO_SELETIVO_CALCULADO, (BigDecimal)impostoSeletivoCalculado), CalculoImpostoSeletivoService.entry((VariavelExpressao)VariavelExpressao.PERCENTUAL_REDUCAO, valorPercentualReducao), CalculoImpostoSeletivoService.entry((VariavelExpressao)VariavelExpressao.ALIQUOTA_PADRAO_OU_REFERENCIA, valorAliquotaPadraoOuReferencia), CalculoImpostoSeletivoService.entry((VariavelExpressao)VariavelExpressao.ALIQUOTA_REFERENCIA, valorAliquotaReferencia), CalculoImpostoSeletivoService.entry((VariavelExpressao)VariavelExpressao.ALIQUOTA_AD_VALOREM, (BigDecimal)valorAliquotaAdValorem), CalculoImpostoSeletivoService.entry((VariavelExpressao)VariavelExpressao.ALIQUOTA_AD_REM, (BigDecimal)valorAliquotaAdRem), CalculoImpostoSeletivoService.entry((VariavelExpressao)VariavelExpressao.AJUSTE, valorAjuste), CalculoImpostoSeletivoService.entry((VariavelExpressao)VariavelExpressao.REDUTOR, valorRedutor));
            resultadoTributoDevido = this.avaliador.evaluate(expressaoTributoDevido, variaveis4, 2);
        }
        return ImpostoSeletivo.builder().CSTIS(Integer.valueOf(cst)).cClassTribIS(cClassTrib).qTrib(quantidade).uTrib(unidade).vIS(resultadoTributoDevido).pIS(valorAliquotaAdValorem != null ? valorAliquotaAdValorem.movePointRight(2) : valorAliquotaAdValorem).pISEspec(valorAliquotaAdRem).vBCIS(resultadoBaseCalculo).memoriaCalculo(memoriaCalculo).build();
    }

    private static Map.Entry<String, BigDecimal> entry(VariavelExpressao c, BigDecimal v) {
        return Map.entry(c.getNome(), Objects.requireNonNullElse(v, BigDecimal.ZERO));
    }

    @Generated
    public CalculoImpostoSeletivoService(AvaliadorExpressaoAritmetica avaliador) {
        this.avaliador = avaliador;
    }
}

