/*
 * Decompiled with CFR 0.152.
 */
package br.gov.serpro.rtc.domain.service.calculotributo;

import br.gov.serpro.rtc.api.model.input.ItemOperacaoInput;
import br.gov.serpro.rtc.api.model.output.CbsIbsOutput;
import br.gov.serpro.rtc.api.model.output.GrupoDiferimentoMonofasiaOutput;
import br.gov.serpro.rtc.api.model.output.GrupoEtapaMonofasiaOutput;
import br.gov.serpro.rtc.api.model.output.GrupoMonofasiaOutput;
import br.gov.serpro.rtc.api.model.output.TributacaoRegularOutput;
import br.gov.serpro.rtc.api.model.roc.CBS;
import br.gov.serpro.rtc.api.model.roc.CreditoPresumido;
import br.gov.serpro.rtc.api.model.roc.CreditoPresumidoIBSZFM;
import br.gov.serpro.rtc.api.model.roc.DevolucaoTributos;
import br.gov.serpro.rtc.api.model.roc.GrupoIBSCBS;
import br.gov.serpro.rtc.api.model.roc.IBSCBS;
import br.gov.serpro.rtc.api.model.roc.IBSMun;
import br.gov.serpro.rtc.api.model.roc.IBSUF;
import br.gov.serpro.rtc.api.model.roc.ImpostoSeletivo;
import br.gov.serpro.rtc.api.model.roc.Monofasia;
import br.gov.serpro.rtc.api.model.roc.TransferenciaCredito;
import br.gov.serpro.rtc.api.model.roc.TributacaoCompraGovernamental;
import br.gov.serpro.rtc.api.model.roc.TributacaoRegular;
import br.gov.serpro.rtc.api.model.roc.Tributos;
import br.gov.serpro.rtc.domain.model.entity.TratamentoClassificacao;
import br.gov.serpro.rtc.domain.service.MemoriaCalculoService;
import br.gov.serpro.rtc.domain.service.calculotributo.CalculoCbsIbsService;
import br.gov.serpro.rtc.domain.service.calculotributo.CalculoImpostoSeletivoService;
import br.gov.serpro.rtc.domain.service.calculotributo.model.AliquotaImpostoSeletivoModel;
import br.gov.serpro.rtc.domain.service.calculotributo.model.OperacaoModel;
import java.math.BigDecimal;
import java.time.LocalDate;
import lombok.Generated;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

/*
 * Exception performing whole class analysis ignored.
 */
@Service
public class CalculoTributoService {
    private final CalculoCbsIbsService calculoCbsIbsService;
    private final CalculoImpostoSeletivoService calculoImpostoSeletivoService;
    private final MemoriaCalculoService memoriaCalculoService;
    @Value(value="${application.ibs.enabled}")
    private boolean calculoIbsHabilitado;

    public Tributos calcular(OperacaoModel operacao) {
        ItemOperacaoInput item = operacao.getItem();
        LocalDate data = operacao.getData().toLocalDate();
        String ncm = item.getNcm();
        String nbs = item.getNbs();
        TratamentoClassificacao tratamentoClassificacaoCbsIbs = operacao.getTratamentoClassificacao().getTratamentoClassificacaoCbsIbs();
        TratamentoClassificacao tratamentoClassificacaoImpostoSeletivo = operacao.getTratamentoClassificacao().getTratamentoClassificacaoImpostoSeletivo();
        Boolean temDesoneracao = operacao.getTratamentoClassificacao().getTemDesoneracao();
        TratamentoClassificacao tratamentoClassificacaoCbsIbsDesoneracao = null;
        if (temDesoneracao.booleanValue()) {
            tratamentoClassificacaoCbsIbsDesoneracao = operacao.getTratamentoClassificacao().getTratamentoClassificacaoCbsIbsDesoneracao();
        }
        ImpostoSeletivo impostoSeletivo = null;
        CbsIbsOutput cbs = null;
        CbsIbsOutput ibsEstadual = null;
        CbsIbsOutput ibsMunicipal = null;
        if (tratamentoClassificacaoImpostoSeletivo != null) {
            AliquotaImpostoSeletivoModel aliquotaImpostoSeletivo = operacao.getTratamentoClassificacao().getAliquotaImpostoSeletivo();
            impostoSeletivo = this.calculoImpostoSeletivoService.calcularImpostoSeletivo(Long.valueOf(1L), item, tratamentoClassificacaoImpostoSeletivo, aliquotaImpostoSeletivo, data);
        }
        if (tratamentoClassificacaoCbsIbs != null) {
            BigDecimal impostoSeletivoCalculado = impostoSeletivo != null ? impostoSeletivo.getValorImpostoSeletivo() : BigDecimal.ZERO;
            cbs = this.calculoCbsIbsService.calcularCbsIbs(Long.valueOf(2L), operacao.getCodigoUf(), operacao.getCodigoMunicipio(), item, tratamentoClassificacaoCbsIbs, impostoSeletivoCalculado, temDesoneracao, data);
            if (this.calculoIbsHabilitado || nbs != null) {
                ibsEstadual = this.calculoCbsIbsService.calcularCbsIbs(Long.valueOf(3L), operacao.getCodigoUf(), operacao.getCodigoMunicipio(), item, tratamentoClassificacaoCbsIbs, impostoSeletivoCalculado, temDesoneracao, data);
                ibsMunicipal = this.calculoCbsIbsService.calcularCbsIbs(Long.valueOf(4L), operacao.getCodigoUf(), operacao.getCodigoMunicipio(), item, tratamentoClassificacaoCbsIbs, impostoSeletivoCalculado, temDesoneracao, data);
            }
        }
        if (temDesoneracao.booleanValue() && impostoSeletivo != null) {
            impostoSeletivo.setVIS(BigDecimal.ZERO);
        }
        TratamentoClassificacao tratamentoClassificacao = null;
        tratamentoClassificacao = temDesoneracao != false ? tratamentoClassificacaoCbsIbsDesoneracao : tratamentoClassificacaoCbsIbs;
        if (impostoSeletivo != null) {
            String memoriaCalculoImpostoSeletivo = this.memoriaCalculoService.gerarMemoriaCalculoImpostoSeletivo(tratamentoClassificacaoImpostoSeletivo, impostoSeletivo, item.getImpostoSeletivo().getQuantidade(), item.getImpostoSeletivo().getUnidade(), data);
            impostoSeletivo.setMemoriaCalculo(memoriaCalculoImpostoSeletivo);
        }
        if (cbs != null) {
            String memoriaCalculoCbs = this.memoriaCalculoService.gerarMemoriaCalculoCbsIbs(tratamentoClassificacao, cbs, item.getQuantidade(), item.getUnidade(), data);
            cbs.setMemoriaCalculo(memoriaCalculoCbs);
        }
        if (this.calculoIbsHabilitado || nbs != null) {
            String memoriaCalculoIbsEstadual = this.memoriaCalculoService.gerarMemoriaCalculoCbsIbs(tratamentoClassificacao, ibsEstadual, item.getQuantidade(), item.getUnidade(), data);
            if (ibsEstadual != null) {
                ibsEstadual.setMemoriaCalculo(memoriaCalculoIbsEstadual);
            }
            String memoriaCalculoIbsMunicipal = this.memoriaCalculoService.gerarMemoriaCalculoCbsIbs(tratamentoClassificacao, ibsMunicipal, item.getQuantidade(), item.getUnidade(), data);
            if (ibsMunicipal != null) {
                ibsMunicipal.setMemoriaCalculo(memoriaCalculoIbsMunicipal);
            }
        }
        return Tributos.builder().IS(impostoSeletivo).IBSCBS(CalculoTributoService.getIBSCBS((ItemOperacaoInput)item, (CbsIbsOutput)cbs, ibsEstadual, ibsMunicipal)).build();
    }

    private static IBSCBS getIBSCBS(ItemOperacaoInput item, CbsIbsOutput cbs, CbsIbsOutput ibsEstadual, CbsIbsOutput ibsMunicipal) {
        Monofasia monofasia = CalculoTributoService.getMonofasia((CbsIbsOutput)cbs, (CbsIbsOutput)ibsEstadual, (CbsIbsOutput)ibsMunicipal);
        return IBSCBS.builder().CST(Integer.valueOf(item.getCst())).cClassTrib(item.getCClassTrib()).gIBSCBS(monofasia == null ? CalculoTributoService.getGIBSCBS((CbsIbsOutput)cbs, (CbsIbsOutput)ibsEstadual, (CbsIbsOutput)ibsMunicipal) : null).gIBSCBSMono(monofasia).gTransfCred(CalculoTributoService.getTransferenciaCredito((CbsIbsOutput)cbs, (CbsIbsOutput)ibsEstadual, (CbsIbsOutput)ibsMunicipal)).gCredPresIBSZFM(CalculoTributoService.getCreditoPresumidoIBSZFM((CbsIbsOutput)ibsEstadual, (CbsIbsOutput)ibsMunicipal)).build();
    }

    private static GrupoIBSCBS getGIBSCBS(CbsIbsOutput cbs, CbsIbsOutput ibsEstadual, CbsIbsOutput ibsMunicipal) {
        BigDecimal vBC = CalculoTributoService.getVBC((CbsIbsOutput)ibsMunicipal, (BigDecimal)CalculoTributoService.getVBC((CbsIbsOutput)ibsEstadual, (BigDecimal)CalculoTributoService.getVBC((CbsIbsOutput)cbs, null)));
        IBSUF ibsUF = CalculoTributoService.getIBSUF((CbsIbsOutput)ibsEstadual);
        IBSMun ibsMun = CalculoTributoService.getIBSMun((CbsIbsOutput)ibsMunicipal);
        TributacaoRegular tributacaoRegular = CalculoTributoService.getTributacaoRegular((CbsIbsOutput)cbs, (CbsIbsOutput)ibsEstadual, (CbsIbsOutput)ibsMunicipal);
        CreditoPresumido creditoPresumidoIBS = CalculoTributoService.getCreditoPresumidoIBS((CbsIbsOutput)ibsEstadual, (CbsIbsOutput)ibsMunicipal);
        CreditoPresumido creditoPresumidoCBS = CalculoTributoService.getCreditoPresumidoCBS((CbsIbsOutput)cbs);
        TributacaoCompraGovernamental compraGovernamental = CalculoTributoService.getCompraGovernamental((CbsIbsOutput)cbs, (CbsIbsOutput)ibsEstadual, (CbsIbsOutput)ibsMunicipal);
        return GrupoIBSCBS.builder().vBC(vBC).gIBSUF(ibsUF).gIBSMun(ibsMun).gCBS(CalculoTributoService.getCbs((CbsIbsOutput)cbs)).gTribRegular(tributacaoRegular).gIBSCredPres(creditoPresumidoIBS).gCBSCredPres(creditoPresumidoCBS).gTribCompraGov(compraGovernamental).build();
    }

    private static BigDecimal getVBC(CbsIbsOutput c, BigDecimal valor) {
        if (valor != null) {
            return valor;
        }
        if (c != null) {
            return c.getBaseCalculo();
        }
        return null;
    }

    private static IBSUF getIBSUF(CbsIbsOutput ibsEstadual) {
        if (ibsEstadual == null) {
            return null;
        }
        IBSUF ibsUF = new IBSUF();
        ibsUF.setAliquota(ibsEstadual.getAliquota());
        ibsUF.setGDif(ibsEstadual.getGrupoDiferimento());
        ibsUF.setGDevTrib(CalculoTributoService.getDevolucaoTributos((CbsIbsOutput)ibsEstadual));
        ibsUF.setGRed(ibsEstadual.getGrupoReducao());
        ibsUF.setValorImposto(ibsEstadual.getTributoDevido());
        ibsUF.setMemoriaCalculo(ibsEstadual.getMemoriaCalculo());
        return ibsUF;
    }

    private static IBSMun getIBSMun(CbsIbsOutput ibsMunicipal) {
        if (ibsMunicipal == null) {
            return null;
        }
        IBSMun ibsMun = new IBSMun();
        ibsMun.setAliquota(ibsMunicipal.getAliquota());
        ibsMun.setGDif(ibsMunicipal.getGrupoDiferimento());
        ibsMun.setGDevTrib(CalculoTributoService.getDevolucaoTributos((CbsIbsOutput)ibsMunicipal));
        ibsMun.setGRed(ibsMunicipal.getGrupoReducao());
        ibsMun.setValorImposto(ibsMunicipal.getTributoDevido());
        ibsMun.setMemoriaCalculo(ibsMunicipal.getMemoriaCalculo());
        return ibsMun;
    }

    private static CBS getCbs(CbsIbsOutput cbsOut) {
        if (cbsOut == null) {
            return null;
        }
        CBS cbs = new CBS();
        cbs.setAliquota(cbsOut.getAliquota());
        cbs.setGDif(cbsOut.getGrupoDiferimento());
        cbs.setGDevTrib(CalculoTributoService.getDevolucaoTributos((CbsIbsOutput)cbsOut));
        cbs.setGRed(cbsOut.getGrupoReducao());
        cbs.setValorImposto(cbsOut.getTributoDevido());
        cbs.setMemoriaCalculo(cbsOut.getMemoriaCalculo());
        return cbs;
    }

    private static DevolucaoTributos getDevolucaoTributos(CbsIbsOutput d) {
        return null;
    }

    private static TributacaoRegular getTributacaoRegular(CbsIbsOutput cbs, CbsIbsOutput ibsEstadual, CbsIbsOutput ibsMunicipal) {
        TributacaoRegular.TributacaoRegularBuilder builder = CalculoTributoService.getTributacaoRegularCBS((CbsIbsOutput)cbs, null);
        builder = CalculoTributoService.getTributacaoRegularIBSUF((CbsIbsOutput)ibsEstadual, (TributacaoRegular.TributacaoRegularBuilder)builder);
        if ((builder = CalculoTributoService.getTributacaoRegularIBSMun((CbsIbsOutput)ibsMunicipal, (TributacaoRegular.TributacaoRegularBuilder)builder)) != null) {
            return builder.build();
        }
        return null;
    }

    private static TributacaoRegular.TributacaoRegularBuilder getTributacaoRegularIBSUF(CbsIbsOutput ibsUF, TributacaoRegular.TributacaoRegularBuilder builder) {
        if (ibsUF != null && ibsUF.getTributacaoRegular() != null) {
            TributacaoRegularOutput tr = ibsUF.getTributacaoRegular();
            if (builder == null) {
                builder = TributacaoRegular.builder();
                builder.CSTReg(Integer.valueOf(tr.getCst())).cClassTribReg(tr.getCClassTrib());
            }
            builder.pAliqEfetRegIBSUF(tr.getAliquotaEfetiva()).vTribRegIBSUF(tr.getTributoDevido());
            return builder;
        }
        return null;
    }

    private static TributacaoRegular.TributacaoRegularBuilder getTributacaoRegularIBSMun(CbsIbsOutput ibsMun, TributacaoRegular.TributacaoRegularBuilder builder) {
        if (ibsMun != null && ibsMun.getTributacaoRegular() != null) {
            TributacaoRegularOutput tr = ibsMun.getTributacaoRegular();
            if (builder == null) {
                builder = TributacaoRegular.builder();
                builder.CSTReg(Integer.valueOf(tr.getCst())).cClassTribReg(tr.getCClassTrib());
            }
            builder.pAliqEfetRegIBSMun(tr.getAliquotaEfetiva()).vTribRegIBSMun(tr.getTributoDevido());
            return builder;
        }
        return null;
    }

    private static TributacaoRegular.TributacaoRegularBuilder getTributacaoRegularCBS(CbsIbsOutput cbs, TributacaoRegular.TributacaoRegularBuilder builder) {
        if (cbs != null && cbs.getTributacaoRegular() != null) {
            TributacaoRegularOutput tr = cbs.getTributacaoRegular();
            if (builder == null) {
                builder = TributacaoRegular.builder();
                builder.CSTReg(Integer.valueOf(tr.getCst())).cClassTribReg(tr.getCClassTrib());
            }
            builder.pAliqEfetRegCBS(tr.getAliquotaEfetiva()).vTribRegCBS(tr.getTributoDevido());
            return builder;
        }
        return null;
    }

    private static CreditoPresumido getCreditoPresumidoIBS(CbsIbsOutput ibsEstadual, CbsIbsOutput ibsMunicipal) {
        return null;
    }

    private static CreditoPresumido getCreditoPresumidoCBS(CbsIbsOutput cbs) {
        return null;
    }

    private static TributacaoCompraGovernamental getCompraGovernamental(CbsIbsOutput cbs, CbsIbsOutput ibsEstadual, CbsIbsOutput ibsMunicipal) {
        return null;
    }

    private static TransferenciaCredito getTransferenciaCredito(CbsIbsOutput cbs, CbsIbsOutput ibsEstadual, CbsIbsOutput ibsMunicipal) {
        return null;
    }

    private static CreditoPresumidoIBSZFM getCreditoPresumidoIBSZFM(CbsIbsOutput ibsEstadual, CbsIbsOutput ibsMunicipal) {
        return null;
    }

    private static Monofasia getMonofasia(CbsIbsOutput cbs, CbsIbsOutput ibsEstadual, CbsIbsOutput ibsMunicipal) {
        Monofasia.MonofasiaBuilder builder = CalculoTributoService.getMonofasiaCBS((CbsIbsOutput)cbs, null);
        if ((builder = CalculoTributoService.getMonofasiaIBS((CbsIbsOutput)ibsEstadual, (CbsIbsOutput)ibsMunicipal, (Monofasia.MonofasiaBuilder)builder)) != null) {
            return builder.build();
        }
        return null;
    }

    private static Monofasia.MonofasiaBuilder getMonofasiaCBS(CbsIbsOutput cbs, Monofasia.MonofasiaBuilder builder) {
        if (cbs != null && cbs.getGrupoMonofasia() != null) {
            GrupoDiferimentoMonofasiaOutput tributoDiferido;
            GrupoEtapaMonofasiaOutput tributoSujeitoRetencao;
            GrupoEtapaMonofasiaOutput tributoRetido;
            GrupoMonofasiaOutput mono;
            GrupoEtapaMonofasiaOutput tributoMonofasico;
            if (builder == null) {
                builder = Monofasia.builder();
            }
            if ((tributoMonofasico = (mono = cbs.getGrupoMonofasia()).getTributoMonofasico()) != null) {
                builder.qBCMono(tributoMonofasico.getQuantidade());
                builder.adRemCBS(tributoMonofasico.getAliquotaAdRem());
                builder.vCBSMono(tributoMonofasico.getValor());
            }
            if ((tributoRetido = mono.getTributoRetido()) != null) {
                builder.qBCMonoRet(tributoRetido.getQuantidade());
                builder.adRemCBSRet(tributoRetido.getAliquotaAdRem());
                builder.vCBSMonoRet(tributoRetido.getValor());
            }
            if ((tributoSujeitoRetencao = mono.getTributoSujeitoRetencao()) != null) {
                builder.qBCMonoReten(tributoSujeitoRetencao.getQuantidade());
                builder.adRemCBSReten(tributoSujeitoRetencao.getAliquotaAdRem());
                builder.vCBSMonoReten(tributoSujeitoRetencao.getValor());
            }
            if ((tributoDiferido = mono.getTributoDiferido()) != null) {
                builder.pDifCBS(tributoDiferido.getPercentualDiferimento());
                builder.vCBSMonoDif(tributoDiferido.getValorDiferimento());
            }
            return builder;
        }
        return null;
    }

    private static Monofasia.MonofasiaBuilder getMonofasiaIBS(CbsIbsOutput ibsUF, CbsIbsOutput ibsMun, Monofasia.MonofasiaBuilder builder) {
        GrupoMonofasiaOutput monoMun;
        GrupoMonofasiaOutput monoUF = ibsUF != null ? ibsUF.getGrupoMonofasia() : null;
        GrupoMonofasiaOutput grupoMonofasiaOutput = monoMun = ibsMun != null ? ibsMun.getGrupoMonofasia() : null;
        if (monoUF != null || monoMun != null) {
            GrupoDiferimentoMonofasiaOutput tributoDiferido;
            GrupoEtapaMonofasiaOutput tributoSujeitoRetencao;
            GrupoEtapaMonofasiaOutput tributoRetido;
            if (builder == null) {
                builder = Monofasia.builder();
            }
            monoUF = monoUF != null ? monoUF : GrupoMonofasiaOutput.builder().build();
            monoMun = monoMun != null ? monoMun : GrupoMonofasiaOutput.builder().build();
            GrupoEtapaMonofasiaOutput tributoMonofasico = GrupoEtapaMonofasiaOutput.merge((GrupoEtapaMonofasiaOutput)monoUF.getTributoMonofasico(), (GrupoEtapaMonofasiaOutput)monoMun.getTributoMonofasico());
            if (tributoMonofasico != null) {
                builder.qBCMono(tributoMonofasico.getQuantidade());
                builder.adRemIBS(tributoMonofasico.getAliquotaAdRem());
                builder.vIBSMono(tributoMonofasico.getValor());
            }
            if ((tributoRetido = GrupoEtapaMonofasiaOutput.merge((GrupoEtapaMonofasiaOutput)monoUF.getTributoRetido(), (GrupoEtapaMonofasiaOutput)monoMun.getTributoRetido())) != null) {
                builder.qBCMonoRet(tributoRetido.getQuantidade());
                builder.adRemIBSRet(tributoRetido.getAliquotaAdRem());
                builder.vIBSMonoRet(tributoRetido.getValor());
            }
            if ((tributoSujeitoRetencao = GrupoEtapaMonofasiaOutput.merge((GrupoEtapaMonofasiaOutput)monoUF.getTributoSujeitoRetencao(), (GrupoEtapaMonofasiaOutput)monoMun.getTributoSujeitoRetencao())) != null) {
                builder.qBCMonoReten(tributoSujeitoRetencao.getQuantidade());
                builder.adRemIBSReten(tributoSujeitoRetencao.getAliquotaAdRem());
                builder.vIBSMonoReten(tributoSujeitoRetencao.getValor());
            }
            if ((tributoDiferido = GrupoDiferimentoMonofasiaOutput.merge((GrupoDiferimentoMonofasiaOutput)monoUF.getTributoDiferido(), (GrupoDiferimentoMonofasiaOutput)monoMun.getTributoDiferido())) != null) {
                builder.pDifIBS(tributoDiferido.getPercentualDiferimento());
                builder.vIBSMonoDif(tributoDiferido.getValorDiferimento());
            }
            return builder;
        }
        return null;
    }

    @Generated
    public CalculoTributoService(CalculoCbsIbsService calculoCbsIbsService, CalculoImpostoSeletivoService calculoImpostoSeletivoService, MemoriaCalculoService memoriaCalculoService) {
        this.calculoCbsIbsService = calculoCbsIbsService;
        this.calculoImpostoSeletivoService = calculoImpostoSeletivoService;
        this.memoriaCalculoService = memoriaCalculoService;
    }
}

