/*
 * Decompiled with CFR 0.152.
 */
package br.gov.serpro.rtc.domain.service.dadosabertos;

import br.gov.serpro.rtc.api.model.output.dadosabertos.AliquotaDadosAbertosOutput;
import br.gov.serpro.rtc.api.model.output.dadosabertos.ClassificacaoTributariaDadosAbertosOutput;
import br.gov.serpro.rtc.api.model.output.dadosabertos.FundamentacaoClassificacaoDadosAbertosOutput;
import br.gov.serpro.rtc.api.model.output.dadosabertos.MunicipioDadosAbertosOutput;
import br.gov.serpro.rtc.api.model.output.dadosabertos.NbsDadosAbertosOutput;
import br.gov.serpro.rtc.api.model.output.dadosabertos.NcmDadosAbertosOutput;
import br.gov.serpro.rtc.api.model.output.dadosabertos.SituacaoTributariaDadosAbertosOutput;
import br.gov.serpro.rtc.api.model.output.dadosabertos.UfDadosAbertosOutput;
import br.gov.serpro.rtc.domain.model.entity.AliquotaPadrao;
import br.gov.serpro.rtc.domain.model.entity.AliquotaReferencia;
import br.gov.serpro.rtc.domain.model.entity.ClassificacaoTributaria;
import br.gov.serpro.rtc.domain.model.entity.FundamentacaoLegal;
import br.gov.serpro.rtc.domain.model.entity.SituacaoTributaria;
import br.gov.serpro.rtc.domain.repository.NbsRepository;
import br.gov.serpro.rtc.domain.repository.NcmRepository;
import br.gov.serpro.rtc.domain.repository.SituacaoTributariaRepository;
import br.gov.serpro.rtc.domain.repository.TratamentoClassificacaoRepository;
import br.gov.serpro.rtc.domain.service.AliquotaAdRemProdutoService;
import br.gov.serpro.rtc.domain.service.AliquotaAdValoremProdutoService;
import br.gov.serpro.rtc.domain.service.AliquotaAdValoremServicoService;
import br.gov.serpro.rtc.domain.service.AliquotaPadraoService;
import br.gov.serpro.rtc.domain.service.AliquotaReferenciaService;
import br.gov.serpro.rtc.domain.service.FundamentacaoClassificacaoService;
import br.gov.serpro.rtc.domain.service.MunicipioService;
import br.gov.serpro.rtc.domain.service.TributoSituacaoTributariaService;
import br.gov.serpro.rtc.domain.service.UfService;
import br.gov.serpro.rtc.domain.service.exception.NbsNaoEncontradaException;
import br.gov.serpro.rtc.domain.service.exception.NcmNaoEncontradaException;
import jakarta.validation.ValidationException;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.List;
import lombok.Generated;
import org.springframework.stereotype.Service;

/*
 * Exception performing whole class analysis ignored.
 */
@Service
public class DadosAbertosService {
    private final UfService ufService;
    private final MunicipioService municipioService;
    private final SituacaoTributariaRepository situacaoTributariaRepository;
    private final TratamentoClassificacaoRepository tratamentoClassificacaoRepository;
    private final NcmRepository ncmRepository;
    private final NbsRepository nbsRepository;
    private final AliquotaAdValoremProdutoService aliquotaAdValoremProdutoService;
    private final AliquotaAdValoremServicoService aliquotaAdValoremServicoService;
    private final AliquotaAdRemProdutoService aliquotaAdRemProdutoService;
    private final FundamentacaoClassificacaoService fundamentacaoClassificacaoService;
    private final TributoSituacaoTributariaService tributoSituacaoTributariaService;
    private final AliquotaReferenciaService aliquotaReferenciaService;
    private final AliquotaPadraoService aliquotaPadraoService;

    public List<UfDadosAbertosOutput> consultarUfs() {
        return this.ufService.consultarTodos().stream().map(uf -> UfDadosAbertosOutput.builder().sigla(uf.getSigla()).nome(uf.getNome()).codigo(uf.getCodigo()).build()).toList();
    }

    public List<MunicipioDadosAbertosOutput> consultarMunicipiosPorSiglaUf(String siglaUf) {
        return this.municipioService.consultarTodosPorSiglaUf(siglaUf).stream().map(m -> MunicipioDadosAbertosOutput.builder().codigo(m.getCodigo()).nome(m.getNome()).build()).toList();
    }

    public List<SituacaoTributariaDadosAbertosOutput> consultarSituacoesTributarias(Long idTributo, LocalDate data) {
        return this.situacaoTributariaRepository.consultarPorIdTributo(idTributo, data).stream().map(m -> SituacaoTributariaDadosAbertosOutput.builder().id(m.getId()).codigo(m.getCodigo()).descricao(m.getDescricao()).build()).toList();
    }

    public List<ClassificacaoTributariaDadosAbertosOutput> consultarClassificacoesTributariasPorIdSituacaoTributaria(Long idSituacaoTributaria, LocalDate data) {
        return this.tratamentoClassificacaoRepository.consultarTratamentoClassificacaoPorIdSituacaoTributaria(idSituacaoTributaria, data).stream().map(m -> ClassificacaoTributariaDadosAbertosOutput.builder().codigo((String)m[0]).descricao((String)m[1]).tipoAliquota((String)m[2]).nomenclatura((String)m[3]).descricaoTratamentoTributario((String)m[4]).incompativelComSuspensao(m[5] != null && (Integer)m[5] != 0).exigeGrupoDesoneracao(m[6] != null && (Integer)m[6] != 0).possuiPercentualReducao(m[7] != null && (Integer)m[7] != 0).build()).toList();
    }

    public NcmDadosAbertosOutput consultarNcm(String ncm, LocalDate data) {
        DadosAbertosService.validarNcm((String)ncm);
        if (!this.ncmRepository.existeNcm(ncm, data)) {
            throw new NcmNaoEncontradaException(ncm, data);
        }
        BigDecimal aliquotaAdValorem = this.aliquotaAdValoremProdutoService.buscarAliquotaAdValorem(ncm, Long.valueOf(1L), data);
        BigDecimal aliquotaAdRem = this.aliquotaAdRemProdutoService.buscarAliquotaAdRem(ncm, Long.valueOf(1L), data);
        return NcmDadosAbertosOutput.builder().tributadoPeloImpostoSeletivo(aliquotaAdValorem != null || aliquotaAdRem != null).aliquotaAdValorem(aliquotaAdValorem).aliquotaAdRem(aliquotaAdRem).capitulo((String)this.ncmRepository.buscarDescricaoNcm(ncm, 2, data).orElse(null)).posicao((String)this.ncmRepository.buscarDescricaoNcm(ncm, 4, data).orElse(null)).subposicao((String)this.ncmRepository.buscarDescricaoNcm(ncm, 6, data).orElse(null)).item((String)this.ncmRepository.buscarDescricaoNcm(ncm, 7, data).orElse(null)).subitem((String)this.ncmRepository.buscarDescricaoNcm(ncm, 8, data).orElse(null)).build();
    }

    private static void validarNcm(String ncm) {
        if (ncm == null) {
            throw new ValidationException("O campo NCM \u00e9 obrigat\u00f3rio.");
        }
        if (!ncm.matches("\\d+")) {
            throw new ValidationException("O campo NCM deve conter somente d\u00edgitos.");
        }
    }

    public NbsDadosAbertosOutput consultarNbs(String nbs, LocalDate data) {
        DadosAbertosService.validarNbs((String)nbs);
        if (!this.nbsRepository.existeNbs(nbs, data)) {
            throw new NbsNaoEncontradaException(nbs, data);
        }
        BigDecimal aliquotaAdValorem = this.aliquotaAdValoremServicoService.buscarAliquotaAdValorem(nbs, Long.valueOf(1L), data);
        Object aliquotaAdRem = null;
        return NbsDadosAbertosOutput.builder().tributadoPeloImpostoSeletivo(aliquotaAdValorem != null || aliquotaAdRem != null).aliquotaAdValorem(aliquotaAdValorem).capitulo((String)this.nbsRepository.buscarDescricaoNbs(nbs, 5, data).orElse(null)).posicao((String)this.nbsRepository.buscarDescricaoNbs(nbs, 6, data).orElse(null)).subposicao1((String)this.nbsRepository.buscarDescricaoNbs(nbs, 7, data).orElse(null)).subposicao2((String)this.nbsRepository.buscarDescricaoNbs(nbs, 8, data).orElse(null)).item((String)this.nbsRepository.buscarDescricaoNbs(nbs, 9, data).orElse(null)).build();
    }

    private static void validarNbs(String nbs) {
        if (nbs == null) {
            throw new ValidationException("O campo NBS \u00e9 obrigat\u00f3rio.");
        }
        if (!nbs.matches("\\d+")) {
            throw new ValidationException("O campo NBS deve conter somente d\u00edgitos.");
        }
    }

    public List<FundamentacaoClassificacaoDadosAbertosOutput> consultarFundamentacoesLegais(LocalDate data) {
        return this.fundamentacaoClassificacaoService.buscarTodas(data).stream().map(x -> {
            ClassificacaoTributaria classificacao = x.getClassificacaoTributaria();
            SituacaoTributaria situacao = classificacao.getSituacaoTributaria();
            Long idTributo = this.tributoSituacaoTributariaService.consultarPorIdSituacaoTributaria(situacao.getId(), data);
            FundamentacaoLegal fundamentacao = x.getFundamentacaoLegal();
            return FundamentacaoClassificacaoDadosAbertosOutput.builder().codigoClassificacaoTributaria(classificacao.getCodigo()).descricaoClassificacaoTributaria(classificacao.getDescricao()).codigoSituacaoTributaria(situacao.getCodigo()).descricaoSituacaoTributaria(situacao.getDescricao()).conjuntoTributo(idTributo == 1L ? "Imposto Seletivo" : "CBS e IBS").texto(fundamentacao.getTexto()).textoCurto(fundamentacao.getTextoCurto()).referenciaNormativa(fundamentacao.getReferenciaNormativa()).build();
        }).toList();
    }

    public List<ClassificacaoTributariaDadosAbertosOutput> consultarClassificacoesTributariasCbsIbs(LocalDate data) {
        return this.tratamentoClassificacaoRepository.consultarTratamentoClassificacaoCbsIbs(data).stream().map(m -> ClassificacaoTributariaDadosAbertosOutput.builder().codigo((String)m[0]).descricao((String)m[1]).tipoAliquota((String)m[2]).nomenclatura((String)m[3]).descricaoTratamentoTributario((String)m[4]).incompativelComSuspensao(m[5] != null && (Integer)m[5] != 0).exigeGrupoDesoneracao(m[6] != null && (Integer)m[6] != 0).possuiPercentualReducao(m[7] != null && (Integer)m[7] != 0).build()).toList();
    }

    public List<ClassificacaoTributariaDadosAbertosOutput> consultarClassificacoesTributariasImpostoSeletivo(LocalDate data) {
        return this.tratamentoClassificacaoRepository.consultarTratamentoClassificacaoImpostoSeletivo(data).stream().map(m -> ClassificacaoTributariaDadosAbertosOutput.builder().codigo((String)m[0]).descricao((String)m[1]).tipoAliquota((String)m[2]).nomenclatura((String)m[3]).descricaoTratamentoTributario((String)m[4]).incompativelComSuspensao(m[5] != null && (Integer)m[5] != 0).exigeGrupoDesoneracao(m[6] != null && (Integer)m[6] != 0).possuiPercentualReducao(m[7] != null && (Integer)m[7] != 0).build()).toList();
    }

    public AliquotaDadosAbertosOutput consultarAliquota(Long idTributo, Long codigoUf, Long codigoMunicipio, LocalDate data) {
        AliquotaReferencia aliquotaReferencia = this.aliquotaReferenciaService.buscar(idTributo, data);
        AliquotaPadrao aliquotaPadrao = null;
        if (idTributo == 2L) {
            aliquotaPadrao = this.aliquotaPadraoService.buscarAliquotaUniao(aliquotaReferencia, data);
        } else if (idTributo == 3L) {
            aliquotaPadrao = this.aliquotaPadraoService.buscarAliquotaUf(aliquotaReferencia, codigoUf, data);
        } else if (idTributo == 4L) {
            aliquotaPadrao = this.aliquotaPadraoService.buscarAliquotaMunicipio(aliquotaReferencia, codigoMunicipio, data);
        }
        return AliquotaDadosAbertosOutput.builder().aliquotaReferencia(aliquotaReferencia.getValor()).aliquotaPropria(aliquotaPadrao != null ? aliquotaPadrao.getValorAplicavel() : null).formaAplicacao(aliquotaPadrao != null ? aliquotaPadrao.getFormaAplicacao() : null).build();
    }

    @Generated
    public DadosAbertosService(UfService ufService, MunicipioService municipioService, SituacaoTributariaRepository situacaoTributariaRepository, TratamentoClassificacaoRepository tratamentoClassificacaoRepository, NcmRepository ncmRepository, NbsRepository nbsRepository, AliquotaAdValoremProdutoService aliquotaAdValoremProdutoService, AliquotaAdValoremServicoService aliquotaAdValoremServicoService, AliquotaAdRemProdutoService aliquotaAdRemProdutoService, FundamentacaoClassificacaoService fundamentacaoClassificacaoService, TributoSituacaoTributariaService tributoSituacaoTributariaService, AliquotaReferenciaService aliquotaReferenciaService, AliquotaPadraoService aliquotaPadraoService) {
        this.ufService = ufService;
        this.municipioService = municipioService;
        this.situacaoTributariaRepository = situacaoTributariaRepository;
        this.tratamentoClassificacaoRepository = tratamentoClassificacaoRepository;
        this.ncmRepository = ncmRepository;
        this.nbsRepository = nbsRepository;
        this.aliquotaAdValoremProdutoService = aliquotaAdValoremProdutoService;
        this.aliquotaAdValoremServicoService = aliquotaAdValoremServicoService;
        this.aliquotaAdRemProdutoService = aliquotaAdRemProdutoService;
        this.fundamentacaoClassificacaoService = fundamentacaoClassificacaoService;
        this.tributoSituacaoTributariaService = tributoSituacaoTributariaService;
        this.aliquotaReferenciaService = aliquotaReferenciaService;
        this.aliquotaPadraoService = aliquotaPadraoService;
    }
}

