/*
 * Decompiled with CFR 0.152.
 */
package br.gov.serpro.rtc.domain.service.pedagio;

import br.gov.serpro.rtc.api.model.input.pedagio.PedagioInput;
import br.gov.serpro.rtc.api.model.output.pedagio.PedagioOutput;
import br.gov.serpro.rtc.api.model.output.pedagio.TotalPedagioOutput;
import br.gov.serpro.rtc.api.model.output.pedagio.TrechoPedagioOutput;
import br.gov.serpro.rtc.api.model.output.pedagio.TributoPedagioOutput;
import br.gov.serpro.rtc.core.util.CalculadoraUtils;
import br.gov.serpro.rtc.domain.model.entity.AliquotaPadrao;
import br.gov.serpro.rtc.domain.model.entity.AliquotaReferencia;
import br.gov.serpro.rtc.domain.model.entity.Uf;
import br.gov.serpro.rtc.domain.model.enumeration.TributoEnum;
import br.gov.serpro.rtc.domain.service.AliquotaPadraoService;
import br.gov.serpro.rtc.domain.service.AliquotaReferenciaService;
import br.gov.serpro.rtc.domain.service.UfService;
import br.gov.serpro.rtc.domain.service.exception.CampoInvalidoException;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.List;
import lombok.Generated;
import org.springframework.stereotype.Service;

/*
 * Exception performing whole class analysis ignored.
 */
@Service
public class PedagioService {
    private static final DateTimeFormatter FORMATO_DATA_HORA = DateTimeFormatter.ofPattern("yyyyMMddHHmmss");
    public static final String NUMERO_VERSAO = "1.0.0(" + LocalDateTime.now().format(FORMATO_DATA_HORA) + ")";
    private final AliquotaReferenciaService aliquotaReferenciaService;
    private final AliquotaPadraoService aliquotaPadraoService;
    private final UfService ufService;

    public PedagioOutput calcularCIBS(PedagioInput operacao) {
        List trechosPedagio = this.getTrechosPedagio(operacao);
        return PedagioOutput.builder().cst(operacao.getCst()).cClassTrib(operacao.getCClassTrib()).extensaoTotal(operacao.getExtensaoTotal()).dataHoraEmissao(operacao.getDataHoraEmissao()).municipioOrigem(operacao.getCodigoMunicipioOrigem()).baseCalculo(operacao.getBaseCalculo()).ufMunicipioOrigem(operacao.getUfMunicipioOrigem()).trechos(trechosPedagio).total(TotalPedagioOutput.getTotal((List)trechosPedagio)).build();
    }

    private List<TrechoPedagioOutput> getTrechosPedagio(PedagioInput operacao) {
        BigDecimal x = operacao.getExtensaoTotal();
        return operacao.getTrechos().parallelStream().map(trecho -> {
            BigDecimal baseCalculoCIBS = operacao.getBaseCalculo();
            LocalDate dataFatoGerador = operacao.getDataHoraEmissao().toLocalDate();
            Uf uf = this.ufService.buscar(trecho.getUf());
            BigDecimal valorAliquotaCbs = this.buscarAliquotaPadrao(TributoEnum.CBS, dataFatoGerador, null, null);
            BigDecimal valorAliquotaIbsEstadual = this.buscarAliquotaPadrao(TributoEnum.IBS_ESTADUAL, dataFatoGerador, uf.getCodigo(), null);
            BigDecimal valorAliquotaIbsMunicipal = this.buscarAliquotaPadrao(TributoEnum.IBS_MUNICIPAL, dataFatoGerador, null, trecho.getMunicipio());
            if (valorAliquotaCbs == null || valorAliquotaIbsEstadual == null || valorAliquotaIbsMunicipal == null) {
                throw new CampoInvalidoException("Erro ao obter al\u00edquotas");
            }
            BigDecimal valorAliquotaEfetivaCbs = valorAliquotaCbs.multiply(trecho.getExtensao()).divide(x, 8, RoundingMode.DOWN);
            BigDecimal valorAliquotaEfetivaIbsEstadual = valorAliquotaIbsEstadual.multiply(trecho.getExtensao()).divide(x, 8, RoundingMode.DOWN);
            BigDecimal valorAliquotaEfetivaIbsMunicipal = valorAliquotaIbsMunicipal.multiply(trecho.getExtensao()).divide(x, 8, RoundingMode.DOWN);
            TributoPedagioOutput cbs = PedagioService.obterCIBS((BigDecimal)valorAliquotaCbs, (BigDecimal)valorAliquotaEfetivaCbs, (BigDecimal)baseCalculoCIBS);
            TributoPedagioOutput ibsEstado = PedagioService.obterCIBS((BigDecimal)valorAliquotaIbsEstadual, (BigDecimal)valorAliquotaEfetivaIbsEstadual, (BigDecimal)baseCalculoCIBS);
            TributoPedagioOutput ibsMunicipio = PedagioService.obterCIBS((BigDecimal)valorAliquotaIbsMunicipal, (BigDecimal)valorAliquotaEfetivaIbsMunicipal, (BigDecimal)baseCalculoCIBS);
            return TrechoPedagioOutput.builder().numero(trecho.getNumero()).uf(trecho.getUf()).municipio(trecho.getMunicipio()).baseCalculo(baseCalculoCIBS).cbs(cbs).ibsEstadual(ibsEstado).ibsMunicipal(ibsMunicipio).extensaoTrecho(trecho.getExtensao()).build();
        }).sorted().toList();
    }

    private static TributoPedagioOutput obterCIBS(BigDecimal aliquota, BigDecimal aliquotaEfetiva, BigDecimal baseCalculo) {
        return TributoPedagioOutput.builder().aliquota(aliquota).aliquotaEfetiva(aliquotaEfetiva).tributoCalculado(PedagioService.calcularTributo((BigDecimal)baseCalculo, (BigDecimal)aliquotaEfetiva)).build();
    }

    private static BigDecimal calcularTributo(BigDecimal baseCalculo, BigDecimal aliquota) {
        return baseCalculo.multiply(aliquota).setScale(4, RoundingMode.HALF_UP);
    }

    public BigDecimal buscarAliquotaPadrao(TributoEnum tributo, LocalDate data, Long codigoUf, Long codigoMunicipio) {
        AliquotaReferencia aliquotaReferencia = this.aliquotaReferenciaService.buscar(Long.valueOf(tributo.getCodigo()), data);
        AliquotaPadrao aliquotaPadrao = null;
        if (tributo == TributoEnum.CBS) {
            aliquotaPadrao = this.aliquotaPadraoService.buscarAliquotaUniao(aliquotaReferencia, data);
        } else if (tributo == TributoEnum.IBS_ESTADUAL) {
            aliquotaPadrao = this.aliquotaPadraoService.buscarAliquotaUf(aliquotaReferencia, codigoUf, data);
        } else if (tributo == TributoEnum.IBS_MUNICIPAL) {
            aliquotaPadrao = this.aliquotaPadraoService.buscarAliquotaMunicipio(aliquotaReferencia, codigoMunicipio, data);
        }
        if (aliquotaPadrao != null) {
            return aliquotaPadrao.getValorAplicavel().divide(CalculadoraUtils.CEM).setScale(8, RoundingMode.HALF_UP);
        }
        return this.aliquotaReferenciaService.buscar(Long.valueOf(tributo.getCodigo()), data).getValor().divide(CalculadoraUtils.CEM).setScale(8, RoundingMode.HALF_UP);
    }

    @Generated
    public PedagioService(AliquotaReferenciaService aliquotaReferenciaService, AliquotaPadraoService aliquotaPadraoService, UfService ufService) {
        this.aliquotaReferenciaService = aliquotaReferenciaService;
        this.aliquotaPadraoService = aliquotaPadraoService;
        this.ufService = ufService;
    }
}

