/*
 * Decompiled with CFR 0.152.
 */
package br.gov.serpro.rtc.domain.service.token;

import br.gov.serpro.rtc.domain.service.token.TextToken;
import br.gov.serpro.rtc.domain.service.token.TokenCacheService;
import java.util.ArrayList;
import java.util.List;
import lombok.Generated;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;

@Service
public class TemplateTokenizerService {
    private final TokenCacheService tokenCacheService;

    @Cacheable(cacheNames={"TemplateTokenizerService.tokenize"})
    public List<TextToken> tokenize(String template) {
        ArrayList<TextToken> tokens = new ArrayList<TextToken>();
        int last = 0;
        int len = template.length();
        while (last < len) {
            int open = template.indexOf(91, last);
            if (open < 0) {
                tokens.add(this.tokenCacheService.get(template.substring(last), null));
                break;
            }
            int close = template.indexOf(93, open + 1);
            if (close < 0) {
                tokens.add(this.tokenCacheService.get(template.substring(last), null));
                break;
            }
            if (open > last) {
                tokens.add(this.tokenCacheService.get(template.substring(last, open), null));
            }
            String key = template.substring(open + 1, close);
            tokens.add(this.tokenCacheService.get(null, key));
            last = close + 1;
        }
        return tokens;
    }

    @Generated
    public TemplateTokenizerService(TokenCacheService tokenCacheService) {
        this.tokenCacheService = tokenCacheService;
    }
}

