/*
 * Decompiled with CFR 0.152.
 */
package br.gov.serpro.rtc.domain.service.xml;

import br.gov.serpro.rtc.domain.service.exception.ErroXmlException;
import java.io.IOException;
import java.io.StringReader;
import java.net.URL;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import javax.xml.validation.Validator;
import lombok.Generated;
import org.springframework.stereotype.Service;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

@Service
public class XmlService {
    public boolean validarXml(String xml, String tipo, String subtipo) {
        try {
            ClassLoader classLoader = this.getClass().getClassLoader();
            URL xsdUrl = classLoader.getResource("xml/" + tipo + "/" + subtipo + ".xsd");
            if (xsdUrl == null) {
                throw new IOException("XSD file not found in classpath");
            }
            SchemaFactory factory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
            Schema schema = factory.newSchema(new StreamSource(xsdUrl.openStream(), xsdUrl.toExternalForm()));
            Validator validator = schema.newValidator();
            validator.validate(new StreamSource(new StringReader(xml)));
            return true;
        }
        catch (SAXParseException e) {
            String msg = String.format("Erro na linha %d, coluna %d: %s", e.getLineNumber(), e.getColumnNumber(), e.getMessage());
            e.printStackTrace();
            throw new ErroXmlException(msg);
        }
        catch (SAXException e) {
            e.printStackTrace();
            throw new ErroXmlException(e.getMessage());
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new ErroXmlException("Erro de IO na valida\u00e7\u00e3o de XML: " + e.getMessage());
        }
    }

    @Generated
    public XmlService() {
    }
}

