FormManager.afterCreateAllForms.subscribe(() => {
    let form = FormManager.byname('TNGEMDPCONFIGPUBLICACAODOC');
    let saved = false;
    let deleted = false

    form.AfterModal = () => {
        if (saved || deleted) {
            saved = false;
            deleted = false;

            form.executeAction('ActionExecutarExecute');
        }
    };

    $("#framemodal").on("load", function() {
        if (!this.contentWindow.FormManager) return;

        this.contentWindow.FormManager.runAfterCreateAllForms(function (FormManagerModal, items) {
            const form = items.firstUsable();
            
            if (form) {
                form.AfterSave.subscribe(function() {
                    saved = true;
                });
                
                form.afterDelete.subscribe(() => {
                    deleted = true;
                });
            }
        });
	});
});