FormManager.afterCreateAllForms.subscribe(function() {
    let form = FormManager.byname('TnCtbDMLctoCtb', '');
    
	form.getcomponent('CODIGOLCTOPROG').change(HabilitarDesabilitarCampos);
	form.getcomponent('CONTACTBCRED').change(HabilitarCreditos);
	form.getcomponent('CONTACTBDEB').change(HabilitarDebitos);

    HabilitarDesabilitarCampos();

	function HabilitarCreditos(){
		setTimeout(function() { 
			HabilitaDesabilitaAtividades();
			HabilitaDesabilitaGerenciais(form.getvalue('CONTACTBCRED'), 'TnCtbDMLctoGercredito');
		}, 1000)		
	}

	function HabilitarDebitos(){
		setTimeout(function() { 
			HabilitaDesabilitaAtividades();
			HabilitaDesabilitaGerenciais(form.getvalue('CONTACTBDEB'), 'TnCtbDMLctoGerdebito');
		}, 1000)			
	}

    function HabilitaDesabilitaAtividades() {
		KTApp.blockPage();
		AJaxCadastroExecuteMethodGetProperty('TnCtbDMLctoCtb', 'HabilitarDetalhesCloudAjax', form.getvalue('CODIGOEMPRESA'), '', (retorno) => {
            if (retorno.data.result) {
				AJaxExecuteMethod('TnCtbDMLctoAtivDiferenccredito', form.getvalue('CONTACTBCRED'));
				AJaxExecuteMethod('TnCtbDMLctoAtivDiferencdebito', form.getvalue('CONTACTBDEB'));
            }
        });
        KTApp.unblockPage();
    }

    function AJaxExecuteMethod(ClasseDetalhe, ContaCtb) {
        if (ContaCtb) {
            AJaxCadastroExecuteMethodGetProperty('TnCtbDMLctoCtb', 'HabilitarCreditoDebitoDetalheCloudAjax', ContaCtb, '', (retorno) => {
                if (retorno.data.result) {
					$(".kt-wizard--4").show(); // detalhes
                    $(`li[data-id=tab${ClasseDetalhe}]`).show();
					if(TemGridDetalhesHabilitado() == 0){
						$(`#${ClasseDetalhe}`).show();	
					}
                }else{
					$(`li[data-id=tab${ClasseDetalhe}]`).hide();
					$(`#${ClasseDetalhe}`).hide();
				}
            });
        }else{
			$(`li[data-id=tab${ClasseDetalhe}]`).hide();
			$(`#${ClasseDetalhe}`).hide();
		}
    }

    let tipoAtividade = '';

    $('[data-id="tabTnCtbDMLctoAtivDiferenccredito"]').on("click", function() {
        tipoAtividade = 'credito';
		$("#TnCtbDMLctoAtivDiferenccredito").show();
		$("#TnCtbDMLctoAtivDiferencdebito").hide();
		$("#TnCtbDMLctoGerdebito").hide();
		$("#TnCtbDMLctoGercredito").hide();
    });

    $('[data-id="tabTnCtbDMLctoAtivDiferencdebito"]').on("click", function() {
        tipoAtividade = 'debito';
		$("#TnCtbDMLctoAtivDiferencdebito").show();
		$("#TnCtbDMLctoAtivDiferenccredito").hide();
		$("#TnCtbDMLctoGerdebito").hide();
		$("#TnCtbDMLctoGercredito").hide();
    });

	$('[data-id="tabTnCtbDMLctoGerdebito"]').on("click", function() {
		$("#TnCtbDMLctoGerdebito").show();
        $("#TnCtbDMLctoAtivDiferencdebito").hide();
		$("#TnCtbDMLctoAtivDiferenccredito").hide();
		$("#TnCtbDMLctoGercredito").hide();
    });
	
	$('[data-id="tabTnCtbDMLctoGercredito"]').on("click", function() {
		$("#TnCtbDMLctoGercredito").show();
        $("#TnCtbDMLctoGerdebito").hide();
        $("#TnCtbDMLctoAtivDiferencdebito").hide();
		$("#TnCtbDMLctoAtivDiferenccredito").hide();
    });

    $("#framemodal").on("load", function() {
        if (!this.contentWindow.FormManager) return;

        this.contentWindow.FormManager.runAfterCreateAllForms(function(FormManagerModal, items) {
            const formDetalhe = FormManagerModal.byname('TnCtbDMLctoAtivDiferenc', '');

            if (formDetalhe) {
                formDetalhe.AfterLoadDataSubject.subscribe(() => {
                    formDetalhe.setvalue('CHAVELCTOCTB', form.getvalue('CHAVELCTOCTB'));
                    if (tipoAtividade == 'debito') {
                        formDetalhe.setvalue('CONTACTB', form.getvalue('CONTACTBDEB'));
                        formDetalhe.setvalue('NATURLCTOCTB', 1);
                    } else {
                        formDetalhe.setvalue('CONTACTB', form.getvalue('CONTACTBCRED'));
                        formDetalhe.setvalue('NATURLCTOCTB', -1);
                    }
                    formDetalhe.setvalue('DATALCTOCTB', form.getvalue('DATALCTOCTB'));
                    formDetalhe.setvalue('VALORLCTOATIV', form.getvalue('VALORLCTOCTB'));
                    formDetalhe.setvalue('ORIGEMDADO', 2);
                })
            }
        });
    });
});

function actNotaExplicaPeriodo(sender){
	AbrirCadastro("TnCtbDMNotaExplicaPeriodo", true);
};

function HabilitaDesabilitaGerenciais(contaCtb, classe){
	let form = FormManager.byname('TnCtbDMLctoCtb', '');
	if ((contaCtb) && (form.getvalue('DATALCTOCTB'))) {
		$achave = form.getvalue('CODIGOEMPRESA') + ';' + contaCtb + ';' + form.getvalue('DATALCTOCTB');
		AJaxCadastroExecuteMethodGetProperty('TnCtbDMLctoCtb', 'VerificarContaRateio', $achave, '', (retorno) => {
			if (retorno.data.result) {
				$(".kt-wizard--4").show(); // detalhes
				$(`[data-id=tab${classe}]`).show(); // linkAba
				if(TemGridDetalhesHabilitado() == 0){
					$(`#${classe}`).show();
				}
			}else{
				$(`[data-id=tab${classe}]`).hide(); // linkAba
				$(`#${classe}`).hide();
			}
		});
	}else{
		$(`[data-id=tab${classe}]`).hide(); // linkAba
		$(`#${classe}`).hide();
	}
	setTimeout(function() { 
		if($("[data-id=tabTnCtbDMLctoAtivDiferenccredito]:visible, [data-id=tabTnCtbDMLctoAtivDiferencdebito]:visible, " +
				"[data-id=tabTnCtbDMLctoGerdebito]:visible, [data-id=tabTnCtbDMLctoGercredito]:visible").length == 0){
			$(".kt-wizard--4").hide();	
		}
	}, 2000)
}

function TemGridDetalhesHabilitado(){
	var detalheHabilitado = 0;
		
	if($("#TnCtbDMLctoAtivDiferencdebito").is(":visible") || $("#TnCtbDMLctoAtivDiferenccredito").is(":visible") ||
		$("#TnCtbDMLctoGerdebito").is(":visible") || $("#TnCtbDMLctoGercredito").is(":visible")){
		detalheHabilitado = 1;
	}
	return detalheHabilitado;
}

function HabilitarDesabilitarCampos(){
	let form = FormManager.byname('TnCtbDMLctoCtb', '');
		
	if (form.configextra != null) {
		RestoreTabsCadastro();
		if (!(form.configextra.UsaAtividades)) {
			RemoverTabCadastro('TnCtbDMLctoAtivDiferenccredito');
			RemoverTabCadastro('TnCtbDMLctoAtivDiferencdebito');
		}
		
		if (!(form.configextra.EhOptanteIFRS) || !(form.configextra.UsaAtividades)) {
			RemoverTabCadastro('nCtbDMRelacLctoCtbIFRS');
		}
		
		if (!(form.configextra.UsaCentroCusto)) {
			RemoverTabCadastro('TnCtbDMLctoGerdebito');
			RemoverTabCadastro('TnCtbDMLctoGercredito');
		}
		
		form.setenabled('TRANSCTB',       false);
		form.setenabled('CHAVELCTOCTB',   false);
		form.setenabled('CODIGOLCTOPROG', false);
		form.setenabled('CODIGOLOTECTB',  false);
		form.setenabled('NUMERODCTO',     false);
		form.setenabled('VALORLCTOMOEDA', false);
		
		form.setenabled('CODIGOORIGLCTOCTB', form.configextra.UsaOrigemLctoCtb);
		form.setenabled('NUMERODCTO',        form.configextra.UsaNumeroDcto);
		form.setenabled('CODIGOLOTECTB',     form.configextra.UsaLote);

		if (form.configextra.UsaLote) {
			if ((form.configextra.UsaOrigemLctoCtb) && (form.configextra.PertenceLote)){
				form.setenabled('CODIGOORIGLCTOCTB', false);
			}

			if ((form.configextra.DataInicialLote != 0) && (form.configextra.DataInicialLote == form.configextra.DataFinalLote)){
				form.setenabled('DATALCTOCTB', false);
			}
		}

		if ((SessionManager.selecao.DATALCTOCTB_MAIORIGUAL != 0) && (SessionManager.selecao.DATALCTOCTB_MAIORIGUAL == SessionManager.selecao.DATALCTOCTB_MENORIGUAL)){
			form.setenabled('DATALCTOCTB', false);
		}
		
		if (form.configextra.DireitoAlteraDadoFixoLancamentoProg) {
			AEnable = form.getvalue('CODIGOLCTOPROG') == 0;
			form.setenabled('CONTACTBDEB',       AEnable);
			form.setenabled('CONTACTBCRED',      AEnable);
			form.setenabled('CODIGOHISTCTB',     AEnable);
			form.setenabled('COMPLHIST',         AEnable);
			form.setenabled('DATALCTOCTB',       AEnable);
			form.setenabled('CODIGOLOTECTB',     AEnable && form.configextra.UsaLote);
			form.setenabled('TIPOLANCAMENTO',    AEnable);
			form.setenabled('NUMERODCTO',        AEnable && form.configextra.UsaNumeroDcto);
			form.setenabled('VALORLCTOCTB',      AEnable);
			form.setenabled('CODIGOORIGLCTOCTB', AEnable && form.configextra.UsaOrigemLctoCtb);
		}

		form.AfterLoadDataSubject.subscribe(() => SetValueCodigoEstab());

		function SetValueCodigoEstab(){
			form.setvalue('CODIGOESTAB', SessionManager.selecao.CODIGOESTAB);
		}
	}
}