FormManager.afterCreateAllForms.subscribe(function () {
  let form = FormManager.byname('TnCtbDMPlanoEspec', '');
  const acronym = FormManager.getUtil('Acronym');

	form.getcomponent('APELIDOCONTA').on('focus', PreencherApelido);	
	form.getcomponent('CLASSIFCONTA').keyup(FormatarMaskaraGrupo);

	function HabilitarAbaContasCalculadas(){
	    
		if ( form.getvalue('TIPOCONTACALC') == 2){
			RestoreTabsCadastro();
		}else{
			RemoverTabCadastro('TnCtbDMCalcPlanoEspec');
		}		
	}
	
	function GrupoDemostrativo(_AClassifConta)
	{
	  Result = -1;
	  if (_AClassifConta != '') {
	    Result = form.configextra.TipoGrupos[_AClassifConta[0]-1];
	  }
	  return Result;
	}

	function FormatarMaskaraGrupo(){
		if (form.configextra != null){
			var AClassifConta = form.getvalue('CLASSIFCONTA');
			if ((AClassifConta != null) && (AClassifConta != '')){
				var AMaskara = form.configextra.MascGrupos[AClassifConta[0] - 1];
				var field = form.fieldbyName('CLASSIFCONTA');

				field.componente.get(0).dataset['mask'] = AMaskara;
				form.setarmascaracampo('CLASSIFCONTA', AMaskara);
				
				var naturezasaldo = form.getvalue('NATURSALDO');
				if ((naturezasaldo == null) || (naturezasaldo == '')){
					form.setvalue('NATURSALDO', form.configextra.NatuGrupos[AClassifConta[0]-1]);
				}
			}
		}
	}

	function PreencherApelido(event){
		if (event.target.value == '') {
      if (acronym) {
        var apelido = acronym({
          separator: [' ', '.', ';', ',', '.', '-', '(', ')'],
          length: 10,
          str: form.getvalue('DESCRCONTA'), 
        });		
         
        form.setfieldvalue('APELIDOCONTA', apelido);
      }
		}
	}
});